/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@geocities.com> --- December 1997
 */

// CvsAlert.cpp : implementation file
//

#include "stdafx.h"

#ifdef macintosh
#	define kDlgIdAlert 129
#	include <Dialogs.h>
#	include <TextUtils.h>
#	include <string.h>
#	include "MacMisc.h"
#endif /* macintosh */

#ifdef qQT
#	include "qcvsapp.h"
#	include "QCvsAlert.h"
#endif /* qQT */

#ifdef WIN32
#	include "resource.h"

#	ifdef _DEBUG
#	define new DEBUG_NEW
#	undef THIS_FILE
	static char THIS_FILE[] = __FILE__;
#	endif
#endif /* WIN32 */

#include "CvsAlert.h"

#ifdef WIN32
/////////////////////////////////////////////////////////////////////////////
// CCVSAlert dialog


CCVSAlert::CCVSAlert(const char *prompt, const char *defhit, const char *cnclhit,
					 CWnd* pParent /*=NULL*/)
	: CDialog(CCVSAlert::IDD, pParent)
{
	//{{AFX_DATA_INIT(CCVSAlert)
	m_prompt = prompt != NULL ? prompt : "";
	m_cnclhit = cnclhit != NULL ? cnclhit : "";
	m_defhit = defhit != NULL ? defhit : "";
	//}}AFX_DATA_INIT
}


void CCVSAlert::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCVSAlert)
	DDX_Text(pDX, IDC_ALRTMSG, m_prompt);
	DDX_Text(pDX, IDCANCEL, m_cnclhit);
	DDX_Text(pDX, IDOK, m_defhit);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CCVSAlert, CDialog)
	//{{AFX_MSG_MAP(CCVSAlert)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCVSAlert message handlers
#endif /* WIN32 */

#ifdef macintosh
	static const char *sPrompt = 0L, *sDefhit = 0L, *sCnclhit = 0L;
	
	static pascal Boolean AlertModalFilter(DialogPtr dlog, EventRecord *event, short *itemHit)
	{
		DialogPtr evtDlog;
		short selStart,selEnd;

		if (event->what == activateEvt && (event->modifiers & activeFlag) != 0)
		{
			Str255 pp, pd, pc;
			strcpy((char *)pp, sPrompt);
			strcpy((char *)pd, sDefhit);
			strcpy((char *)pc, sCnclhit);
			c2pstr((char *)pp);
			c2pstr((char *)pd);
			c2pstr((char *)pc);
			
			SetControlTitle(GetDItemCtrlHdl(dlog, 1), pd);
			SetControlTitle(GetDItemCtrlHdl(dlog, 2), pc);
			SetDialogItemText(GetDItemHdl(dlog, 3), pp);
		}

		return false;		   // For all non-keyDown events
	}
#endif /* macintosh */

bool CvsAlert(const char *prompt, const char *defhit, const char *cnclhit)
{
#ifdef WIN32
	CCVSAlert gv(prompt, defhit, cnclhit);
	return gv.DoModal() == IDOK;
#endif /* WIN32 */
#ifdef macintosh
	static ModalFilterUPP filter = NULL;
	
	if(filter == NULL)
		filter = NewModalFilterProc(AlertModalFilter);
	
	sPrompt = prompt;
	sDefhit = defhit;
	sCnclhit = cnclhit;
	
	return CautionAlert(kDlgIdAlert, filter) == 1;
#endif /* macintosh */
#ifdef qQT
	QCvsAlert alert(prompt, defhit, cnclhit);
	return alert.exec() == QDialog::Accepted;
#endif /* qQT */
}
