/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@geocities.com> --- March 1998
 */

/*
 * CheckoutDlg.h : the cvs checkout dialog
 */

#include "stdafx.h"

#ifdef WIN32
#	include "wincvs.h"
#endif /* WIN32 */

#ifdef qQT
#	include "qcvsapp.h"
#	include "QCheckoutTab.h"
#endif /* qQT */

#ifdef qMacCvsPP
#	include <UModalDialogs.h>
#	include <LMultiPanelView.h>
#	include <LPopupGroupBox.h>
#	include <LCheckBox.h>
#	include <LTextEditView.h>
#	include <LEditText.h>
#	include <LPushButton.h>
#	include "LPopupFiller.h"

#	include "MacCvsApp.h"
#endif /* qMacCvsPP */

#include "CheckoutDlg.h"
#include "CvsPrefs.h"
#include "UpdateDlg.h"
#include "MultiString.h"

CMString gOldModules(10, "P_OldModules");

#ifdef WIN32
#	include "GetPrefs.h"
#	include "PromptFiles.h"
#	ifdef _DEBUG
#	define new DEBUG_NEW
#	undef THIS_FILE
	static char THIS_FILE[] = __FILE__;
#endif

IMPLEMENT_DYNCREATE(CCheckout_MAIN, CPropertyPage)

CCheckout_MAIN::CCheckout_MAIN(const char * modname, const char * path) :
	CPropertyPage(CCheckout_MAIN::IDD)
{
	//{{AFX_DATA_INIT(CCheckout_MAIN)
	m_path = path;
	m_norecurs = FALSE;
	m_stdout = FALSE;
	//}}AFX_DATA_INIT
}

CCheckout_MAIN::CCheckout_MAIN() : CPropertyPage(CCheckout_MAIN::IDD)
{
}

CCheckout_MAIN::~CCheckout_MAIN()
{
}

void CCheckout_MAIN::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);

	//{{AFX_DATA_MAP(CCheckout_MAIN)
	DDX_Control(pDX, IDC_MODNAME, m_modcombo);
	DDX_ComboMString(pDX, IDC_MODNAME, gOldModules, m_modcombo);
	DDX_Text(pDX, IDC_MODNAME, m_modname);
	DDX_Text(pDX, IDC_PATH, m_path);
	DDX_Check(pDX, IDC_NORECURS, m_norecurs);
	DDX_Check(pDX, IDC_STDOUT, m_stdout);
	//}}AFX_DATA_MAP
	DDV_MinChars(pDX, m_modname, 1);
}


BEGIN_MESSAGE_MAP(CCheckout_MAIN, CPropertyPage)
	//{{AFX_MSG_MAP(CCheckout_MAIN)
	ON_BN_CLICKED(IDC_BTNPATH, OnBtnPath)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCheckout_MAIN message handlers

void CCheckout_MAIN::OnBtnPath() 
{
	const char *dir = BrowserGetDirectory("Select a directory to checkout :");
	if(dir != NULL)
		SetDlgItemText(IDC_PATH, dir);
}

IMPLEMENT_DYNCREATE(CCheckout_OPTIONS, CPropertyPage)

CCheckout_OPTIONS::CCheckout_OPTIONS(const char *rev, const char *date) : CPropertyPage(CCheckout_OPTIONS::IDD)
{
	//{{AFX_DATA_INIT(CCheckout_OPTIONS)
	m_date = date;
	m_rev = rev;
	m_hasdate = FALSE;
	m_hasrev = FALSE;
	m_match = FALSE;
	//}}AFX_DATA_INIT
}

CCheckout_OPTIONS::CCheckout_OPTIONS() : CPropertyPage(CCheckout_OPTIONS::IDD)
{
}

CCheckout_OPTIONS::~CCheckout_OPTIONS()
{
}

void CCheckout_OPTIONS::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCheckout_OPTIONS)
	DDX_Control(pDX, IDC_COMBOREV, m_revdef);
	DDX_Control(pDX, IDC_COMBODATE, m_datedef);
	DDX_CBString(pDX, IDC_COMBODATE, m_date);
	DDX_CBString(pDX, IDC_COMBOREV, m_rev);
	DDX_Check(pDX, IDC_DATE, m_hasdate);
	DDX_Check(pDX, IDC_MATCH, m_match);
	DDX_Check(pDX, IDC_REV, m_hasrev);
	//}}AFX_DATA_MAP
	if(m_hasrev)
		DDV_MinChars(pDX, m_rev, 1);
	if(m_hasdate)
		DDV_MinChars(pDX, m_date, 1);
	if(!pDX->m_bSaveAndValidate)
	{
		OnDate();
		OnRev();
	}
	DDX_ComboMString(pDX, IDC_COMBOREV, gRevNames, m_revdef);
	DDX_ComboMString(pDX, IDC_COMBODATE, gDateNames, m_datedef);
}


BEGIN_MESSAGE_MAP(CCheckout_OPTIONS, CPropertyPage)
	//{{AFX_MSG_MAP(CCheckout_OPTIONS)
	ON_BN_CLICKED(IDC_DATE, OnDate)
	ON_BN_CLICKED(IDC_REV, OnRev)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCheckout_OPTIONS message handlers

void CCheckout_OPTIONS::OnDate() 
{
	CButton* but = (CButton *)GetDlgItem(IDC_DATE);
	CWnd* wnd = GetDlgItem(IDC_COMBODATE);
	wnd->EnableWindow(but->GetCheck() == 1);
}

void CCheckout_OPTIONS::OnRev() 
{
	CButton* but = (CButton *)GetDlgItem(IDC_REV);
	CWnd* wnd = GetDlgItem(IDC_COMBOREV);
	wnd->EnableWindow(but->GetCheck() == 1);
}
#endif /* WIN32 */

#ifdef qMacCvsPP
static void DoDataExchange_CheckoutMain(LWindow *theDialog, CPStr & modname,
	bool & norecurs, bool & toStdout, bool putValue)
{
	LEditText *mname = dynamic_cast<LEditText*>
		(theDialog->FindPaneByID(item_ModuleName));
	LCheckBox *chkNoRecurs = dynamic_cast<LCheckBox*>
		(theDialog->FindPaneByID(item_NoRecurs));
	LCheckBox *chkToStdout = dynamic_cast<LCheckBox*>
		(theDialog->FindPaneByID(item_ToStout));
	
	if(putValue)
	{
		mname->SetText((Ptr)(const char *)modname, modname.length());	
		chkNoRecurs->SetValue(norecurs ? Button_On : Button_Off);
		chkToStdout->SetValue(toStdout ? Button_On : Button_Off);
		theDialog->SetLatentSub(mname);
		
		// this will take care about an empty module name
		mname->AddListener(CMacCvsApp::app);
		if(modname.length() == 0)
		{
			LPushButton *theOK = dynamic_cast<LPushButton*>
										(theDialog->FindPaneByID(item_OK));
			Assert_(theOK != 0L);
			theOK->Disable();
		}
	}
	else
	{
		char buf[512];
		Size len;
		mname->GetText(buf, 511, &len);
		modname.set(buf, len);
		
		norecurs = chkNoRecurs->GetValue() == Button_On;
		toStdout = chkToStdout->GetValue() == Button_On;
	}
}

static void DoDataExchange_CheckoutOptions(LWindow *theDialog, bool & hasDate, bool & hasRev,
	CPStr & sLastDate, CPStr & sLastRev, bool & useMostRecent, bool putValue)
{
	LCheckBox *chkHasDate = dynamic_cast<LCheckBox*>
		(theDialog->FindPaneByID(item_CheckDate));
	LCheckBox *chkHasRev = dynamic_cast<LCheckBox*>
		(theDialog->FindPaneByID(item_CheckRevTag));
	LCheckBox *chkMostRecent = dynamic_cast<LCheckBox*>
		(theDialog->FindPaneByID(item_MostRecentRev));
	LEditText *editDate = dynamic_cast<LEditText*>
		(theDialog->FindPaneByID(item_EditDate));
	LEditText *editRev = dynamic_cast<LEditText*>
		(theDialog->FindPaneByID(item_EditRevTag));
	LPopupFiller *fillTag = dynamic_cast<LPopupFiller*>
		(theDialog->FindPaneByID(item_FillerTag));
	LPopupFiller *fillDate = dynamic_cast<LPopupFiller*>
		(theDialog->FindPaneByID(item_FillerDate));
	
	fillTag->DoDataExchange(gRevNames, putValue);
	fillDate->DoDataExchange(gDateNames, putValue);

	if(putValue)
	{
		chkHasDate->SetValue(hasDate ? Button_On : Button_Off);
		chkHasRev->SetValue(hasRev ? Button_On : Button_Off);
		chkMostRecent->SetValue(useMostRecent ? Button_On : Button_Off);
		editDate->SetText((Ptr)(const char *)sLastDate, sLastDate.length());
		editRev->SetText((Ptr)(const char *)sLastRev, sLastRev.length());
	}
	else
	{
		hasDate = chkHasDate->GetValue() == Button_On;
		hasRev = chkHasRev->GetValue() == Button_On;
		useMostRecent = chkMostRecent->GetValue() == Button_On;

		char str[255];
		Size len;
		
		editDate->GetText(str, 254, &len);
		sLastDate.set(str, len);
		editRev->GetText(str, 254, &len);
		sLastRev.set(str, len);
	}
}
#endif /* qMacCvsPP */

bool CompatGetCheckout(CPStr & modname, CPStr & path, bool & norecurs,
					   bool & toStdout, CPStr & date, CPStr & rev,
					   bool & useMostRecent)
{
	bool userHitOK = false;

	date = "";
	rev = "";
	modname = "";
	norecurs = false;
	toStdout = false;
	useMostRecent = false;
	
	bool hasDate = false;
	bool hasRev = false;
	static CPStr sLastModName;
	static CPStr sLastRev;
	static CPStr sLastDate;

#ifdef WIN32
	CPropertySheet pages("Checkout settings");
	CCheckout_MAIN page1(sLastModName, path);
	CCheckout_OPTIONS page2(sLastRev, sLastDate);
	CGetPrefs_GLOBALS page3;
	pages.AddPage(&page1);
	pages.AddPage(&page2);
	pages.AddPage(&page3);
	if(pages.DoModal() == IDOK)
	{
		sLastModName = (const char *)page1.m_modname;
		path = (const char *)page1.m_path;
		norecurs = page1.m_norecurs == TRUE;
		toStdout = page1.m_stdout == TRUE;

		sLastDate = page2.m_date;
		sLastRev = page2.m_rev;
		hasDate = page2.m_hasdate == TRUE;
		hasRev = page2.m_hasrev == TRUE;
		useMostRecent = page2.m_match == TRUE;

		page3.StoreValues();
		userHitOK = true;
	}
#endif /* WIN32 */
#ifdef qMacCvsPP
	StDialogHandler	theHandler(dlg_Checkout, CMacCvsApp::app);
	LWindow *theDialog = theHandler.GetDialog();
	ThrowIfNil_(theDialog);
	static UInt16 sRuntimePanel = 1;
	
	LMultiPanelView *multiView = dynamic_cast<LMultiPanelView*>
		(theDialog->FindPaneByID(item_MultiViewPrefs));
	LPopupGroupBox *groupView = dynamic_cast<LPopupGroupBox*>
		(theDialog->FindPaneByID(item_GroupViewPrefs));
	
	multiView->SwitchToPanel(3);
	DoDataExchange_Globals(theDialog, true);
	multiView->SwitchToPanel(2);
	DoDataExchange_CheckoutOptions(theDialog, hasDate, hasRev,
		sLastDate, sLastRev, useMostRecent, true);
	multiView->SwitchToPanel(1);
	DoDataExchange_CheckoutMain(theDialog, sLastModName, norecurs, toStdout, true);
	
	
	groupView->SetValue(sRuntimePanel);
	theDialog->Show();
	MessageT hitMessage;
	while (true)
	{		// Let DialogHandler process events
		hitMessage = theHandler.DoDialog();
		
		if (hitMessage == msg_OK || hitMessage == msg_Cancel)
			break;
	}
	theDialog->Hide();
	sRuntimePanel = groupView->GetValue();
	
	if(hitMessage == msg_OK)
	{
		multiView->SwitchToPanel(1);
		DoDataExchange_CheckoutMain(theDialog, sLastModName, norecurs, toStdout, false);
		multiView->SwitchToPanel(2);
		DoDataExchange_CheckoutOptions(theDialog, hasDate, hasRev,
			sLastDate, sLastRev, useMostRecent, false);
		multiView->SwitchToPanel(3);
		DoDataExchange_Globals(theDialog, false);
		
		Assert_(sLastModName.length() != 0);
		
		userHitOK = true;
	}
#endif /* qMacCvsPP */
#ifdef qQT
	QCheckoutTab dlg;
	dlg.fDlg1.DoDataExchange(true, sLastModName, norecurs, toStdout, gOldModules);
	dlg.fDlg2.DoDataExchange(true, hasDate, hasRev, sLastDate, sLastRev, useMostRecent, gRevNames, gDateNames);
	dlg.fDlg3.DoDataExchange(true);
	if(dlg.exec() == QDialog::Accepted)
	{
		dlg.fDlg1.DoDataExchange(false, sLastModName, norecurs, toStdout, gOldModules);
		dlg.fDlg2.DoDataExchange(false, hasDate, hasRev, sLastDate, sLastRev, useMostRecent, gRevNames, gDateNames);
		dlg.fDlg3.DoDataExchange(false);
		userHitOK = true;
	}
#endif /* qQT */

	if(userHitOK)
	{
		if(hasDate && !sLastDate.empty())
			date = sLastDate;
		if(hasRev && !sLastRev.empty())
			rev = sLastRev;

		modname = sLastModName;

		gCvsPrefs.save();
	}
	return userHitOK;
}
