/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@geocities.com> --- December 1997
 */

/*
 * Authen.h --- class to manage CVS authentication kind
 */

#ifndef AUTHEN_H
#define AUTHEN_H

#include "Persistent.h"

// authentication class
typedef enum
{
	rhosts, // rhosts file
	pserver, // pserver
	kserver, // kserver
	local, // mounted point
	ssh, // ssh
} AuthenKind;

class Authen
{
public :
	Authen() {}
	
	AuthenKind kind(void);
	const char *kindstr(void);
	void setkind(AuthenKind newkind);
	
	// ":pserver:", ":kserver:"
	const char *token(void);
	static const char * skiptoken(const char *cvsroot);

	// the dialog items associated with
	// should disappear soon with PowerPlant
	void setkindbyitem(short itemid);
	short dlgitem(void);
	static bool isdlgitem(short itemid);
protected :
};

/* for macintosh */
// should disappear soon with PowerPlant
#define kItemRHosts 7
#define kItemPServer 8
#define kItemKServer 9

extern Authen gAuthen;

#endif /* AUTHEN_H */
