/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@geocities.com> --- April 1998
 */

// AskYesNo.cpp : ask yes or no !

#include "stdafx.h"

#ifdef WIN32
#	include "wincvs.h"
#endif /* WIN32 */

#ifdef qQT
#	include "qcvsapp.h"
#	include "QCvsAlert.h"
#endif /* qQT */

#ifdef qMacCvsPP
#	include <UModalDialogs.h>

#	include "MacCvsApp.h"
#endif /* qMacCvsPP */

#include "AskYesNo.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#ifdef WIN32
/////////////////////////////////////////////////////////////////////////////
// CAskYesNo dialog


CAskYesNo::CAskYesNo(CWnd* pParent /*=NULL*/)
	: CDialog(CAskYesNo::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAskYesNo)
	//}}AFX_DATA_INIT
}


void CAskYesNo::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAskYesNo)
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CAskYesNo, CDialog)
	//{{AFX_MSG_MAP(CAskYesNo)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAskYesNo message handlers
#endif /* WIN32 */

const char *AskYesNo(void)
{
#ifdef WIN32
	CAskYesNo gp;
	return gp.DoModal() == IDOK ? "yes" : "no";
#endif /* WIN32 */
#ifdef qMacCvsPP
	return "";
#endif /* qMacCvsPP */
#ifdef qQT
	QCvsAlert alert("cvs is requiring you to answer yes or no (see the console for details)", "No", "Yes");
	return alert.exec() == QDialog::Accepted ? "no" : "yes";
#endif /* qQT */
}
