/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@geocities.com> --- December 1997
 */

/*
 * AppGlue.h --- glue code to access CVS shared library
 */

#ifndef APPGLUE_H
#define APPGLUE_H

#include <stdio.h>

class CCvsConsole
{
public:
	virtual long cvs_out(char *txt, long len) = 0L;
	virtual long cvs_err(char *txt, long len) = 0L;
};

#define errInternal -99
#define errThreadRunning -98

int launchCVS(const char *path, int argc, char * const *argv,
	CCvsConsole * console = 0L);
	// return the exit() error code.
	// optionnaly overides the default console.

class CvsArgs;
class CStr;

FILE *launchCVS(const char *dir, const CvsArgs & args, CStr & tmpFile);
	// make a stream of the cvs output

const char *launchCVS(const char *dir, const CvsArgs & args);
	// put the cvs output in a temp file (the temp file is automatically
	// removed when quitting)

#ifdef WIN32
	void WaitForCvs(void);
		// wait for the cvs thread to terminate
#else
#	define WaitForCvs()
#endif

#ifdef WIN32
#	include "CPStr.h"
#	include "CvsArgs.h"

class CCvsThread : public CWinThread
{
public:
	DECLARE_DYNAMIC(CCvsThread)

	static CRITICAL_SECTION m_lock;
	
	CCvsThread();
	virtual ~CCvsThread();
	void KillThread();
	virtual void Delete();

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CCvsThread)
	//}}AFX_VIRTUAL

protected:
	HINSTANCE mConnID;

	virtual int Launch() = 0L;

	virtual BOOL InitInstance();

	// Generated message map functions
	//{{AFX_MSG(CCvsThread)
		// NOTE - the ClassWizard will add and remove member functions here.
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};

class CCvsThreadLock
{
public:
	CCvsThreadLock()
	{
		EnterCriticalSection(&CCvsThread::m_lock);
	}
	~CCvsThreadLock()
	{
		LeaveCriticalSection(&CCvsThread::m_lock);
	}
};
#endif /* WIN32 */

#endif /* APPGLUE_H */
