/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@geocities.com> --- December 1997
 */

// wincvsDoc.cpp : implementation of the CWincvsDoc class
//

#include "stdafx.h"
#include "wincvs.h"
#include <afxrich.h>

#include "wincvsDoc.h"
#include "CvsCommands.h"
#include "GetPrefs.h"
#include "Authen.h"
#include "CvsPrefs.h"
#include "AppConsole.h"
#include "PromptFiles.h"
#include "WinCvsBrowser.h"
#include "TclGlue.h"
#include "MacrosSetup.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CWincvsDoc

IMPLEMENT_DYNCREATE(CWincvsDoc, CDocument)

BEGIN_MESSAGE_MAP(CWincvsDoc, CDocument)
	//{{AFX_MSG_MAP(CWincvsDoc)
	ON_COMMAND(ID_APP_UPDATE, OnCvsUpdate)
	ON_COMMAND(ID_APP_COMMIT, OnAppCommit)
	ON_COMMAND(ID_APP_PREFERENCES, OnAppPreferences)
	ON_COMMAND(ID_APP_ADD, OnAppAdd)
	ON_COMMAND(ID_APP_ADDF, OnAppAddf)
	ON_COMMAND(ID_APP_CANCELC, OnAppCancelc)
	ON_COMMAND(ID_APP_CHECKOUT, OnAppCheckout)
	ON_COMMAND(ID_APP_CMDLINE, OnAppCmdline)
	ON_COMMAND(ID_APP_COMMITF, OnAppCommitf)
	ON_COMMAND(ID_APP_DIFF, OnAppDiff)
	ON_COMMAND(ID_APP_DIFFF, OnAppDifff)
	ON_COMMAND(ID_APP_IMPORT, OnAppImport)
	ON_COMMAND(ID_APP_LOG, OnAppLog)
	ON_COMMAND(ID_APP_GRAPHF, OnAppLogGraph)
	ON_COMMAND(ID_APP_LOGIN, OnAppLogin)
	ON_COMMAND(ID_APP_REMOVEF, OnAppRemovef)
	ON_COMMAND(ID_APP_UPDATEF, OnAppUpdatef)
	ON_COMMAND(ID_APP_STATUS, OnAppStatus)
	ON_COMMAND(ID_APP_STATUSFO, OnAppStatusfo)
	ON_COMMAND(ID_APP_LOCKF, OnAppLockf)
	ON_COMMAND(ID_APP_UNLOCKF, OnAppUnlockf)
	ON_COMMAND(ID_APP_EDITF, OnAppEditf)
	ON_COMMAND(ID_APP_UNEDITF, OnAppUneditf)
	ON_COMMAND(ID_APP_WATCHONF, OnAppWatchf)
	ON_COMMAND(ID_APP_WATCHOFFF, OnAppUnwatchf)
	ON_COMMAND(ID_APP_WATCHERSF, OnAppWatchersf)
	ON_COMMAND(ID_APP_EDITORSF, OnAppEditorsf)
	ON_COMMAND(ID_APP_LOCK, OnAppLock)
	ON_COMMAND(ID_APP_UNLOCK, OnAppUnlock)
	ON_COMMAND(ID_APP_EDIT, OnAppEdit)
	ON_COMMAND(ID_APP_UNEDIT, OnAppUnedit)
	ON_COMMAND(ID_APP_WATCHON, OnAppWatch)
	ON_COMMAND(ID_APP_WATCHOFF, OnAppUnwatch)
	ON_COMMAND(ID_APP_RELEASE, OnAppRelease)
	ON_COMMAND(ID_APP_WATCHERS, OnAppWatchers)
	ON_COMMAND(ID_APP_EDITORS, OnAppEditors)
	ON_COMMAND(ID_APP_ADDB, OnAppAddb)
	ON_COMMAND(ID_APP_RTAGCREATE, OnAppRtagNew)
	ON_COMMAND(ID_APP_RTAGDELETE, OnAppRtagDelete)
	ON_COMMAND(ID_APP_RTAGBRANCH, OnAppRtagBranch)
	ON_COMMAND(ID_APP_TAGNEW, OnAppTagNew)
	ON_COMMAND(ID_APP_TAGDELETE, OnAppTagDelete)
	ON_COMMAND(ID_APP_TAGBRANCH, OnAppTagBranch)
	ON_COMMAND(ID_APP_TAGNEWF, OnAppTagNewf)
	ON_COMMAND(ID_APP_TAGDELETEF, OnAppTagDeletef)
	ON_COMMAND(ID_APP_TAGBRANCHF, OnAppTagBranchf)
	ON_UPDATE_COMMAND_UI(ID_APP_RTAGCREATE, OnUpdateCvsCmd)
	ON_COMMAND(ID_STOPCVS, OnStopcvs)
	ON_UPDATE_COMMAND_UI(ID_STOPCVS, OnUpdateStopcvs)
	ON_COMMAND(ID_APP_LOGF, OnAppLogf)
	ON_COMMAND(ID_BROWSER_OPEN, OnBrowserOpen)
	ON_UPDATE_COMMAND_UI(ID_MACRO_FILES, OnUpdateMacroFiles)
	ON_UPDATE_COMMAND_UI(ID_MACRO_FOLDER, OnUpdateMacroFolder)
	ON_UPDATE_COMMAND_UI(ID_MACRO_ADMIN, OnUpdateMacroAdmin)
	ON_UPDATE_COMMAND_UI(ID_APP_RTAGDELETE, OnUpdateCvsCmd)
	ON_UPDATE_COMMAND_UI(ID_APP_RTAGBRANCH, OnUpdateCvsCmd)
	ON_UPDATE_COMMAND_UI(ID_APP_UPDATE, OnUpdateCvsCmd)
	ON_UPDATE_COMMAND_UI(ID_APP_COMMIT, OnUpdateCvsCmd)
	ON_UPDATE_COMMAND_UI(ID_APP_PREFERENCES, OnUpdateCvsCmd)
	ON_UPDATE_COMMAND_UI(ID_APP_ADD, OnUpdateCvsCmd)
	ON_UPDATE_COMMAND_UI(ID_APP_CHECKOUT, OnUpdateCvsCmd)
	ON_UPDATE_COMMAND_UI(ID_APP_ADDF, OnUpdateCvsCmd)
	ON_UPDATE_COMMAND_UI(ID_APP_CANCELC, OnUpdateCvsCmd)
	ON_UPDATE_COMMAND_UI(ID_APP_CHECKOUT, OnUpdateCvsCmd)
	ON_UPDATE_COMMAND_UI(ID_APP_CMDLINE, OnUpdateCvsCmd)
	ON_UPDATE_COMMAND_UI(ID_APP_COMMITF, OnUpdateCvsCmd)
	ON_UPDATE_COMMAND_UI(ID_APP_DIFF, OnUpdateCvsCmd)
	ON_UPDATE_COMMAND_UI(ID_APP_DIFFF, OnUpdateCvsCmd)
	ON_UPDATE_COMMAND_UI(ID_APP_IMPORT, OnUpdateCvsCmd)
	ON_UPDATE_COMMAND_UI(ID_APP_LOG, OnUpdateCvsCmd)
	ON_UPDATE_COMMAND_UI(ID_APP_LOGIN, OnUpdateCvsCmd)
	ON_UPDATE_COMMAND_UI(ID_APP_REMOVEF, OnUpdateCvsCmd)
	ON_UPDATE_COMMAND_UI(ID_APP_STATUS, OnUpdateCvsCmd)
	ON_UPDATE_COMMAND_UI(ID_APP_UPDATEF, OnUpdateCvsCmd)
	ON_UPDATE_COMMAND_UI(ID_APP_GRAPHF, OnUpdateCvsCmd)
	ON_UPDATE_COMMAND_UI(ID_APP_ADDB, OnUpdateCvsCmd)
	ON_UPDATE_COMMAND_UI(ID_APP_LOGF, OnUpdateCvsCmd)
	ON_UPDATE_COMMAND_UI(ID_APP_LOCKF, OnUpdateCvsCmd)
	ON_UPDATE_COMMAND_UI(ID_APP_UNLOCKF, OnUpdateCvsCmd)
	ON_UPDATE_COMMAND_UI(ID_APP_STATUSFO, OnUpdateCvsCmd)
	ON_UPDATE_COMMAND_UI(ID_APP_EDITF, OnUpdateCvsCmd)
	ON_UPDATE_COMMAND_UI(ID_APP_UNEDITF, OnUpdateCvsCmd)
	ON_UPDATE_COMMAND_UI(ID_APP_WATCHONF, OnUpdateCvsCmd)
	ON_UPDATE_COMMAND_UI(ID_APP_WATCHOFFF, OnUpdateCvsCmd)
	ON_UPDATE_COMMAND_UI(ID_APP_WATCHERSF, OnUpdateCvsCmd)
	ON_UPDATE_COMMAND_UI(ID_APP_EDITORSF, OnUpdateCvsCmd)
	ON_UPDATE_COMMAND_UI(ID_APP_LOCK, OnUpdateCvsCmd)
	ON_UPDATE_COMMAND_UI(ID_APP_UNLOCK, OnUpdateCvsCmd)
	ON_UPDATE_COMMAND_UI(ID_APP_EDIT, OnUpdateCvsCmd)
	ON_UPDATE_COMMAND_UI(ID_APP_UNEDIT, OnUpdateCvsCmd)
	ON_UPDATE_COMMAND_UI(ID_APP_WATCHON, OnUpdateCvsCmd)
	ON_UPDATE_COMMAND_UI(ID_APP_WATCHOFF, OnUpdateCvsCmd)
	ON_UPDATE_COMMAND_UI(ID_APP_RELEASE, OnUpdateCvsCmd)
	ON_UPDATE_COMMAND_UI(ID_APP_WATCHERS, OnUpdateCvsCmd)
	ON_UPDATE_COMMAND_UI(ID_APP_EDITORS, OnUpdateCvsCmd)
	ON_UPDATE_COMMAND_UI(ID_BROWSER_OPEN, OnUpdateCvsCmd)
	ON_UPDATE_COMMAND_UI(ID_APP_TAGNEW, OnUpdateCvsCmd)
	ON_UPDATE_COMMAND_UI(ID_APP_TAGDELETE, OnUpdateCvsCmd)
	ON_UPDATE_COMMAND_UI(ID_APP_TAGBRANCH, OnUpdateCvsCmd)
	ON_UPDATE_COMMAND_UI(ID_APP_TAGNEWF, OnUpdateCvsCmd)
	ON_UPDATE_COMMAND_UI(ID_APP_TAGDELETEF, OnUpdateCvsCmd)
	ON_UPDATE_COMMAND_UI(ID_APP_TAGBRANCHF, OnUpdateCvsCmd)
	ON_UPDATE_COMMAND_UI(ID_APP_LOGOUT, OnUpdateCvsCmd)
	ON_COMMAND(ID_APP_LOGOUT, OnAppLogout)
	//}}AFX_MSG_MAP
	// Enable default OLE container implementation
	//ON_UPDATE_COMMAND_UI(ID_EDIT_PASTE, CDocument::OnUpdatePasteMenu)
	ON_COMMAND_EX_RANGE(ID_MACRO_ADMIN, ID_MACRO_ADMIN + 99, OnMacroAdmin)
	ON_COMMAND_EX_RANGE(ID_MACRO_FOLDER, ID_MACRO_FOLDER + 99, OnMacroFolder)
	ON_COMMAND_EX_RANGE(ID_MACRO_FILES, ID_MACRO_FILES + 99, OnMacroFiles)
	ON_COMMAND(ID_FILE_SEND_MAIL, OnFileSendMail)
	ON_UPDATE_COMMAND_UI(ID_FILE_SEND_MAIL, OnUpdateFileSendMail)
END_MESSAGE_MAP()

BEGIN_DISPATCH_MAP(CWincvsDoc, CDocument)
	//{{AFX_DISPATCH_MAP(CWincvsDoc)
	DISP_PROPERTY_NOTIFY(CWincvsDoc, "ViewPath", m_viewPath, OnViewPathChanged, VT_BSTR)
	//}}AFX_DISPATCH_MAP
END_DISPATCH_MAP()

// Note: we add support for IID_IWincvs to support typesafe binding
//  from VBA.  This IID must match the GUID that is attached to the 
//  dispinterface in the .ODL file.

// {D2D77DC4-8299-11D1-8949-444553540000}
static const IID IID_IWincvs =
{ 0xd2d77dc4, 0x8299, 0x11d1, { 0x89, 0x49, 0x44, 0x45, 0x53, 0x54, 0x0, 0x0 } };

BEGIN_INTERFACE_MAP(CWincvsDoc, CDocument)
	INTERFACE_PART(CWincvsDoc, IID_IWincvs, Dispatch)
END_INTERFACE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWincvsDoc construction/destruction

CWincvsDoc::CWincvsDoc()
{
	// Use OLE compound files
	//EnableCompoundFile();

	// TODO: add one-time construction code here

	//EnableAutomation();

	//AfxOleLockApp();
}

CWincvsDoc::~CWincvsDoc()
{
	//AfxOleUnlockApp();
}

//CRichEditCntrItem* CWincvsDoc::CreateClientItem(REOBJECT* preo) const
//{
//	return new CRichEditCntrItem(preo, (CRichEditDoc *)this);
//}

BOOL CWincvsDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	// load preferences. If CVSROOT is not defined
	// then prompt first preferences dialog.
	if(gCvsPrefs.empty())
		OnAppPreferences();
	else
		cvs_out("CVSROOT: %s (%s)\n", (const char *)gCvsPrefs, gAuthen.kindstr());

	if(CTcl_Interp::IsAvail())
	{
		cvs_out("TCL is available, shell is enabled : help (select and press enter)\n");
	}
	else
	{
		cvs_err("TCL is *not* available, shell is disabled\n");
	}

	return TRUE;
}



/////////////////////////////////////////////////////////////////////////////
// CWincvsDoc serialization

class _afxRichEditCookie
{
public:
	CArchive& m_ar;
	DWORD m_dwError;
	_afxRichEditCookie(CArchive& ar) : m_ar(ar) {m_dwError=0;}
};

// return 0 for no error, otherwise return error code
extern "C" DWORD CALLBACK EditStreamCallBack(DWORD dwCookie, LPBYTE pbBuff, LONG cb, LONG *pcb)
{
	_afxRichEditCookie* pCookie = (_afxRichEditCookie*)dwCookie;
	CArchive& ar = pCookie->m_ar;
	ar.Flush();
	DWORD dw = 0;
	*pcb = cb;
	TRY
	{
		if (ar.IsStoring())
			ar.GetFile()->WriteHuge(pbBuff, cb);
		else
			*pcb = ar.GetFile()->ReadHuge(pbBuff, cb);
	}
	CATCH(CFileException, e)
	{
		*pcb = 0;
		pCookie->m_dwError = (DWORD)e->m_cause;
		dw = 1;
	}
	AND_CATCH_ALL(e)
	{
		*pcb = 0;
		pCookie->m_dwError = (DWORD)CFileException::generic;
		dw = 1;
	}
	END_CATCH_ALL
	return dw;
}

void CWincvsDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		POSITION pos = GetFirstViewPosition();
		CView* view;
		while((view = GetNextView(pos)) != NULL)
		{
			if(view->IsKindOf(RUNTIME_CLASS(CRichEditView)))
			{
				int nFormat = SF_TEXT;
				EDITSTREAM es = {0, 0, (EDITSTREAMCALLBACK)EditStreamCallBack};
				_afxRichEditCookie cookie(ar);
				es.dwCookie = (DWORD)&cookie;
				((CRichEditView *)view)->GetRichEditCtrl().StreamOut(nFormat, es);
				break;
			}
		}
	}
	else
	{
		// We don't load right now
	}

	// Calling the base class CDocument enables serialization
	//  of the container document's COleClientItem objects.
	// (but we don't have COleClientItem)
	CDocument::Serialize(ar);
}

/////////////////////////////////////////////////////////////////////////////
// CWincvsDoc diagnostics

#ifdef _DEBUG
void CWincvsDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CWincvsDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CWincvsDoc commands


void CWincvsDoc::OnCvsUpdate() 
{
	CvsCmdUpdateFolder();
}

void CWincvsDoc::OnAppCommit() 
{
	CvsCmdCommitFolder();
}

void CWincvsDoc::OnAppPreferences()
{
	CompatGetPrefs();
}

void CWincvsDoc::OnAppAdd() 
{
	CvsCmdAddFolder();
}

void CWincvsDoc::OnAppAddf() 
{
	CvsCmdAddFiles();
}

void CWincvsDoc::OnAppCancelc() 
{
	CvsCmdCancelChangesFiles();
}

void CWincvsDoc::OnAppCheckout() 
{
	CvsCmdCheckoutModule();
}

void CWincvsDoc::OnAppCmdline() 
{
	CvsCmdLine();
}

void CWincvsDoc::OnAppCommitf() 
{
	CvsCmdCommitFiles();
}

void CWincvsDoc::OnAppDiff() 
{
	CvsCmdDiffFiles();
}

void CWincvsDoc::OnAppDifff() 
{
	CvsCmdDiffFolder();
}

void CWincvsDoc::OnAppImport() 
{
	CvsCmdImportModule();
}

void CWincvsDoc::OnAppLog() 
{
	CvsCmdLogFiles();
}

void CWincvsDoc::OnAppLogGraph() 
{
	CvsCmdLogFiles(0L, true);
}

void CWincvsDoc::OnAppLogin() 
{
	CvsCmdLogin();
}

void CWincvsDoc::OnAppRemovef() 
{
	CvsCmdRemoveFiles();	
}

void CWincvsDoc::OnAppStatus() 
{
	CvsCmdStatusFiles();
}

void CWincvsDoc::OnAppUpdatef() 
{
	CvsCmdUpdateFiles();
}

void CWincvsDoc::OnAppLockf() 
{
	CvsCmdLockFiles();
}

void CWincvsDoc::OnAppUnlockf() 
{
	CvsCmdUnlockFiles();
}

void CWincvsDoc::OnAppStatusfo() 
{
	CvsCmdStatusFolder();
}

void CWincvsDoc::OnAppEditf() 
{
	CvsCmdEditFiles();
}

void CWincvsDoc::OnAppUneditf() 
{
	CvsCmdUneditFiles();
}

void CWincvsDoc::OnAppWatchf() 
{
	CvsCmdWatchOnFiles();
}

void CWincvsDoc::OnAppUnwatchf() 
{
	CvsCmdWatchOffFiles();
}

void CWincvsDoc::OnAppWatchersf() 
{
	CvsCmdWatchersFiles();
}

void CWincvsDoc::OnAppEditorsf() 
{
	CvsCmdEditorsFiles();
}

void CWincvsDoc::OnAppLock() 
{
	CvsCmdLockFolder();
}

void CWincvsDoc::OnAppUnlock() 
{
	CvsCmdUnlockFolder();
}

void CWincvsDoc::OnAppEdit() 
{
	CvsCmdEditFolder();
}

void CWincvsDoc::OnAppUnedit() 
{
	CvsCmdUneditFolder();
}

void CWincvsDoc::OnAppWatch() 
{
	CvsCmdWatchOnFolder();
}

void CWincvsDoc::OnAppUnwatch() 
{
	CvsCmdWatchOffFolder();
}

void CWincvsDoc::OnAppRelease() 
{
	CvsCmdReleaseFolder();
}

void CWincvsDoc::OnAppWatchers()
{
	CvsCmdWatchersFolder();
}

void CWincvsDoc::OnAppEditors() 
{
	CvsCmdEditorsFolder();
}

void CWincvsDoc::OnAppAddb() 
{
	CvsCmdAddBinaryFiles();
}

void CWincvsDoc::OnUpdateCvsCmd(CCmdUI* pCmdUI) 
{
	CWincvsApp* app = (CWincvsApp *)AfxGetApp();
	pCmdUI->Enable(app->gCvsRunning || gCvsPrefs.empty() ? FALSE : TRUE);
}

void CWincvsDoc::OnStopcvs() 
{
	CWincvsApp* app = (CWincvsApp *)AfxGetApp();
	app->gCvsStopping = true;	
}

void CWincvsDoc::OnUpdateStopcvs(CCmdUI* pCmdUI) 
{
	CWincvsApp* app = (CWincvsApp *)AfxGetApp();
	pCmdUI->Enable(app->gCvsRunning && !app->gCvsStopping ? TRUE : FALSE);
}

void CWincvsDoc::OnAppLogf() 
{
	CvsCmdLogFolder();
}

void CWincvsDoc::OnBrowserOpen() 
{
	const char *newPath =
		BrowserGetDirectory("Select a folder to open with the browser");
	if(newPath == 0L)
		return;

	CWincvsApp* app = (CWincvsApp *)AfxGetApp();
	app->GetBrowserView()->ResetBrowser(newPath, true);	
}

void CWincvsDoc::OnViewPathChanged() 
{
	// TODO: Add notification handler code

}

void CWincvsDoc::OnAppRtagNew() 
{
	CvsCmdRtagCreate();
}

void CWincvsDoc::OnAppRtagDelete()
{
	CvsCmdRtagDelete();
}

void CWincvsDoc::OnAppRtagBranch() 
{
	CvsCmdRtagBranch();
}

void CWincvsDoc::OnAppTagNew()
{
	CvsCmdTagCreateFolder();
}

void CWincvsDoc::OnAppTagDelete()
{
	CvsCmdTagDeleteFolder();
}

void CWincvsDoc::OnAppTagBranch()
{
	CvsCmdTagBranchFolder();
}

void CWincvsDoc::OnAppTagNewf()
{
	CvsCmdTagCreateFiles();
}

void CWincvsDoc::OnAppTagDeletef()
{
	CvsCmdTagDeleteFiles();
}

void CWincvsDoc::OnAppTagBranchf()
{
	CvsCmdTagBranchFiles();
}

BOOL CWincvsDoc::OnMacroFiles(UINT nID)
{
	CMacroEntry & entry = gMacrosFiles.entries[nID - ID_MACRO_FILES];
	CvsCmdMacrosFiles(entry.path);

	return 1;
}

void CWincvsDoc::OnUpdateMacroFiles(CCmdUI* pCmdUI) 
{
	CWincvsApp* app = (CWincvsApp *)AfxGetApp();
	if(app->gCvsRunning || gCvsPrefs.empty() || !CTcl_Interp::IsAvail())
	{
		pCmdUI->Enable(FALSE);
		return;
	}

	if(pCmdUI->m_pSubMenu != 0L || pCmdUI->m_pMenu == 0L)
		return;

	int iMRUMax = pCmdUI->m_pMenu->GetMenuItemCount();
	for (int iMRU = 0; iMRU < iMRUMax; iMRU++)
		pCmdUI->m_pMenu->DeleteMenu(pCmdUI->m_nID + iMRU, MF_BYCOMMAND);

	vector<CMacroEntry>::const_iterator i;
	for(i = gMacrosFiles.entries.begin(); i != gMacrosFiles.entries.end(); ++i)
	{
		pCmdUI->m_pMenu->InsertMenu(pCmdUI->m_nIndex++,
			MF_STRING | MF_BYPOSITION, pCmdUI->m_nID++,
			(*i).name);
	}

	pCmdUI->m_nIndexMax = pCmdUI->m_pMenu->GetMenuItemCount();
	pCmdUI->m_nIndex--; // point to last menu added
	pCmdUI->m_bEnableChanged = TRUE;    // all the added items are enabled
}

BOOL CWincvsDoc::OnMacroFolder(UINT nID)
{
	CMacroEntry & entry = gMacrosFolder.entries[nID - ID_MACRO_FOLDER];
	CvsCmdMacrosFolder(entry.path);

	return 1;
}

void CWincvsDoc::OnUpdateMacroFolder(CCmdUI* pCmdUI) 
{
	CWincvsApp* app = (CWincvsApp *)AfxGetApp();
	if(app->gCvsRunning || gCvsPrefs.empty() || !CTcl_Interp::IsAvail())
	{
		pCmdUI->Enable(FALSE);
		return;
	}

	if(pCmdUI->m_pSubMenu != 0L || pCmdUI->m_pMenu == 0L)
		return;

	int iMRUMax = pCmdUI->m_pMenu->GetMenuItemCount();
	for (int iMRU = 0; iMRU < iMRUMax; iMRU++)
		pCmdUI->m_pMenu->DeleteMenu(pCmdUI->m_nID + iMRU, MF_BYCOMMAND);

	vector<CMacroEntry>::const_iterator i;
	for(i = gMacrosFolder.entries.begin(); i != gMacrosFolder.entries.end(); ++i)
	{
		pCmdUI->m_pMenu->InsertMenu(pCmdUI->m_nIndex++,
			MF_STRING | MF_BYPOSITION, pCmdUI->m_nID++,
			(*i).name);
	}

	pCmdUI->m_nIndexMax = pCmdUI->m_pMenu->GetMenuItemCount();
	pCmdUI->m_nIndex--; // point to last menu added
	pCmdUI->m_bEnableChanged = TRUE;    // all the added items are enabled
}

BOOL CWincvsDoc::OnMacroAdmin(UINT nID)
{
	CMacroEntry & entry = gMacrosAdmin.entries[nID - ID_MACRO_ADMIN];
	CvsCmdMacrosAdmin(entry.path);

	return 1;
}

void CWincvsDoc::OnUpdateMacroAdmin(CCmdUI* pCmdUI) 
{
	CWincvsApp* app = (CWincvsApp *)AfxGetApp();
	if(app->gCvsRunning || gCvsPrefs.empty() || !CTcl_Interp::IsAvail())
	{
		pCmdUI->Enable(FALSE);
		return;
	}

	if(pCmdUI->m_pSubMenu != 0L || pCmdUI->m_pMenu == 0L)
		return;

	int iMRUMax = pCmdUI->m_pMenu->GetMenuItemCount();
	for (int iMRU = 0; iMRU < iMRUMax; iMRU++)
		pCmdUI->m_pMenu->DeleteMenu(pCmdUI->m_nID + iMRU, MF_BYCOMMAND);

	vector<CMacroEntry>::const_iterator i;
	for(i = gMacrosAdmin.entries.begin(); i != gMacrosAdmin.entries.end(); ++i)
	{
		pCmdUI->m_pMenu->InsertMenu(pCmdUI->m_nIndex++,
			MF_STRING | MF_BYPOSITION, pCmdUI->m_nID++,
			(*i).name);
	}

	pCmdUI->m_nIndexMax = pCmdUI->m_pMenu->GetMenuItemCount();
	pCmdUI->m_nIndex--; // point to last menu added
	pCmdUI->m_bEnableChanged = TRUE;    // all the added items are enabled
}

void CWincvsDoc::OnAppLogout() 
{
	CvsCmdLogout();
}
