/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@geocities.com> --- December 1997
 */

// MainFrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
#include "wincvs.h"

#include "MainFrm.h"
#include "WinCvsBrowser.h"
#include "BrowseFileView.h"
#include "WincvsView.h"
#include "Persistent.h"
#include "AppConsole.h"
#include "Splash.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

class CWinPlacement : public CPersistent
{
public:
	WINDOWPLACEMENT placement;
	bool hasOne;

	CWinPlacement(const char *uniqueName)
	{
		hasOne = false;
		CPersistent::Register(this, uniqueName);
	}
	virtual ~CWinPlacement()
	{
		CPersistent::UnRegister(this);
	}

	virtual unsigned int SizeOf(void) const
	{
		return hasOne ? sizeof(WINDOWPLACEMENT) : 0;
	}
	
	virtual const void *GetData(void) const
	{
		return hasOne ? &placement : 0L;
	}
	
	virtual void SetData(const void *ptr, unsigned int size)
	{
		if(size == sizeof(WINDOWPLACEMENT))
		{
			memcpy(&placement, ptr, sizeof(WINDOWPLACEMENT));
			hasOne = true;
		}
	}

	CWinPlacement & operator=(const WINDOWPLACEMENT & newplace)
	{
		memcpy(&placement, &newplace, sizeof(WINDOWPLACEMENT));
		hasOne = true;
		return *this;
	}
};

static CWinPlacement gMainPlacement("P_MainPlacement");

#if 0
BEGIN_MESSAGE_MAP(CBrowseBar, CToolBar)
	//{{AFX_MSG_MAP(CBrowseBar)
	//}}AFX_MSG_MAP
	ON_CBN_SELCHANGE(IDS_COMBOBROWSER, OnSelChange)	
END_MESSAGE_MAP()


void CBrowseBar::OnSelChange()
{
	int sel = m_comboBox.GetCurSel();
	if(sel == CB_ERR)
		return;

	CString str;
	m_comboBox.GetLBText(sel, str);

	CWincvsApp* app = (CWincvsApp *)AfxGetApp();
	app->GetBrowserView()->ResetBrowser(str);
}
#endif

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNAMIC(CMainFrame, CMDIFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CMDIFrameWnd)
	ON_WM_INITMENU()
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_WM_CLOSE()
	ON_COMMAND(ID_VIEW_BROWSER_BAR, OnViewBrowserBar)
	ON_UPDATE_COMMAND_UI(ID_VIEW_BROWSER_BAR, OnUpdateViewBrowserBar)
	ON_COMMAND(ID_VIEW_FILES_BAR, OnViewFilesBar)
	ON_UPDATE_COMMAND_UI(ID_VIEW_FILES_BAR, OnUpdateViewFilesBar)
	ON_COMMAND(ID_VIEW_MULTI_BAR, OnViewMultiBar)
	ON_UPDATE_COMMAND_UI(ID_VIEW_MULTI_BAR, OnUpdateViewMultiBar)
	ON_WM_DROPFILES()
	ON_COMMAND(ID_VIEW_TAGS_BAR, OnViewTagsBar)
	ON_UPDATE_COMMAND_UI(ID_VIEW_TAGS_BAR, OnUpdateViewTagsBar)
	//}}AFX_MSG_MAP
	// Global help commands
	ON_COMMAND(ID_HELP_FINDER, CMDIFrameWnd::OnHelpFinder)
	ON_COMMAND(ID_HELP, CMDIFrameWnd::OnHelp)
	ON_COMMAND(ID_CONTEXT_HELP, CMDIFrameWnd::OnContextHelp)
	ON_COMMAND(ID_DEFAULT_HELP, CMDIFrameWnd::OnHelpFinder)
END_MESSAGE_MAP()

static UINT indicators[] =
{
	ID_SEPARATOR,           // status line indicator
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL,
};

#if 0
static UINT BASED_CODE browses[] =
{
	ID_SEPARATOR,           // for combo box (placeholder)
	ID_SEPARATOR,
	ID_BROWSER_OPEN,
	ID_SEPARATOR,
	ID_STOPCVS,
};
#endif

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame()
{
	// TODO: add member initialization code here
	
}

CMainFrame::~CMainFrame()
{
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CMDIFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	if (!m_wndToolBar.Create(this) ||
		!m_wndToolBar.LoadToolBar(IDR_MAINFRAME))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // fail to create
	}

	if (!m_wndBrowser.Create(this, WS_CHILD | WS_VISIBLE | CBRS_TOP, 999 - 1) ||
//		!m_wndBrowser.LoadBitmap(IDB_BROWSER) ||
//		!m_wndBrowser.SetButtons(browses, sizeof(browses)/sizeof(UINT)))
		!m_wndBrowser.LoadToolBar(IDR_BROWSER))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // fail to create
	}

	if (!m_wndList.Create(this, WS_CHILD | WS_VISIBLE | CBRS_TOP, 999 - 2) ||
		!m_wndList.LoadToolBar(IDR_FILELIST))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // fail to create
	}

	if (!m_wndMultiUser.Create(this, WS_CHILD | WS_VISIBLE | CBRS_TOP, 999 - 3) ||
		!m_wndMultiUser.LoadToolBar(IDR_MULTIUSER))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // fail to create
	}

	if (!m_wndTags.Create(this, WS_CHILD | WS_VISIBLE | CBRS_TOP, 999 - 4) ||
		!m_wndTags.LoadToolBar(IDR_TAGS))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // fail to create
	}

	if (!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators,
		  sizeof(indicators)/sizeof(UINT)))
	{
		TRACE0("Failed to create status bar\n");
		return -1;      // fail to create
	}

	EnableDocking(CBRS_ALIGN_ANY);

	m_wndToolBar.SetWindowText("Main toolbar");
	m_wndToolBar.SetBarStyle(m_wndToolBar.GetBarStyle() |
		CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC);
	m_wndToolBar.EnableDocking(CBRS_ALIGN_ANY);
	DockControlBar(&m_wndToolBar,AFX_IDW_DOCKBAR_TOP);

	m_wndBrowser.SetWindowText("Browser toolbar");
	m_wndBrowser.SetBarStyle(m_wndBrowser.GetBarStyle() |
		CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC);
	m_wndBrowser.EnableDocking(CBRS_ALIGN_ANY);
	DockControlBarLeftOf(&m_wndBrowser,&m_wndToolBar);

	m_wndList.SetWindowText("View toolbar");
	m_wndList.SetBarStyle(m_wndList.GetBarStyle() |
		CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC);
	m_wndList.EnableDocking(CBRS_ALIGN_ANY);
	DockControlBarLeftOf(&m_wndList,&m_wndBrowser);

	m_wndMultiUser.SetWindowText("Watchers toolbar");
	m_wndMultiUser.SetBarStyle(m_wndMultiUser.GetBarStyle() |
		CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC);
	m_wndMultiUser.EnableDocking(CBRS_ALIGN_ANY);
	DockControlBarLeftOf(&m_wndMultiUser,&m_wndList);

	m_wndTags.SetWindowText("Tags toolbar");
	m_wndTags.SetBarStyle(m_wndTags.GetBarStyle() |
		CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC);
	m_wndTags.EnableDocking(CBRS_ALIGN_ANY);
	DockControlBarLeftOf(&m_wndTags,&m_wndMultiUser);

	LoadBarState(_T("P_AllToolbars"));

	// CG: The following line was added by the Splash Screen component.
	CSplashWnd::ShowSplashScreen(this);
	return 0;
}

void CMainFrame::DockControlBarLeftOf(CToolBar* Bar,CToolBar* LeftOf)
{
	CRect rect;
	DWORD dw;
	UINT n;

	// get MFC to adjust the dimensions of all docked ToolBars
	// so that GetWindowRect will be accurate
	RecalcLayout();
	LeftOf->GetWindowRect(&rect);
	rect.OffsetRect(1,0);
	dw=LeftOf->GetBarStyle();
	n = 0;
	n = (dw&CBRS_ALIGN_TOP) ? AFX_IDW_DOCKBAR_TOP : n;
	n = (dw&CBRS_ALIGN_BOTTOM && n==0) ? AFX_IDW_DOCKBAR_BOTTOM : n;
	n = (dw&CBRS_ALIGN_LEFT && n==0) ? AFX_IDW_DOCKBAR_LEFT : n;
	n = (dw&CBRS_ALIGN_RIGHT && n==0) ? AFX_IDW_DOCKBAR_RIGHT : n;

	// When we take the default parameters on rect, DockControlBar will dock
	// each Toolbar on a seperate line.  By calculating a rectangle, we in effect
	// are simulating a Toolbar being dragged to that location and docked.
	DockControlBar(Bar,n,&rect);
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CMDIFrameWnd::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CMDIFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CMDIFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers

void CMainFrame::OnViewBrowserBar() 
{
	ShowControlBar(&m_wndBrowser, (m_wndBrowser.GetStyle() & WS_VISIBLE) == 0, FALSE);
}

void CMainFrame::OnUpdateViewBrowserBar(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck((m_wndBrowser.GetStyle() & WS_VISIBLE) != 0);
}

void CMainFrame::OnClose() 
{
	// only way I found to notify the browser
	// and to prevent the memory leak support.
	CWincvsApp* app = (CWincvsApp *)AfxGetApp();
	app->GetBrowserView()->ResetBrowser(0L);	

	SaveBarState(_T("P_AllToolbars"));

	WINDOWPLACEMENT wp;
	wp.length = sizeof wp;
	if (GetWindowPlacement(&wp)) {
		wp.flags &= WPF_RESTORETOMAXIMIZED;
		gMainPlacement = wp;
	}

	CMDIFrameWnd::OnClose();

	// write all the persistents to the .INI file
	CPersistent::SaveAll();
}

void CMainFrame::OnViewFilesBar() 
{
	ShowControlBar(&m_wndList, (m_wndList.GetStyle() & WS_VISIBLE) == 0, FALSE);
}

void CMainFrame::OnUpdateViewFilesBar(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck((m_wndList.GetStyle() & WS_VISIBLE) != 0);
}

void CMainFrame::OnViewMultiBar() 
{
	ShowControlBar(&m_wndMultiUser, (m_wndMultiUser.GetStyle() & WS_VISIBLE) == 0, FALSE);
}

void CMainFrame::OnUpdateViewMultiBar(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck((m_wndMultiUser.GetStyle() & WS_VISIBLE) != 0);
}

void CMainFrame::OnDropFiles(HDROP hDropInfo) 
{
	SetActiveWindow();      // activate us first !
	UINT nFiles = ::DragQueryFile(hDropInfo, (UINT)-1, NULL, 0);

	CWinApp* pApp = AfxGetApp();
	for (UINT iFile = 0; iFile < nFiles; iFile++)
	{
		TCHAR szFileName[_MAX_PATH];
		::DragQueryFile(hDropInfo, iFile, szFileName, _MAX_PATH);

		// replace \ by /
		TCHAR *tmp = szFileName;
		while((tmp = strchr(tmp, '\\')) != 0L)
		{
			*tmp++ = '/';
		}

		cvs_out("%s\n", szFileName);
		//pApp->OpenDocumentFile(szFileName);
	}
	::DragFinish(hDropInfo);
}

void CMainFrame::OnInitMenu(CMenu* pMenu)
{
   CMDIFrameWnd::OnInitMenu(pMenu);
  
	// CG: This block added by 'Tip of the Day' component.
	{
		// TODO: This code adds the "Tip of the Day" menu item
		// on the fly.  It may be removed after adding the menu
		// item to all applicable menu items using the resource
		// editor.

		// Add Tip of the Day menu item on the fly!
		static CMenu* pSubMenu = NULL;

		CString strHelp; strHelp.LoadString(CG_IDS_TIPOFTHEDAYHELP);
		CString strMenu;
		int nMenuCount = pMenu->GetMenuItemCount();
		BOOL bFound = FALSE;
		for (int i=0; i < nMenuCount; i++) 
		{
			pMenu->GetMenuString(i, strMenu, MF_BYPOSITION);
			if (strMenu == strHelp)
			{ 
				pSubMenu = pMenu->GetSubMenu(i);
				bFound = TRUE;
				ASSERT(pSubMenu != NULL);
			}
		}

		CString strTipMenu;
		strTipMenu.LoadString(CG_IDS_TIPOFTHEDAYMENU);
		if (!bFound)
		{
			// Help menu is not available. Please add it!
			if (pSubMenu == NULL) 
			{
				// The same pop-up menu is shared between mainfrm and frame 
				// with the doc.
				static CMenu popUpMenu;
				pSubMenu = &popUpMenu;
				pSubMenu->CreatePopupMenu();
				pSubMenu->InsertMenu(0, MF_STRING|MF_BYPOSITION, 
					CG_IDS_TIPOFTHEDAY, strTipMenu);
			} 
			pMenu->AppendMenu(MF_STRING|MF_BYPOSITION|MF_ENABLED|MF_POPUP, 
				(UINT)pSubMenu->m_hMenu, strHelp);
			DrawMenuBar();
		} 
		else
		{      
			// Check to see if the Tip of the Day menu has already been added.
			pSubMenu->GetMenuString(0, strMenu, MF_BYPOSITION);

			if (strMenu != strTipMenu) 
			{
				// Tip of the Day submenu has not been added to the 
				// first position, so add it.
				pSubMenu->InsertMenu(0, MF_BYPOSITION);  // Separator
				pSubMenu->InsertMenu(0, MF_STRING|MF_BYPOSITION, 
					CG_IDS_TIPOFTHEDAY, strTipMenu);
			}
		}
	}

}

void CMainFrame::OnViewTagsBar() 
{
	ShowControlBar(&m_wndTags, (m_wndTags.GetStyle() & WS_VISIBLE) == 0, FALSE);
}

void CMainFrame::OnUpdateViewTagsBar(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck((m_wndTags.GetStyle() & WS_VISIBLE) != 0);
}

void CMainFrame::InitialShowWindow(int nCmdShow)
{
	if (gMainPlacement.hasOne) 
	{
		WINDOWPLACEMENT wp = gMainPlacement.placement;
		if (nCmdShow != SW_SHOWNORMAL)
			wp.showCmd = nCmdShow;
		else if (wp.showCmd & SW_SHOWMINIMIZED)
			wp.showCmd = (wp.flags & WPF_RESTORETOMAXIMIZED) ? SW_MAXIMIZE : SW_SHOWNORMAL;
		SetWindowPlacement(&wp);
	}
	else
	{
		ShowWindow(nCmdShow);
	}
}
