/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@hotmail.com> --- August 1998
 */

/*
 * MacrosSetup.h --- hook the macros files
 */

#ifndef MACROSSETUP_H
#define MACROSSETUP_H

#include <vector>
#include "ustr.h"

#define MACROS_FOLDER "Macros"
#define PYTHONLIB_FOLDER "PythonLib"

// a macro is a file + a display name
class CMacroEntry
{
public:
	CMacroEntry() {}
	CMacroEntry(const char *fullname, const char *dispname)
	{
		path = fullname;
		name = dispname;
	}
	CMacroEntry(const CMacroEntry & anentry)
	{
		*this = anentry;
	}

	inline CMacroEntry & operator=(const CMacroEntry & anentry)
	{
		path = anentry.path;
		name = anentry.name;
		return *this;
	}

	inline bool operator<(const CMacroEntry & anentry) const
	{
		return false;
	}

	inline bool operator==(const CMacroEntry & anentry) const
	{
		return path.compare(anentry.path) == 0 && name.compare(anentry.name) == 0;
	}

	std::string path;
	std::string name;
};

// a set of macros + a flag to reload menus
class CMacroSet
{
public:
	CMacroSet()
	{
		invalFlag = true;
	}

	std::vector<CMacroEntry> entries;
  
	bool invalFlag;

	void Flush(void)
	{
		entries.erase(entries.begin(), entries.end());
		invalFlag = true;
	}

	void Add(const char *fullname, const char *name)
	{
		std::vector<CMacroEntry>::iterator j;
		
		for(j = entries.begin(); j != entries.end(); ++j) {
			if( stricmp((*j).name.c_str(), name) > 0 ) 
				break;
		}
		
		entries.insert(j, CMacroEntry(fullname, name));
	}
};

extern CMacroSet gMacrosAdmin;
extern CMacroSet gMacrosSel;

void MacrosReloadAll(void);
void MacrosGetLoc(std::string& path);
void PythonLibGetLoc(std::string& path);

#endif /* MACROSSETUP_H */
