/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
  * Author : Karl-Heinz Brnen <gcvs@bruenen-net.de> --- March 2002
 */

// AboutDlg.cpp : About Dialog!

#include "stdafx.h"

#if qUnix
#	include "UCvsDialogs.h"
#endif

#include "uwidget.h"
#include "AboutDlg.h"
#include "UCvsApp.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

UIMPLEMENT_DYNAMIC(UAboutDlg, UWidget)
UBEGIN_MESSAGE_MAP(UAboutDlg, UWidget)
	ON_UCOMMAND(kOK, UAboutDlg::OnOk)
//	ON_UCOMMAND(kAppURL, UAboutDlg::OnURL)
UEND_MESSAGE_MAP()
	
int UAboutDlg::OnOk(void)
{
	EndModal(true);
	return 0;
}

int UAboutDlg::OnURL(void)
{
	return 0;
}

void UAboutDlg::DoDataExchange(bool fill)
{
	UStr  appURL = "http://cvsgui.sourceforge.net";
	UStr  appText;
		
	appText  = UCvsApp::gApp->GetAppName();
	appText += " ";
	appText += UCvsApp::gApp->GetAppVersion();
	
	if(fill)
	{
		UEventSendMessage(GetWidID(), EV_SETTEXT, kAppName, (void *)(const char *)appText);
		UEventSendMessage(GetWidID(), EV_SETTEXT, kAppURL, (void *)(const char *)appURL);
	}
	else
	{
	}
}


void AboutDialog(void)
{
	void *wid = UCreate_AboutDlg();
	const char*  appText = UCvsApp::gApp->GetAppName();
		
	UAboutDlg *dlg = new UAboutDlg ();
	UEventSendMessage(dlg->GetWidID(), EV_INIT_WIDGET, kUMainWidget, wid);	
	UEventSendMessage(dlg->GetWidID(), EV_SETTEXT, kUMainWidget, const_cast<char*>(appText));	
	
	bool res = false;
	
	res = dlg->DoModal();
	
	return;
}
