/*
 * config.h --- configuration file for MacOS
 * Handbuilt for MetroWerks CodeWarrier 7 and GUSI 1.6.4
 *
 * This file lives in the CVSHOME/macintosh directory
 *
 * MDLadwig <mike@twinpeaks.prc.com> --- Nov 1995
 * Modified : Alexandre Parenteau <aubonbeurre@hotmail.com> --- December 1997
 */

#ifndef _CONFIG_H__
#define _CONFIG_H__

#define O_BINARY		0x8000		/* open the file in binary mode (default is text mode) */

#include <ansi_parms.h>

#ifdef CVSGUI_SHL
#	define MAC_SHL
#	define CVSGUI
#	include "dll_garbage.h"
#	include "dll_glue.h"
#endif /* CVSGUI_SHL */

#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>

#if __MSL__ >= 0x6000 && __MSL__ < 0x7000
#	include <unistd.h>
#	define getlogin _getlogin
#	define posixparams mode_t
	_MSL_IMP_EXP_C char*        	_getlogin(void);
	_MSL_IMP_EXP_C posixparams _umask(posixparams);  		/*cc Feb 10 2000 */
	__inline  posixparams  umask(posixparams _a)  		 {return  _umask(_a)    	 ;}
#endif

/* Enumerated values can be trouble on 68K machines.  */
#if !__POWERPC__
#define ENUMS_CAN_BE_TROUBLE 1
#endif

/* Don't offer user (or server) the ability to try client-side gzip subprocessing */
#define NO_CLIENT_GZIP_PROCESS 1

/* Define if CR-LF conversion is broken.  */
#define BROKEN_READWRITE_CONVERSION 1

/* Define if 'patch' is not to be used.  */
#define DONT_USE_PATCH 1

/* Define if files are crlf terminated.  */
/*#define LINES_CRLF_TERMINATED 1*/

/* Define if you support file names longer than 14 characters.  */
#define HAVE_LONG_FILE_NAMES 1

/* Define if your struct stat has st_blksize.  */
#define HAVE_ST_BLKSIZE 1

/* Define if you have <sys/wait.h> that is POSIX.1 compatible.  */
#undef HAVE_SYS_WAIT_H

/* Define if utime(file, NULL) sets file's timestamp to the present.  */
#define HAVE_UTIME_NULL 1

/* Define if you have <vfork.h>.  */
#undef HAVE_VFORK_H

/* Define if on MINIX.  */
#undef _MINIX

/* Define if the system does not provide POSIX.1 features except
   with this defined.  */
#undef _POSIX_1_SOURCE

/* Define if you need to in order for stat and other things to work.  */
#undef _POSIX_SOURCE

/* Define as the return type of signal handlers (int or void).  */
#define RETSIGTYPE void

/* Define if the `S_IS*' macros in <sys/stat.h> do not work properly. */
#undef STAT_MACROS_BROKEN
 
/* Define if you have the ANSI C header files.  */
#define STDC_HEADERS 1

/* Define if you can safely include both <sys/time.h> and <time.h>.  */
#define TIME_WITH_SYS_TIME 1

/* Define if you have MIT Kerberos version 4 available.  */
#undef HAVE_KERBEROS

/* Define if you have GSSAPI with MIT Kerberos version 5 available.  */
#undef HAVE_GSSAPI

/* Define if GSS_C_NT_HOSTBASED_SERVICE is defined in the gssapi.h
   header file.  Only relevant when using GSSAPI.  */
#undef HAVE_GSS_C_NT_HOSTBASED_SERVICE

/* Define if you want CVS to be able to be a remote repository client.  */
#define CLIENT_SUPPORT 1

/* Define if you want CVS to be able to serve repositories to remote
   clients.  */
#undef SERVER_SUPPORT

/* Define if you want to use the password authenticated server.  */
#undef AUTH_SERVER_SUPPORT

/* Define if you want encryption support.  */
#undef ENCRYPTION

/* Define if you have the connect function.  */
#define HAVE_CONNECT

/* Define if this system supports chown(), link(), and friends.  */
#undef PRESERVE_PERMISSIONS_SUPPORT

/* Define if you have memchr (always for CVS).  */
#undef HAVE_MEMCHR

/* Define if you have strchr (always for CVS).  */
#undef HAVE_STRCHR

/* Define if utime requires write access to the file (true on Windows,
   but not Unix).  */
#undef UTIME_EXPECTS_WRITABLE

/* Define if setmode is required when writing binary data to stdout.  */
#undef USE_SETMODE_STDOUT

/* Define if the diff library should use setmode for binary files.
   FIXME: Why two different macros for setmode?  */
#undef HAVE_SETMODE

/* Define if you have the crypt function.  */
#undef HAVE_CRYPT

/* Define if you have the getspnam function.  */
#undef HAVE_GETSPNAM

/* Define to force lib/regex.c to use malloc instead of alloca.  */
#undef REGEX_MALLOC

/* Define to force lib/regex.c to define re_comp et al.  */
#define _REGEX_RE_COMP 1

/* Define if you have the dup2 function.  */
#undef HAVE_DUP2

/* Define if you have the fchdir function.  */
#undef HAVE_FCHDIR

/* Define if you have the fchmod function.  */
#undef HAVE_FCHMOD

/* Define if you have the fsync function.  */
#define HAVE_FSYNC 1

/* Define if you have the ftime function.  */
#define HAVE_FTIME 1

/* Define if you have the ftruncate function.  */
#define HAVE_FTRUNCATE 1

/* Define if you have the getpagesize function.  */
#undef HAVE_GETPAGESIZE

/* Define if you have the getspnam function.  */
#undef HAVE_GETSPNAM

/* Define if you have the initgroups function.  */
#undef HAVE_INITGROUPS

/* Define if you have the krb_get_err_text function.  */
#undef HAVE_KRB_GET_ERR_TEXT

/* Define if you have the mktemp function.  */
#undef HAVE_MKTEMP

/* Define if you have the putenv function.  */
#undef HAVE_PUTENV

/* Define if you have the readlink function.  */
#define HAVE_READLINK 1

/* Define if you have the sigaction function.  */
#define HAVE_SIGACTION 1

/* Define if you have the sigblock function.  */
#undef HAVE_SIGBLOCK

/* Define if you have the sigprocmask function.  */
#define HAVE_SIGPROCMASK 1

/* Define if you have the sigsetmask function.  */
#undef HAVE_SIGSETMASK

/* Define if you have the sigvec function.  */
#undef HAVE_SIGVEC

/* Define if you have the tempnam function.  */
#undef HAVE_TEMPNAM

/* Define if you have the timezone function.  */
#undef HAVE_TIMEZONE

/* Define if you have the tzset function.  */
#undef HAVE_TZSET

/* Define if you have the vprintf function.  */
#define HAVE_VPRINTF 1

/* Define if you have the wait3 function.  */
#undef HAVE_WAIT3

/* Define if you have the <direct.h> header file.  */
#undef HAVE_DIRECT_H

/* Define if you have the <dirent.h> header file.  */
#define HAVE_DIRENT_H 1

/* Define if you have the <errno.h> header file */
#define HAVE_ERRNO_H 1

/* Define if you have the <fcntl.h> header file.  */
#define HAVE_FCNTL_H 1

/* Define if you have the <gssapi.h> header file.  */
#undef HAVE_GSSAPI_H

/* Define if you have the <gssapi/gssapi.h> header file.  */
#undef HAVE_GSSAPI_GSSAPI_H

/* Define if you have the <gssapi/gssapi_generic.h> header file.  */
#undef HAVE_GSSAPI_GSSAPI_GENERIC_H

/* Define if you have the <io.h> header file.  */
#undef HAVE_IO_H

/* Define if you have the <limits.h> header file.  */
#define HAVE_LIMITS_H 1

/* Define if you have the <memory.h> header file.  */
#undef HAVE_MEMORY_H

/* Define if you have the <ndbm.h> header file.  */
#undef HAVE_NDBM_H

/* Define if you have the <ndir.h> header file.  */
#undef HAVE_NDIR_H

/* Define if you have the <string.h> header file.  */
#define HAVE_STRING_H 1

/* Define if you have the <sys/bsdtypes.h> header file.  */
#undef HAVE_SYS_BSDTYPES_H

/* Define if you have the <sys/dir.h> header file.  */
#undef HAVE_SYS_DIR_H

/* Define if you have the <sys/file.h> header file.  */
#undef HAVE_SYS_FILE_H

/* Define if you have the <sys/ndir.h> header file.  */
#undef HAVE_SYS_NDIR_H

/* Define if you have the <sys/param.h> header file.  */
#undef HAVE_SYS_PARAM_H

/* Define if you have the <sys/resource.h> header file.  */
#undef HAVE_SYS_RESOURCE_H

/* Define if you have the <sys/select.h> header file.  */
#undef HAVE_SYS_SELECT_H

/* Define if you have the <sys/time.h> header file.  */
#define HAVE_SYS_TIME_H 1

/* Define if you have the <sys/timeb.h> header file.  */
#undef HAVE_SYS_TIMEB_H

/* Define if you have the <unistd.h> header file.  */
#define HAVE_UNISTD_H 1

/* Define if you have the <utime.h> header file.  */
#define HAVE_UTIME_H 1

/* Define if you have the crypt library (-lcrypt).  */
#undef HAVE_LIBCRYPT

/* Define if you have the gen library (-lgen).  */
#undef HAVE_LIBGEN

/* Define if you have the inet library (-linet).  */
#undef HAVE_LIBINET

/* Define if you have the nsl library (-lnsl).  */
#undef HAVE_LIBNSL

/* Define if you have the nsl_s library (-lnsl_s).  */
#undef HAVE_LIBNSL_S

/* Define if you have the sec library (-lsec).  */
#undef HAVE_LIBSEC

/* Define if you have the socket library (-lsocket).  */
#undef HAVE_LIBSOCKET

#ifdef MACCVS_KERBEROS
	/* Define if you have kerberos v4 support */
#	define HAVE_KERBEROS 1

	/* Define if you are using KClient for Kerberos v4 on the Mac (this is the only supported option right now) */
#	define USE_KCLIENT 1

	/* Some weird kerberos #if statements want this */
#	define USE_DIRECT_TCP 1
#endif

/* GUSI filesystem stuff doesn't take the last parameter (permissions).  */
#define CVS_MKDIR macos_mkdir
#define mkdir macos_mkdir
#define CVS_OPEN macos_open
#define open macos_open
#define CVS_CREAT macos_creat
#define creat macos_creat
#define CVS_FOPEN macos_fopen
#define fopen macos_fopen
#define CVS_CHDIR macos_chdir
#define chdir macos_chdir
#define CVS_ACCESS macos_access
#define access macos_access
#define CVS_OPENDIR macos_opendir
#define opendir macos_opendir
#define CVS_STAT macos_stat
#define stat(a,b) macos_stat(a,b)
#define CVS_RENAME macos_rename
#define rename macos_rename
#define CVS_RMDIR macos_rmdir
#define rmdir macos_rmdir
#define CVS_UNLINK macos_unlink
#define unlink macos_unlink
#define CVS_CHMOD macos_chmod
#define chmod macos_chmod
#define CVS_LSTAT macos_lstat
#define lstat macos_lstat

#ifdef __cplusplus
extern "C" {
#endif

extern int macos_rmdir (const char *);
extern int macos_rename (const char *, const char *);
extern int macos_stat (const char *, struct stat *);
extern int macos_lstat (const char *, struct stat *);
extern DIR * macos_opendir (const char *);
extern int macos_access(const char *, int);
extern int macos_chdir( const char *path );
extern FILE * macos_fopen( const char *path, const char *mode );
extern int macos_creat( const char *path, mode_t mode );
extern int macos_open( const char *path, int oflag, ... );
extern int macos_mkdir( const char *path, int oflag );
extern int macos_unlink (const char *);
extern int macos_chmod( const char *path, mode_t mode );

/* Kludges from pwd.c  */
extern struct passwd *getpwnam (char *name);
extern pid_t getpid (void);

#ifdef __cplusplus
}
#endif

/* We have prototypes.  */
#define USE_PROTOTYPES 1

/* Compare filenames */
/* should we use stricmp instead ? */
#define fncmp strcmp

/* Don't use rsh */
#define RSH_NOT_TRANSPARENT 1

#define START_SERVER macos_start_server
#define SHUTDOWN_SERVER macos_shutdown_server
#define SYSTEM_CLEANUP macos_cleanup
#define SYSTEM_INITIALIZE macos_initialize

#ifdef __cplusplus
extern "C" {
#endif

extern void macos_start_server (int *tofd, int *fromfd,
			      char *client_user,
			      char *server_user,
			      char *server_host,
			      char *server_cvsroot);
extern void macos_shutdown_server (int to);
extern void macos_cleanup(void);
extern void macos_initialize(int *argc, char ***argv);

#ifdef __cplusplus
}
#endif

/* convert non-text files with rsrc fork in hqx */
#define BINHEX_STUFF

/* see cvs.h */
#define DIRTY_MODDATE
#define DO_NOT_LOCK_DIRTY

/* only for us ! */
#define STRATA_HACK

#endif // _CONFIG_H__
