/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@hotmail.com> --- December 1997
 */

/*
 * MultiFiles.h --- class to store multiple files by directory
 */

#ifndef MULTIFILES_H
#define MULTIFILES_H

#include "TextBinary.h"

#include "CPStr.h"
#include <vector>

#ifdef _MSC_VER
	using namespace std;
#endif

class CvsArgs;

/// Used internally
class FileEntry
{
public:
	FileEntry();
	FileEntry(const char* filename, const UFSSpec* macspec = 0L, const char* currRevision = 0L);
	FileEntry(const FileEntry& entry);

	FileEntry& operator=(const FileEntry& entry);

	CStr file;
	CStr currRev;
	UFSSpec spec;
};

/// Used internally
class MultiFilesEntry
{
public:
	MultiFilesEntry();
	MultiFilesEntry(const char* path);
	MultiFilesEntry(const MultiFilesEntry& entries);

	MultiFilesEntry& operator=(const MultiFilesEntry& entries);

	void setdir(const char* newdir);
	void add(const char* file, const UFSSpec* spec = 0L, const char* currRevision = 0L);

	CStr dir;
	std::vector<FileEntry> files;
};

/// Store multiple files by directory
class MultiFiles
{
public:
	MultiFiles();

	void newdir(const char* dir);
	void newfile(const char* file, const UFSSpec* spec = 0L, const char* currRevision = 0L);

	inline void rewind(void);
	bool next(void);
	char* add(CvsArgs& args);
	bool get(int index, CStr& path, CStr& fileName, CStr& currRev) const;
	
	const char* getdir() const;
	bool getdir(int index, CStr& path) const;

	int NumFiles(void) const;
	int NumDirs(void) const;

	void reset();

protected:
	int pos;
	std::vector<MultiFilesEntry> dirs;
};

#endif /* MULTIFILES_H */
