/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Jerzy Kaczorowski <kaczoroj@hotmail.com> --- September 2001
 */

/*
 * GraphOptDlg.cpp --- graph options dialog
 */

#include "stdafx.h"

#ifdef WIN32
#include "wincvs.h"
#include "MainFrm.h"
#include "GraphView.h"
#endif /* WIN32 */

#include "GraphOptDlg.h"
#include "CvsPrefs.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGraphOptDlg dialog

#ifdef WIN32

CGraphOptDlg::CGraphOptDlg(CPersistentInt& selColor, CPersistentInt& shadowColor, 
						   CPersistentInt& headerColor, CPersistentInt& tagColor, CPersistentInt& branchColor, 
						   CPersistentInt& nodeColor, CPersistentInt& deadNodeColor, CPersistentInt& userStateNodeColor,
						   CWnd* pParent /*=NULL*/)
	: CDialog(CGraphOptDlg::IDD, pParent),
	m_selColor(selColor), m_shadowColor(shadowColor), 
	m_headerColor(headerColor), m_tagColor(tagColor), m_branchColor(branchColor), 
	m_nodeColor(nodeColor), m_deadNodeColor(deadNodeColor), m_userStateNodeColor(userStateNodeColor)
{
	//{{AFX_DATA_INIT(CGraphOptDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	
	m_rgbShadow.SetColor((int)m_shadowColor);
	m_rgbSelection.SetColor((int)m_selColor);
	m_rgbState.SetColor((int)m_userStateNodeColor);
	m_rgbDead.SetColor((int)m_deadNodeColor);
	m_rgbNode.SetColor((int)m_nodeColor);
	m_rgbBranch.SetColor((int)m_branchColor);
	m_rgbTag.SetColor((int)m_tagColor);
	m_rgbHeader.SetColor((int)m_headerColor);

	m_origSelColor = m_selColor;
	m_origShadowColor = m_shadowColor;
	m_origHeaderColor = m_headerColor;
	m_origTagColor = m_tagColor;
	m_origBranchColor = m_branchColor;
	m_origNodeColor = m_deadNodeColor;
	m_origDeadNodeColor = m_deadNodeColor;
	m_origUserStateNodeColor = m_userStateNodeColor;
}


void CGraphOptDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGraphOptDlg)
	DDX_Control(pDX, IDC_APPLY, m_apply);
	DDX_Control(pDX, IDC_RGBSHADOW, m_rgbShadow);
	DDX_Control(pDX, IDC_RGBSELECTION, m_rgbSelection);
	DDX_Control(pDX, IDC_RGBSTATE, m_rgbState);
	DDX_Control(pDX, IDC_RGBDEAD, m_rgbDead);
	DDX_Control(pDX, IDC_RGBNODE, m_rgbNode);
	DDX_Control(pDX, IDC_RGBBRANCH, m_rgbBranch);
	DDX_Control(pDX, IDC_RGBTAG, m_rgbTag);
	DDX_Control(pDX, IDC_RGBHEADER, m_rgbHeader);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CGraphOptDlg, CDialog)
	//{{AFX_MSG_MAP(CGraphOptDlg)
	ON_BN_CLICKED(IDC_APPLY, OnApply)
	ON_BN_CLICKED(IDC_HEADER, OnHeader)
	ON_BN_CLICKED(IDC_TAG, OnTag)
	ON_BN_CLICKED(IDC_BRANCH, OnBranch)
	ON_BN_CLICKED(IDC_NODE, OnNode)
	ON_BN_CLICKED(IDC_DEAD, OnDead)
	ON_BN_CLICKED(IDC_STATE, OnState)
	ON_BN_CLICKED(IDC_SELECTION, OnSelection)
	ON_BN_CLICKED(IDC_SHADOW, OnShadow)
	ON_BN_CLICKED(IDC_RESET, OnReset)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGraphOptDlg message handlers

void CGraphOptDlg::GetAllColors()
{
	m_shadowColor = (int)m_rgbShadow.GetColor();
	m_selColor = (int)m_rgbSelection.GetColor();
	m_userStateNodeColor = (int)m_rgbState.GetColor();
	m_deadNodeColor = (int)m_rgbDead.GetColor();
	m_nodeColor = (int)m_rgbNode.GetColor();
	m_branchColor = (int)m_rgbBranch.GetColor();
	m_tagColor = (int)m_rgbTag.GetColor();
	m_headerColor = (int)m_rgbHeader.GetColor();
}

void CGraphOptDlg::OnOK() 
{
	GetAllColors();

	CDialog::OnOK();
}

void CGraphOptDlg::OnApply() 
{
	GetAllColors();

	CWincvsApp* pApp = (CWincvsApp*)AfxGetApp();
	if( pApp )
	{
		pApp->UpdateAllDocsView();
	}
	
	m_apply.EnableWindow(FALSE);
}

void CGraphOptDlg::OnCancel() 
{
	m_selColor = m_origSelColor;
	m_shadowColor = m_origShadowColor;
	m_headerColor = m_origHeaderColor;
	m_tagColor = m_origTagColor;
	m_branchColor = m_origBranchColor;
	m_deadNodeColor = m_origNodeColor;
	m_deadNodeColor = m_origDeadNodeColor;
	m_userStateNodeColor = m_origUserStateNodeColor;
	
	CDialog::OnCancel();
}

void CGraphOptDlg::PromptForColor(CColorStatic& colorStatic)
{
	CColorDialog colorDialog(colorStatic.GetColor());
	if( colorDialog.DoModal() == IDOK )
	{
		if( colorDialog.GetColor() != colorStatic.GetColor() )
		{
			colorStatic.SetColor(colorDialog.GetColor());
			m_apply.EnableWindow();
		}
	}
}

void CGraphOptDlg::OnHeader() 
{
	PromptForColor(m_rgbHeader);
}

void CGraphOptDlg::OnTag() 
{
	PromptForColor(m_rgbTag);
}

void CGraphOptDlg::OnBranch() 
{
	PromptForColor(m_rgbBranch);
}

void CGraphOptDlg::OnNode() 
{
	PromptForColor(m_rgbNode);
}

void CGraphOptDlg::OnDead() 
{
	PromptForColor(m_rgbDead);
}

void CGraphOptDlg::OnState() 
{
	PromptForColor(m_rgbState);
}

void CGraphOptDlg::OnSelection() 
{
	PromptForColor(m_rgbSelection);
}

void CGraphOptDlg::OnShadow() 
{
	PromptForColor(m_rgbShadow);
}

void CGraphOptDlg::OnReset() 
{
	m_rgbShadow.SetColor(RGB_DEF_SHADOW);
	m_rgbSelection.SetColor(RGB_DEF_SEL);
	m_rgbState.SetColor(RGB_DEF_USERSTATENODE);
	m_rgbDead.SetColor(RGB_DEF_DEADNODE);
	m_rgbNode.SetColor(RGB_DEF_NODE);
	m_rgbBranch.SetColor(RGB_DEF_BRANCH);
	m_rgbTag.SetColor(RGB_DEF_TAG);
	m_rgbHeader.SetColor(RGB_DEF_HEADER);
	
	m_apply.EnableWindow();
}

#endif /* WIN32 */

bool CompatGetGraphOptions(CPersistentInt& selColor, CPersistentInt& shadowColor, 
						   CPersistentInt& headerColor, CPersistentInt& tagColor, CPersistentInt& branchColor, 
						   CPersistentInt& nodeColor, CPersistentInt& deadNodeColor, CPersistentInt& userStateNodeColor)
{
	bool userHitOK = false;

#ifdef WIN32
	CGraphOptDlg graphOptDlg(selColor, shadowColor, 
		headerColor, tagColor, branchColor, 
		nodeColor, deadNodeColor, userStateNodeColor);
	if( graphOptDlg.DoModal() == IDOK )
	{
		userHitOK = true;
	}
#endif /* WIN32 */
#ifdef qMacCvsPP
#endif /* qMacCvsPP */
#if qUnix
#endif // qUnix
	
	return userHitOK && !gCvsPrefs.empty();
}


