/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@hotmail.com> --- March 1998
 */

/*
 * DiffDlg.cpp : the cvs diff dialog
 */

#include "stdafx.h"

#ifdef WIN32
#	include "wincvs.h"
#	include "OptionalPropertySheet.h"
#endif /* WIN32 */

#if qUnix
#	include "UCvsDialogs.h"
#endif

#ifdef qMacCvsPP
#	include <UModalDialogs.h>
#	include <LRadioButton.h>
#	include <LEditText.h>
#	include <LCheckBox.h>
#	include <LMultiPanelView.h>
#	include <LPopupGroupBox.h>
#	include "LPopupFiller.h"

#	include "MacCvsConstant.h"
#endif /* qMacCvsPP */

#define _DIFF_CPP_

#include "DiffDlg.h"
#include "CvsPrefs.h"
#include "MultiFiles.h"
#include "UpdateDlg.h"
#include "ItemListDlg.h"

static CPersistentBool gUseExtDiff("P_DiffUseExtDiff", false);
static CPersistentBool gUseUnifiedDiff("P_DiffUseUnifiedDiff", false);
static CPersistentBool gIgnoreCase("P_IgnoreCase", false);
static CPersistentBool gNoWhiteSpace("P_NoWhiteSpace", false);
static CPersistentBool gNoBlankLines("P_NoBlankLines", false);
static CPersistentBool gUnifiedDiff("P_UnifiedDiff", false);

//{ Win32 - Part
#ifdef WIN32
#include "GetPrefs.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

IMPLEMENT_DYNAMIC(CDiff_MAIN, CPropertyPage)

CDiff_MAIN::CDiff_MAIN(const MultiFiles* mf,
					   const char* rev1, const char* rev2, 
					   bool allowExtDiff, bool useExtDiff, bool noWhiteSpace, bool ignoreCase) 
					   : m_mf(mf), m_allowExtDiff(allowExtDiff), CPropertyPage(CDiff_MAIN::IDD)
{
	//{{AFX_DATA_INIT(CDiff_MAIN)
	m_isDate1 = FALSE;
	m_isDate2 = FALSE;
	m_rev1 = rev1;
	m_rev2 = rev2;
	m_diff = 0;
	m_norecurs = FALSE;
	m_extdiff = useExtDiff;
	m_noWhiteSpace = noWhiteSpace;
	m_ignoreCase = ignoreCase;
	//}}AFX_DATA_INIT

	m_rev1Combo.SetItems(m_isDate1 ? &gDateNames : &gRevNames);
	m_rev2Combo.SetItems(m_isDate2 ? &gDateNames : &gRevNames);
}

CDiff_MAIN::~CDiff_MAIN()
{
}

void CDiff_MAIN::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDiff_MAIN)
	DDX_Control(pDX, IDC_EXTDIFF, m_extdiffctl);
	DDX_Control(pDX, IDC_COMBO2, m_rev2Combo);
	DDX_Control(pDX, IDC_COMBO1, m_rev1Combo);
	DDX_Check(pDX, IDC_CHECK1, m_isDate1);
	DDX_Check(pDX, IDC_CHECK2, m_isDate2);
	DDX_CBString(pDX, IDC_COMBO1, m_rev1);
	DDX_CBString(pDX, IDC_COMBO2, m_rev2);
	DDX_Radio(pDX, IDC_DIFF1, m_diff);
	DDX_Check(pDX, IDC_NORECURS, m_norecurs);
	DDX_Check(pDX, IDC_EXTDIFF, m_extdiff);
	DDX_Check(pDX, IDC_IGNOREWHITESPACE, m_noWhiteSpace);
	DDX_Check(pDX, IDC_IGNORECASE, m_ignoreCase);
	//}}AFX_DATA_MAP
	if( m_diff == 1 || m_diff == 2 )
	{
		DDV_MinChars(pDX, m_rev1, 1);
	}

	if( m_diff == 2 )
	{
		DDV_MinChars(pDX, m_rev2, 1);
	}

	if( !pDX->m_bSaveAndValidate )
	{
		OnDiff1();
	}
		
	DDX_ComboMString(pDX, IDC_COMBO1, m_rev1Combo);
	DDX_ComboMString(pDX, IDC_COMBO2, m_rev2Combo);

	m_extdiffctl.EnableWindow(m_allowExtDiff ? true : false);
	OnExtdiff();
}

BEGIN_MESSAGE_MAP(CDiff_MAIN, CPropertyPage)
	//{{AFX_MSG_MAP(CDiff_MAIN)
	ON_BN_CLICKED(IDC_DIFF1, OnDiff1)
	ON_BN_CLICKED(IDC_DIFF2, OnDiff2)
	ON_BN_CLICKED(IDC_DIFF3, OnDiff3)
	ON_BN_CLICKED(IDC_EXTDIFF, OnExtdiff)
	ON_BN_CLICKED(IDC_CHECK1, OnCheck1)
	ON_BN_CLICKED(IDC_CHECK2, OnCheck2)
	ON_BN_CLICKED(IDC_BROWSE_TAG1, OnBrowseTag1)
	ON_BN_CLICKED(IDC_BROWSE_TAG2, OnBrowseTag2)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDiff_MAIN message handlers

void CDiff_MAIN::OnDiff1()
{
	CButton* but = (CButton *)GetDlgItem(IDC_DIFF1);
	CButton* but1 = (CButton *)GetDlgItem(IDC_DIFF2);
	CButton* but2 = (CButton *)GetDlgItem(IDC_DIFF3);
	CWnd* wnd1 = GetDlgItem(IDC_COMBO1);
	CWnd* wnd2 = GetDlgItem(IDC_COMBO2);
	CWnd* wnd3 = GetDlgItem(IDC_CHECK1);
	CWnd* wnd4 = GetDlgItem(IDC_CHECK2);
	CWnd* wnd5 = GetDlgItem(IDC_BROWSE_TAG1);
	CWnd* wnd6 = GetDlgItem(IDC_BROWSE_TAG2);

	if(but->GetCheck() == 1)
	{
		wnd1->EnableWindow(FALSE);
		wnd2->EnableWindow(FALSE);
		wnd3->EnableWindow(FALSE);
		wnd4->EnableWindow(FALSE);
		wnd5->EnableWindow(FALSE);
		wnd6->EnableWindow(FALSE);
	}
	else if(but1->GetCheck() == 1)
	{
		wnd1->EnableWindow(TRUE);
		wnd2->EnableWindow(FALSE);
		wnd3->EnableWindow(TRUE);
		wnd4->EnableWindow(FALSE);
		wnd5->EnableWindow(TRUE);
		wnd6->EnableWindow(FALSE);
	}
	else
	{
		wnd1->EnableWindow(TRUE);
		wnd2->EnableWindow(TRUE);
		wnd3->EnableWindow(TRUE);
		wnd4->EnableWindow(TRUE);
		wnd5->EnableWindow(TRUE);
		wnd6->EnableWindow(TRUE);
	}
}

void CDiff_MAIN::OnDiff2() 
{
	OnDiff1();
}

void CDiff_MAIN::OnDiff3() 
{
	OnDiff1();
}

void CDiff_MAIN::OnExtdiff() 
{
	CButton* but = (CButton *)GetDlgItem(IDC_EXTDIFF);
	CWnd* wnd1 = GetDlgItem(IDC_IGNOREWHITESPACE);
	CWnd* wnd2 = GetDlgItem(IDC_IGNORECASE);
	BOOL bEnableDiffOptions = ( !but->GetCheck() || !but->IsWindowEnabled() );
	wnd1->EnableWindow(bEnableDiffOptions);
	wnd2->EnableWindow(bEnableDiffOptions);
}

void CDiff_MAIN::OnCheck1() 
{
	CButton* btnIsDate = (CButton*)GetDlgItem(IDC_CHECK1);
	BOOL isDate = btnIsDate->GetCheck();

	m_rev1Combo.SetItems(isDate ? &gDateNames : &gRevNames);
	DDX_ComboMString(NULL, IDC_COMBO1, m_rev1Combo);

	CWnd* wnd = GetDlgItem(IDC_BROWSE_TAG1);
	if( wnd )
	{
		wnd->EnableWindow(!isDate);
	}
}

void CDiff_MAIN::OnCheck2() 
{
	CButton* btnIsDate = (CButton*)GetDlgItem(IDC_CHECK2);
	BOOL isDate = btnIsDate->GetCheck();

	m_rev2Combo.SetItems(isDate ? &gDateNames : &gRevNames);
	DDX_ComboMString(NULL, IDC_COMBO2, m_rev2Combo);

	CWnd* wnd = GetDlgItem(IDC_BROWSE_TAG2);
	if( wnd )
	{
		wnd->EnableWindow(!isDate);
	}
}

void CDiff_MAIN::OnBrowseTag1() 
{
	CPStr tagName;
	if( CompatGetTagListItem(m_mf, tagName) )
	{
		m_rev1 = (const char*)tagName;
		m_rev1Combo.SetWindowText(m_rev1);
	}
}

void CDiff_MAIN::OnBrowseTag2() 
{
	CPStr tagName;
	if( CompatGetTagListItem(m_mf, tagName) )
	{
		m_rev2 = (const char*)tagName;
		m_rev2Combo.SetWindowText(m_rev2);
	}
}

#endif /* WIN32 */
//} Win32 - Part

//{ Mac - Part
#ifdef qMacCvsPP
static void DoDataExchange_DiffMain(LWindow *theDialog, bool & noRecurs, bool & isDate1, bool & isDate2,
	CPStr & sLastRev1, CPStr & sLastRev2, bool & hasRev1, bool & hasRev2, bool putValue)
{
	LRadioButton *chkHasRev = dynamic_cast<LRadioButton*>
		(theDialog->FindPaneByID(item_CheckRevTag1));
	LEditText *editRev = dynamic_cast<LEditText*>
		(theDialog->FindPaneByID(item_EditRevTag1));
	LRadioButton *chkHasRev2 = dynamic_cast<LRadioButton*>
		(theDialog->FindPaneByID(item_CheckRevTag2));
	LEditText *editRev2 = dynamic_cast<LEditText*>
		(theDialog->FindPaneByID(item_EditRevTag2));
	LCheckBox *chkHasDate1 = dynamic_cast<LCheckBox*>
		(theDialog->FindPaneByID(item_CheckDate1));
	LCheckBox *chkHasDate2 = dynamic_cast<LCheckBox*>
		(theDialog->FindPaneByID(item_CheckDate2));
	LPopupFiller *fill1 = dynamic_cast<LPopupFiller*>
		(theDialog->FindPaneByID(item_FillerRev1));
	LPopupFiller *fill2 = dynamic_cast<LPopupFiller*>
		(theDialog->FindPaneByID(item_FillerRev2));
	LPane *extDiff = theDialog->FindPaneByID(item_DiffExternal);
	
	if(putValue)
	{
		chkHasDate1->SetValue(isDate1 ? Button_On : Button_Off);
		chkHasDate2->SetValue(isDate2 ? Button_On : Button_Off);
		if(hasRev1 && hasRev2)
			theDialog->SetValueForPaneID (item_CheckRevTag2, Button_On);
		else if(hasRev1)
			theDialog->SetValueForPaneID (item_CheckRevTag1, Button_On);
		else
			theDialog->SetValueForPaneID (item_MergeNone, Button_On);

		editRev->SetText((Ptr)(const char *)sLastRev1, sLastRev1.length());
		editRev2->SetText((Ptr)(const char *)sLastRev2, sLastRev2.length());

		fill1->DoDataExchange(gRevNames, putValue);
		fill2->DoDataExchange(gRevNames, putValue);
		
		extDiff->SetValue ((bool)gUseExtDiff ? Button_On : Button_Off);
	}
	else
	{
		isDate1 = chkHasDate1->GetValue() == Button_On;
		isDate2 = chkHasDate2->GetValue() == Button_On;

		if(theDialog->GetValueForPaneID (item_CheckRevTag2) == Button_On)
		{
			hasRev1 = hasRev2 = true;
		}
		else if (theDialog->GetValueForPaneID (item_CheckRevTag1) == Button_On)
		{
			hasRev1 = true;
			hasRev2 = false;
		}
		else
		{
			hasRev1 = hasRev2 = false;
		}

		fill1->DoDataExchange(isDate1 ? gDateNames : gRevNames, putValue);
		fill2->DoDataExchange(isDate2 ? gDateNames : gRevNames, putValue);

		char str[255];
		Size len;
		
		editRev->GetText(str, 254, &len);
		sLastRev1.set(str, len);
		editRev2->GetText(str, 254, &len);
		sLastRev2.set(str, len);
		
		gUseExtDiff = extDiff->GetValue () == Button_On;
	}
}
#endif /* qMacCvsPP */
//}
//{ Unix - Part
#ifdef qUnix
int UCvsDiff::OnOK(void)
{
	EndModal(true);
	return 0;
}

int UCvsDiff::OnCancel(void)
{
	EndModal(false);
	return 0;
}

void UCvsDiff::DoDataExchange(bool fill)
{
	
	if(fill)
	{
	}
	else
	{
	}
}

UCvsDiff_MAIN::UCvsDiff_MAIN(const char *rev1, const char *rev2, bool allowExtDiff, bool useUnifiedDiff, 
							 bool noWhiteSpace, bool noBlankLines, bool ignoreCase) : UWidget(::UEventGetWidID())
{
	m_check1 = false;
	m_check2 = false;
	m_str1 = rev1;
	m_str2 = rev2;
	m_diff = 0;
	m_noWhiteSpace = gNoWhiteSpace;
	m_noBlankLines = noBlankLines;	
	m_ignoreCase = gIgnoreCase;
	m_norecurs = false;
	m_extdiff = gUseExtDiff;
	m_unifiedDiff = useUnifiedDiff;
	m_allowExtDiff = allowExtDiff;
	
}

int UCvsDiff_MAIN::OnDiff(int cmd)
{
	int state = UEventSendMessage(GetWidID(), EV_QUERYSTATE, kCheckDiff1, 0L);
	if(state)
	{
		UEventSendMessage(GetWidID(), EV_ENABLECMD, UMAKEINT(kCheckDate1, 0), 0L);
		UEventSendMessage(GetWidID(), EV_ENABLECMD, UMAKEINT(kComboRev1, 0), 0L);
		UEventSendMessage(GetWidID(), EV_ENABLECMD, UMAKEINT(kCheckDate2, 0), 0L);
		UEventSendMessage(GetWidID(), EV_ENABLECMD, UMAKEINT(kComboRev2, 0), 0L);
	}
	else
	{
		UEventSendMessage(GetWidID(), EV_ENABLECMD, UMAKEINT(kCheckDate1, 1), 0L);
		UEventSendMessage(GetWidID(), EV_ENABLECMD, UMAKEINT(kComboRev1, 1), 0L);
		state = UEventSendMessage(GetWidID(), EV_QUERYSTATE, kCheckDiff2, 0L);
		UEventSendMessage(GetWidID(), EV_ENABLECMD, UMAKEINT(kCheckDate2, state == 0), 0L);
		UEventSendMessage(GetWidID(), EV_ENABLECMD, UMAKEINT(kComboRev2, state == 0), 0L);
	}
	return 0;
}

void UCvsDiff_MAIN::DoDataExchange(bool fill)
{
	::DoDataExchange(fill, GetWidID(), kComboRev1, gDateOrRevNames);
	::DoDataExchange(fill, GetWidID(), kComboRev2, gDateOrRevNames);

	if(fill)
	{
		UEventSendMessage(GetWidID(), EV_ENABLECMD, UMAKEINT(kCheckExtDiff, m_allowExtDiff), 0L);

		UEventSendMessage(GetWidID(), EV_SETSTATE, UMAKEINT(kCheckDate1, m_check1), 0L);
		UEventSendMessage(GetWidID(), EV_SETSTATE, UMAKEINT(kCheckDate2, m_check2), 0L);
		UEventSendMessage(GetWidID(), EV_SETSTATE, UMAKEINT(kCheckRecurs, m_norecurs), 0L);
		UEventSendMessage(GetWidID(), EV_SETSTATE, UMAKEINT(kCheckExtDiff, m_extdiff), 0L);
		UEventSendMessage(GetWidID(), EV_SETSTATE, UMAKEINT(kCheckUnifiedDiff, m_unifiedDiff), 0L);		
		UEventSendMessage(GetWidID(), EV_SETSTATE, UMAKEINT(kCheckDiff1 + m_diff, 1), 0L);
		UEventSendMessage(GetWidID(), EV_SETSTATE, UMAKEINT(kCheckNoWhiteSpace, m_noWhiteSpace), 0L);
		UEventSendMessage(GetWidID(), EV_SETSTATE, UMAKEINT(kCheckNoBlankLines, m_noBlankLines), 0L);
		UEventSendMessage(GetWidID(), EV_SETSTATE, UMAKEINT(kCheckIgnoreCase,   m_ignoreCase), 0L);		
	
		UEventSendMessage(GetWidID(), EV_SETTEXT, kComboRev1, (void *)(const char *)m_str1);
		UEventSendMessage(GetWidID(), EV_SETTEXT, kComboRev2, (void *)(const char *)m_str2);

		OnDiff(kCheckDiff1 + m_diff);
	}
	else
	{
		m_check1       = UEventSendMessage(GetWidID(), EV_QUERYSTATE, kCheckDate1, 0L);
		m_check2       = UEventSendMessage(GetWidID(), EV_QUERYSTATE, kCheckDate2, 0L);
		m_norecurs     = UEventSendMessage(GetWidID(), EV_QUERYSTATE, kCheckRecurs, 0L);
		m_extdiff      = UEventSendMessage(GetWidID(), EV_QUERYSTATE, kCheckExtDiff, 0L);
		m_unifiedDiff  = UEventSendMessage(GetWidID(), EV_QUERYSTATE, kCheckUnifiedDiff, 0L);
		m_noWhiteSpace = UEventSendMessage(GetWidID(), EV_QUERYSTATE, kCheckNoWhiteSpace, 0L);
		m_noBlankLines = UEventSendMessage(GetWidID(), EV_QUERYSTATE, kCheckNoBlankLines, 0L);
		m_ignoreCase   = UEventSendMessage(GetWidID(), EV_QUERYSTATE, kCheckIgnoreCase, 0L);

		if(UEventSendMessage(GetWidID(), EV_QUERYSTATE, kCheckDiff1, 0L))
			m_diff = 0;
		else if(UEventSendMessage(GetWidID(), EV_QUERYSTATE, kCheckDiff2, 0L))
			m_diff = 1;
		else
			m_diff = 2;

		UEventSendMessage(GetWidID(), EV_GETTEXT, kComboRev1, &m_str1);
		UEventSendMessage(GetWidID(), EV_GETTEXT, kComboRev2, &m_str2);
	}
}
#endif // qUnix
//} Unix - Part

/// Get the diff options
bool CompatGetDiff(const MultiFiles* mf,
				   bool& noRecurs, bool& isDate1, bool& isDate2,
				   CPStr& rev1, CPStr& rev2, bool& useExtDiff,
				   bool & useUnifiedDiff, bool& noWhiteSpace,
				   bool & noBlankLines, bool& ignoreCase,
				   bool allowExtDiff /*= false*/)
{
	bool userHitOK = false;

	static CPStr sLastRev1;
	static CPStr sLastRev2;

	rev1 = "";
	rev2 = "";
	noRecurs = false;
	isDate1 = false;
	isDate2 = false;
	useExtDiff     = (bool)gUseExtDiff;
	noWhiteSpace   = (bool)gNoWhiteSpace;
	noBlankLines   = (bool)gNoBlankLines;
	ignoreCase     = (bool)gIgnoreCase;
	useUnifiedDiff = (bool)gUnifiedDiff;
	
	bool hasRev1 = false;
	bool hasRev2 = false;
	
//{ Win32 - Part
#ifdef WIN32
	COptionalPropertySheet pages(gCvsPrefs.HideCommandDlgDiff(), "Diff settings");
	pages.m_psh.dwFlags |= PSH_NOAPPLYNOW;
	CDiff_MAIN page1(mf, sLastRev1, sLastRev2, allowExtDiff, useExtDiff, noWhiteSpace, ignoreCase);
	CGetPrefs_GLOBALS page2;
	pages.AddPage(&page1);
	pages.AddPage(&page2);

	if( pages.DoModal() == IDOK )
	{
		noRecurs = page1.m_norecurs ? true : false;

		sLastRev1 = page1.m_rev1;
		sLastRev2 = page1.m_rev2;
		isDate1 = page1.m_isDate1 ? true : false;
		isDate2 = page1.m_isDate2 ? true : false;

		gUseExtDiff = page1.m_extdiff ? true : false;
		
		if( page1.m_diff == 0 )
		{
			hasRev1 = hasRev2 = false;
		}
		else if( page1.m_diff == 1 )
		{
			hasRev1 = true;
			hasRev2 = false;
		}
		else
		{
			hasRev1 = true;
			hasRev2 = true;
		}

		gNoWhiteSpace = page1.m_noWhiteSpace ? true : false;
		gIgnoreCase = page1.m_ignoreCase ? true : false;

		page2.StoreValues();
		gCvsPrefs.SetHideCommandDlgDiff(pages.GetHideCommandDlg());
		userHitOK = true;
	}
#endif /* WIN32 */
//} Win32 - Part
//{ Mac - Part
#ifdef qMacCvsPP
	StDialogHandler	theHandler(dlg_Diff, LCommander::GetTopCommander());
	LWindow *theDialog = theHandler.GetDialog();
	ThrowIfNil_(theDialog);
	static UInt16 sRuntimePanel = 1;
	
	LMultiPanelView *multiView = dynamic_cast<LMultiPanelView*>
		(theDialog->FindPaneByID(item_MultiViewPrefs));
	LPane *groupView = theDialog->FindPaneByID(item_GroupViewPrefs);
	
	multiView->SwitchToPanel(2);
	DoDataExchange_Globals(theDialog, true);
	multiView->SwitchToPanel(1);
	DoDataExchange_DiffMain(theDialog, noRecurs, isDate1, isDate2, sLastRev1, sLastRev2,
		hasRev1, hasRev2, true);
	
	groupView->SetValue(sRuntimePanel);
	theDialog->Show();
	MessageT hitMessage;
	while (true)
	{		// Let DialogHandler process events
		hitMessage = theHandler.DoDialog();
		
		if (hitMessage == msg_OK || hitMessage == msg_Cancel)
			break;
	}
	theDialog->Hide();
	sRuntimePanel = groupView->GetValue();
	
	if(hitMessage == msg_OK)
	{
		multiView->SwitchToPanel(1);
		DoDataExchange_DiffMain(theDialog, noRecurs, isDate1, isDate2, sLastRev1, sLastRev2,
			hasRev1, hasRev2, false);
		multiView->SwitchToPanel(2);
		DoDataExchange_Globals(theDialog, false);
		userHitOK = true;
	}
#endif /* qMacCvsPP */
//} Mac - Part
//{ Unix - Part
#if qUnix
	void *wid = UCreate_DiffDlg();

	UCvsDiff *dlg = new UCvsDiff();
	UCvsDiff_MAIN *tab1 = new UCvsDiff_MAIN(sLastRev1, sLastRev2, allowExtDiff, useUnifiedDiff, noWhiteSpace, noBlankLines, ignoreCase);
	UEventSendMessage(dlg->GetWidID(), EV_INIT_WIDGET, kUMainWidget, wid);	
	dlg->AddPage(tab1, UCvsDiff::kTabGeneral, 0);

	if(dlg->DoModal())
	{
		noRecurs = tab1->m_norecurs;
		
		gNoWhiteSpace   = tab1->m_noWhiteSpace != 0;
		gNoBlankLines   = tab1->m_noBlankLines != 0;
		gIgnoreCase     = tab1->m_ignoreCase != 0;
		gUseUnifiedDiff = tab1->m_unifiedDiff != 0;
		gUseExtDiff     = tab1->m_extdiff;
		
		sLastRev1 = tab1->m_str1;
		sLastRev2 = tab1->m_str2;
		isDate1 = tab1->m_check1;
		isDate2 = tab1->m_check2;

		if(tab1->m_diff == 0)
		{
			hasRev1 = hasRev2 = false;
		}
		else if(tab1->m_diff == 1)
		{
			hasRev1 = true;
			hasRev2 = false;
		}
		else
		{
			hasRev1 = true;
			hasRev2 = true;
		}

		userHitOK = true;
	}

	delete dlg;
#endif // qUnix
//} Unix - Part

	if( userHitOK )
	{
		if( hasRev1 )
			rev1 = sLastRev1;

		if( hasRev2 )
			rev2 = sLastRev2;
		
		useExtDiff     = (bool)gUseExtDiff;
		noWhiteSpace   = (bool)gNoWhiteSpace;
		noBlankLines   = (bool)gNoBlankLines;
		useUnifiedDiff = (bool)gUseUnifiedDiff;
		ignoreCase     = (bool)gIgnoreCase;

		gCvsPrefs.save();
	}

	return userHitOK;
}
