/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@hotmail.com> --- December 1997
 */

/*
 * AppGlue.mac.cpp --- glue code to access CVS shared library
 */

/* here should be a define, to recorgnize if this file is needed in development-tools */
#ifdef TARGET_OS_MAC

#include "stdafx.h"
#include "AppGlue.mac.h"
#include "AppGlue.h"
#include "MacCvsApp.h"
#include "AppConsole.h"
#include "dll_process.h"
#include "FileTraversal.h"

#if TARGET_RT_MAC_CFM
#	include "GUSIMSLSetup.h"
#endif

int glue_eventdispatcher(EventRecord *ev)
{
#if TARGET_RT_MAC_CFM
	if(CMacCvsApp::gApp == 0L || !(CMacCvsApp::gApp->IsCvsRunning() || TraversalReport::gRunning))
		return 0;
#else
	if(CMacCvsApp::gApp == 0L)
		return 0;
#endif
	
	EventRecord	localEvent;
	if (!ev) {
		//	Spin callback
		UInt32	kSpinSleep = TraversalReport::gRunning ? CMacCvsApp::gApp->GetSleepTime() : 6;
			// for CWCVS, we want to go fast on background. But for a traversal operation,
			// we want to be smooth
		static	UInt32	spinTicks = 0;
		if ((::TickCount () - spinTicks) < kSpinSleep)
			return 0;
		
		ev = &localEvent;
		::WaitNextEvent (everyEvent, ev, kSpinSleep, nil);
		spinTicks = ::TickCount ();
	} // if
	
	if(ev->what == mouseDown)
	{
		WindowPtr macWindowP;
		SInt16 thePart = ::FindWindow(ev->where, &macWindowP);
		switch (thePart)
		{
			case inDrag:
			case inGrow:
			case inZoomIn:
			case inZoomOut:
				CMacCvsApp::gApp->DispatchEvent(*ev);
				break;
			case inContent:
				if (macWindowP != ::FrontWindow())
				{
					// Clicked Window is not the front one
					LWindow *frontW = LWindow::FetchWindowObject(macWindowP);
					if (frontW != nil && !UDesktop::WindowIsSelected(frontW))
						CMacCvsApp::gApp->DispatchEvent(*ev);
				}
				break;
		}
		return 0;
	}
	else if(ev->what == nullEvent)
	{
		CMacCvsApp::gApp->DoSpinCursor();
	}
	else if(ev->what != keyDown && ev->what != keyUp && ev->what != mouseUp)
	{
		CMacCvsApp::gApp->DispatchEvent(*ev);
	}
	return 0;
}

bool loadCVS(CompatConnectID & connID)
{
	int result = 0;
	const char *name_dll2;
	
#if TARGET_RT_MAC_CFM
	// restore it in case it was not restored correctly by lsh
	GusiMSLSetWriteConsole(GUSIMSL_WriteConsoleHook);
	GusiMSLSetErrConsole(GUSIMSL_WriteErrHook);
	GusiMSLSetHandleEvent(GUSIMSL_HandleEventHook);
#endif

	// get cvs shared library
#if qCarbon
#	if qCvsDebug
		name_dll2 = "cvsXDbgLib";
#	else
		name_dll2 = "cvsXLib";
#	endif
#else
#	if qCvsDebug
		name_dll2 = "cvs2DbgLib";
#	else
		name_dll2 = "cvs2Lib";
#	endif
#endif

	// open the library
	if(!CompatLoadLibrary(&connID, name_dll2))
	{
		cvs_err("Error: Unable to load the library %s\n", name_dll2);
		return false;
	}

	// set the console out
	if(!CompatCallLibrary1(connID, result, uppSetGlueProcInfo, "dllglue_setconsoleout",
		dllglue_setglue_func, CompatFuncArg(uppConsoleOutProcInfo, glue_consoleout)))
	{
		cvs_err("Error : Cannot find symbol ""dllglue_setconsoleout""\n");
		goto closeandfail;
	}

	// set the console err
	if(!CompatCallLibrary1(connID, result, uppSetGlueProcInfo, "dllglue_setconsoleerr",
		dllglue_setglue_func, CompatFuncArg(uppConsoleOutProcInfo, glue_consoleerr)))
	{
		cvs_err("Error : Cannot find symbol ""dllglue_setconsoleerr""\n");
		goto closeandfail;
	}

	// set the console in
	if(!CompatCallLibrary1(connID, result, uppSetGlueProcInfo, "dllglue_setconsolein",
		dllglue_setglue_func, CompatFuncArg(uppConsoleInProcInfo, glue_consolein)))
	{
		cvs_err("Error : Cannot find symbol ""dllglue_setconsolein""\n");
		goto closeandfail;
	}

	// set the getenv
	if(!CompatCallLibrary1(connID, result, uppSetGlueProcInfo, "dllglue_setgetenv",
		dllglue_setglue_func, CompatFuncArg(uppGetEnvProcInfo, glue_getenv)))
	{
		cvs_err("Error : Cannot find symbol ""dllglue_setgetenv""\n");
		goto closeandfail;
	}

	// set the event dispatcher
	if(!CompatCallLibrary1(connID, result, uppSetGlueProcInfo, "dllglue_seteventdispatch",
		dllglue_setglue_func, CompatFuncArg(uppEventDispatchProcInfo, glue_eventdispatcher)))
	{
		cvs_err("Error : Cannot find symbol ""dllglue_seteventdispatch""\n");
		goto closeandfail;
	}

	CMacCvsApp::gApp->SetCvsRunning(true);
	
	return true;

closeandfail:
	CompatCloseLibrary(&connID);
	return false;
}

void unloadCVS(CompatConnectID connID, int exitc)
{	
#if TARGET_RT_MAC_CFM
	// restore it in case it was not restored correctly by lsh
	GusiMSLSetWriteConsole(GUSIMSL_WriteConsoleHook);
	GusiMSLSetErrConsole(GUSIMSL_WriteErrHook);
	GusiMSLSetHandleEvent(GUSIMSL_HandleEventHook);
#endif

	CompatCloseLibrary(&connID);

	glue_exit(exitc);

	CMacCvsApp::gApp->SetCvsRunning(false);
}

int decodeCVS(char* path)
{
	gConsole = 0;
	
	CompatConnectID connID;
	
	if(!loadCVS(connID))
		return errInternal;
	
	int exitc = 0;

	// call the main
	if(!CompatCallLibrary1(connID, exitc, uppDecodeFileProcInfo, "dllglue_decode_file",
		dllglue_decode_file_func, path))
	{
		cvs_err("Error : Cannot find symbol ""dllglue_decode_file""\n");
		exitc = errInternal;
	}

	unloadCVS(connID, exitc);
	
	return exitc;
}

long GUSIMSL_WriteConsoleHook(char *buffer, long n)
{
	return glue_consoleout(buffer, n);
}
long GUSIMSL_WriteErrHook(char *buffer, long n)
{
	return glue_consoleerr(buffer, n);
}
int GUSIMSL_HandleEventHook(EventRecord *ev)
{
	return glue_eventdispatcher(ev);
}

#endif /* TARGET_OS_MAC */
