/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@hotmail.com> --- December 1997
 */

/*
 * AppGlue.h --- glue code to access CVS services
 */

#ifndef APPGLUE_H
#define APPGLUE_H

#include <stdio.h>
#include <vector>

#define errInternal -99
#define errThreadRunning -98

// hooks for cvs
extern "C" {
	extern long glue_consoleout(char* txt, long len);
	extern long glue_consoleerr(char* txt, long len);
	extern long glue_consolein(char* txt, long len);
	extern const char* glue_getenv(char* name);
	extern void glue_exit(int code);
}

class CCvsConsole;
extern CCvsConsole* gConsole;

class CvsArgs;
class UStr;
class CStr;

int testCVS(const char* path, int argc, char* const* argv);
int launchCVS(const char* path, int argc, char* const* argv, CCvsConsole* console = 0L);
void stopCVS();

FILE* launchCVS(const char* dir, const CvsArgs& args, UStr& tmpFile, 
				const char* prefix = 0L, const char* extension = 0L);

const char* launchCVS(const char* dir, const CvsArgs& args, 
					  const char* prefix = 0L, const char* extension = 0L);

#if defined(WIN32) || TARGET_RT_MAC_MACHO
	/// Wait for the cvs thread to terminate
	void WaitForCvs(void);
#else
#	define WaitForCvs()
#endif

/// Base class for cvs process console
class CCvsConsole
{
public:
	/// Stdout handler
	virtual long cvs_out(char* txt, long len) = 0L;

	/// Stderr handler
	virtual long cvs_err(char* txt, long len) = 0L;
};

/// Class to implement stream console
class CStreamConsole : public CCvsConsole
{
public:
	CStreamConsole(FILE* out);

	virtual long cvs_out(char* txt, long len);
	virtual long cvs_err(char* txt, long len);

protected:
	FILE* m_fOut;	/*!< Out file handle */
};

/// Class to setup authentication model and proper environment
class CAuthenSetUp
{
public:
	CAuthenSetUp();
	virtual ~CAuthenSetUp();
};

/// Class to support the clean up of any temporary files created
class CTmpFiles
{
public:
	CTmpFiles();
	virtual ~CTmpFiles();
	const char* push_back(const char* file);
protected:
	std::vector<CStr> m_allfiles;	/*!< Files collection */
};

#endif /* APPGLUE_H */
