/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Jerzy Kaczorowski <kaczoroj@hotmail.com> --- June 2001
 */

/*
 * AnnotateDlg.cpp : the cvs annotate dialog
 */

#include "stdafx.h"

#ifdef WIN32
#	include "wincvs.h"
#	include "OptionalPropertySheet.h"
#endif /* WIN32 */

#if qUnix
#	include "UCvsDialogs.h"
#endif

#ifdef qMacCvsPP
#	include <UModalDialogs.h>
#	include <LRadioButton.h>
#	include <LEditText.h>
#	include <LCheckBox.h>
#	include <LMultiPanelView.h>
#	include <LPopupGroupBox.h>
#	include "LPopupFiller.h"

#	include "MacCvsApp.h"
#endif /* qMacCvsPP */

#include "AnnotateDlg.h"
#include "CvsPrefs.h"
#include "MultiString.h"
#include "MultiFiles.h"
#include "ItemListDlg.h"

#ifdef WIN32
#include "GetPrefs.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAnnotate_MAIN property page

IMPLEMENT_DYNAMIC(CAnnotate_MAIN, CPropertyPage)

CAnnotate_MAIN::CAnnotate_MAIN(const MultiFiles* mf, 
							   const char* rev, bool isDate) 
							   : m_mf(mf), CPropertyPage(CAnnotate_MAIN::IDD)
{
	m_hasRev = FALSE;
	m_isDate = isDate;
	m_strRev = rev;
	m_force = FALSE;
	m_noRecurse = FALSE;

	m_revCombo.SetItems(m_isDate ? &gDateNames : &gRevNames);
}

CAnnotate_MAIN::~CAnnotate_MAIN()
{
}

void CAnnotate_MAIN::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAnnotate_MAIN)
	DDX_Control(pDX, IDC_COMBO_REV, m_revCombo);
	DDX_Check(pDX, IDC_SPECIFY_REV, m_hasRev);
	DDX_Check(pDX, IDC_ISDATE, m_isDate);
	DDX_Check(pDX, IDC_FORCE, m_force);
	DDX_Check(pDX, IDC_NORECURS, m_noRecurse);
	DDX_CBString(pDX, IDC_COMBO_REV, m_strRev);
	//}}AFX_DATA_MAP

	if( m_hasRev )
	{
		DDV_MinChars(pDX, m_strRev, 1);
	}
	
	DDX_ComboMString(pDX, IDC_COMBO_REV, m_revCombo);

	if( !pDX->m_bSaveAndValidate )
	{
		OnSpecifyRev();
	}
}


BEGIN_MESSAGE_MAP(CAnnotate_MAIN, CPropertyPage)
//{{AFX_MSG_MAP(CAnnotate_MAIN)
ON_BN_CLICKED(IDC_SPECIFY_REV, OnSpecifyRev)
ON_BN_CLICKED(IDC_ISDATE, OnIsdate)
	ON_BN_CLICKED(IDC_BROWSE_TAG, OnBrowseTag)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAnnotate_MAIN message handlers

void CAnnotate_MAIN::OnSpecifyRev() 
{
	CButton* btnHasRev = (CButton*)GetDlgItem(IDC_SPECIFY_REV);
	CWnd* wndIsDate = GetDlgItem(IDC_ISDATE);
	CWnd* wndRev = GetDlgItem(IDC_COMBO_REV);
	CWnd* wndForce = GetDlgItem(IDC_FORCE);
	CWnd* wndBrowseTag = GetDlgItem(IDC_BROWSE_TAG);
	
	BOOL bEnable = btnHasRev->GetCheck();
	
	wndIsDate->EnableWindow(bEnable);
	wndRev->EnableWindow(bEnable);
	wndForce->EnableWindow(bEnable);
	wndBrowseTag->EnableWindow(bEnable && !((CButton*)wndIsDate)->GetCheck());
}

void CAnnotate_MAIN::OnIsdate() 
{
	CButton* btnIsDate = (CButton*)GetDlgItem(IDC_ISDATE);
	BOOL isDate = btnIsDate->GetCheck();

	m_revCombo.SetItems(isDate ? &gDateNames : &gRevNames);
	DDX_ComboMString(NULL, IDC_COMBO_REV, m_revCombo);

	GetDlgItem(IDC_BROWSE_TAG)->EnableWindow(!isDate);
}

void CAnnotate_MAIN::OnBrowseTag() 
{
	CPStr tagName;
	if( CompatGetTagListItem(m_mf, tagName) )
	{
		m_strRev = (const char*)tagName;
		m_revCombo.SetWindowText(m_strRev);
	}
}

#endif /* WIN32 */

/// Get the annotate options
bool CompatGetAnnotate(const MultiFiles* mf, bool& noRecurs, bool& isDate, CPStr& rev, bool& force)
{
	bool userHitOK = false;

	static CPStr sLastRev;
	static bool bIsDate = false;
	
	rev = "";
	noRecurs = false;
	force = false;
	bool hasRev = false;
	isDate = bIsDate;
	
#ifdef WIN32
	COptionalPropertySheet pages(gCvsPrefs.HideCommandDlgAnnotate(), "Annotate settings");
	pages.m_psh.dwFlags |= PSH_NOAPPLYNOW;
	CAnnotate_MAIN page1(mf, sLastRev, isDate);
	CGetPrefs_GLOBALS page2;
	pages.AddPage(&page1);
	pages.AddPage(&page2);
	if(pages.DoModal() == IDOK)
	{
		noRecurs = page1.m_noRecurse == TRUE;

		sLastRev = page1.m_strRev;
		isDate = page1.m_isDate == TRUE;
		hasRev = page1.m_hasRev == TRUE;
		force = page1.m_force == TRUE;

		page2.StoreValues();
		gCvsPrefs.SetHideCommandDlgAnnotate(pages.GetHideCommandDlg());
		userHitOK = true;
	}
#endif /* WIN32 */

#ifdef qMacCvsPP
#endif /* qMacCvsPP */

#if qUnix
#endif // qUnix
	
	if(userHitOK)
	{
		if(hasRev)
			rev = sLastRev;
		bIsDate = isDate;
		
		gCvsPrefs.save();
	}
	
	return userHitOK;
}

