/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@hotmail.com> --- December 1997
 */

// wincvsView.h : interface of the CWincvsView class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_WINCVSVIEW_H__D2D77DD0_8299_11D1_8949_444553540000__INCLUDED_)
#define AFX_WINCVSVIEW_H__D2D77DD0_8299_11D1_8949_444553540000__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include <afxrich.h>
#include "AppConsole.h"

class CWincvsDoc;

class CCvsThreadLock
{
public:
	static CRITICAL_SECTION m_lock;

	CCvsThreadLock()
	{
		EnterCriticalSection(&m_lock);
	}
	~CCvsThreadLock()
	{
		LeaveCriticalSection(&m_lock);
	}
};

#if _RICHEDIT_VER >= 0x0210
#	define WCHARFORMAT CHARFORMAT2
#else
#	define WCHARFORMAT CHARFORMAT
#endif


class CWincvsView : public CRichEditView
{
protected: // create from serialization only
	CWincvsView();
	DECLARE_DYNCREATE(CWincvsView)

// Attributes
public:
	CWincvsDoc* GetDocument();
	void OutConsole(const char *txt, long len, bool isStderr = false);
		// insert "len" character

	void OutColor(const char *txt, long len);
	void OutColor(kConsoleColor color);
	void OutColor(WCHARFORMAT & format);
		// colorized output

	WCHARFORMAT GetCurFormat(bool jumpEnd = true);
		// get current format of the text (this call put the cursor
		// at the end of the text by default)

// Operations
public:

	BOOL CanPaste() const;

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CWincvsView)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	protected:
	virtual void OnInitialUpdate(); // called first time after construct
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual BOOL IsSelected(const CObject* pDocItem) const;// Container support
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CWincvsView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:
#	define MAX_CHAR_BY_LINE 1024
	static char *sbuf;
	static int snumbuf;
	UINT fRtfFormat;

	void FeedThisLine(const char *buf, int numbuf, bool isStderr);

	virtual HRESULT QueryAcceptData(LPDATAOBJECT, CLIPFORMAT*, DWORD,
		BOOL, HGLOBAL);

// Generated message map functions
protected:
	//{{AFX_MSG(CWincvsView)
	afx_msg void OnDestroy();
	afx_msg void OnSetFocus(CWnd* pOldWnd);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnMyFormatFont();
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnDropFiles(HDROP hDropInfo);
	afx_msg void OnEditClearAll();
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg UINT OnGetDlgCode();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in wincvsView.cpp
inline CWincvsDoc* CWincvsView::GetDocument()
   { return (CWincvsDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_WINCVSVIEW_H__D2D77DD0_8299_11D1_8949_444553540000__INCLUDED_)
