// ToolbarCombo.cpp : implementation file
//

#include "stdafx.h"
#include "wincvs.h"
#include "ToolbarCombo.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

BEGIN_MESSAGE_MAP(CToolbarCombo, CComboBoxEx)
	//{{AFX_MSG_MAP(CToolbarCombo)
	ON_CONTROL_REFLECT(CBN_SELENDOK, OnSelendok)
	ON_CONTROL_REFLECT(CBN_SELENDCANCEL, OnSelendcancel)
	//}}AFX_MSG_MAP
	ON_MESSAGE(CTbEdit::WM_CONTENTCHANGE, OnContentChange)
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CToolbarCombo

CToolbarCombo::CToolbarCombo()
{
}

CToolbarCombo::~CToolbarCombo()
{
}

BOOL CToolbarCombo::Create( DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID )
{
	if (!CComboBoxEx::Create(dwStyle, rect, pParentWnd, nID))
	{
		return FALSE;
	}
	SetExtendedStyle(CBES_EX_CASESENSITIVE, CBES_EX_CASESENSITIVE);
	m_edit.SubclassWindow(GetEditCtrl()->m_hWnd);
	m_edit.SetOwner(this);
	return TRUE;
}

LRESULT CToolbarCombo::OnContentChange(WPARAM wp, LPARAM lp)
{
	bool complete = wp != 0;
	if (complete)
	{
		CString text;
		m_edit.GetWindowText(text);
		SetText(text);
	}
	else
	{
		// restore previous text
		ResetText();
	}
	return 0;
}

void CToolbarCombo::ResetText()
{
	m_edit.SetWindowText(m_text);
}

void CToolbarCombo::SetText(const CString& text)
{
	if (m_text.Compare(text) != 0)
	{
		m_text = text;

		// append selection to combo box
		int count = GetCount();
		for (int i = count - 1; i >= 0 ; i--)
		{
			TCHAR buffer[256];
			GetItemText(i, buffer, 256);
			if (text.Compare(buffer) == 0)
			{
				DeleteItem(i);
			}
		}
		COMBOBOXEXITEM item;
		item.mask = CBEIF_TEXT;
		item.iItem = 0;
		item.pszText = (LPTSTR)(LPCTSTR)text;
		InsertItem(&item);
		count = GetCount();
		while (count > 8)
		{
			count--;
			DeleteItem(count);
		}

		m_manager.NotifyAll();
	}
}

void CToolbarCombo::GetItemText(int pos, LPTSTR buffer, int count)
{
	COMBOBOXEXITEM item;
	item.mask = CBEIF_TEXT;
	item.pszText = buffer;
	item.cchTextMax = count;
	item.iItem = pos;
	VERIFY(GetItem(&item));
}

void CToolbarCombo::OnSelendok()
{
	CComboBox* combo = GetComboBoxCtrl();
	int pos = combo->GetCurSel();
	if (pos >= 0)
	{
		TCHAR buffer[256];
		GetItemText(pos, buffer, 256);
		SetText(buffer);
		ResetText();
	}
}

void CToolbarCombo::OnSelendcancel()
{
	ResetText();
}
