// CvsStatusBar.cpp : implementation file
//

#include "stdafx.h"
#include "wincvs.h"
#include "CvsStatusBar.h"
#include "CvsPrefs.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CCvsStatusBar

CCvsStatusBar::CCvsStatusBar() : m_step(-1), m_settimer(false)
{
	m_indic.LoadBitmap(IDB_IDLE);
}

CCvsStatusBar::~CCvsStatusBar()
{
}

void CCvsStatusBar::DrawItem(LPDRAWITEMSTRUCT p)
{
	if( !m_settimer )
	{
		SetTimer(999, 100, 0L);
		m_settimer = true;
	}

	CWincvsApp* app = (CWincvsApp*)AfxGetApp();
	if( !app->IsCvsRunning() && !gCvsPrefs.IsTclFileRunning() )
		return;

	static int tab[12] = {
		-2, -1, 1, 4, 8, 11, 13, 11,
		8, 4, 1, -1};
	CDC hdc;
	CBrush b(RGB(0, 0, 0xFF));

	hdc.Attach(p->hDC);
	CRect r(p->rcItem);
	hdc.FillRect(r, &b);
	CPoint off(r.TopLeft());
	off.x -= m_step;
	int cnt = 0;
	while(off.x < r.right)
	{
		CPoint offy(off);
		offy.y += tab[(m_step + cnt) % 12];
		hdc.DrawState(offy, CSize(16,16), m_indic, DSS_NORMAL);
		off.x += 24;
		cnt++;
	}
	
	hdc.Detach();
}

void CCvsStatusBar::OnTimer(UINT nIDEvent) 
{
	CWincvsApp* app = (CWincvsApp*)AfxGetApp();
	if( app->IsCvsRunning() || gCvsPrefs.IsTclFileRunning() )
	{
		if( m_step-- <= 0 )
			m_step = 23;

		CRect r;
		GetItemRect(1, r);
		InvalidateRect(r, FALSE);
	}
	else if( m_step != -1 )
	{
		m_step = -1;
		CRect r;
		GetItemRect(1, r);
		InvalidateRect(r, FALSE);
	}
}

BEGIN_MESSAGE_MAP(CCvsStatusBar, CStatusBar)
	//{{AFX_MSG_MAP(CCvsStatusBar)
	ON_WM_TIMER()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCvsStatusBar message handlers
