// CvsProject.h: interface for the CvsProject class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_CVSPROJECT_H__582FF611_FAA5_11D2_B442_0080C6F9179D__INCLUDED_)
#define AFX_CVSPROJECT_H__582FF611_FAA5_11D2_B442_0080C6F9179D__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "CvsString.h"
#include "CvsFilenames.h"
//#include "CVS_Coworker.h"

//
//  Context for a Project.
//

class CvsProject
{
public:
    CvsProject();
    ~CvsProject();
public:
    int getProjectHandle() { return m_hProject; }
    int getLastError() { return m_iLastError; }
    const char* getProjectName() { return m_sProjectName; }
    const char* getProjectHome() { return m_sProjectHome; }
public:
    static CvsProject* FindProject(int);
public:
    bool getErrorMessage(int,CvsString&);
public:
    bool getFilesToAdd(CvsString&);
    bool getFileChanges(CvsString&);
    bool showAdvancedOptionsForCommand(CvsCommand);
    bool hasAdvancedOptionsForCommand(CvsCommand,BOOL&);
    bool showUserInterface(CvsFilenames&);
    bool showFileProperties(const char*);
    bool showFileHistory(CvsFilenames&);
    bool isFileDifferent(const char*,CvsOption,BOOL&);
    bool diffFile(const char*,BOOL,BOOL);
    bool renameFile(const char*,const char*);
    bool removeFiles(CvsFilenames&);
    bool addFiles(CvsFilenames&,const char*);
    bool uncheckoutFiles(CvsFilenames&);
    bool checkinFiles(CvsFilenames&,BOOL);
    bool checkoutFiles(CvsFilenames&);
    bool updateFiles(CvsFilenames&,BOOL,BOOL);
    bool getProject(const char*,const char*,const char*,BOOL,BOOL,BOOL&);
    bool openProject(const char*,const char*,const char*);
    bool closeProject();
protected:
    CvsProject*     m_pNextProject;
    int             m_hProject;
    int             m_iLastError;
    CvsString       m_sProjectName;
    CvsString       m_sProjectHome;
    CvsString       m_sUsername;
};

#endif // !defined(AFX_CVSPROJECT_H__582FF611_FAA5_11D2_B442_0080C6F9179D__INCLUDED_)
