/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Jerzy Kaczorowski <kaczoroj@hotmail.com> --- March 2002
 */

/*
 * StatusDlg.cpp : the cvs status dialog
 */

#include "stdafx.h"

#ifdef WIN32
#	include "wincvs.h"
#	include "OptionalPropertySheet.h"
#endif /* WIN32 */

#if qUnix
#	include "UCvsDialogs.h"
#endif

#ifdef qMacCvsPP
#	include <UModalDialogs.h>
#	include <LRadioButton.h>
#	include <LEditText.h>
#	include <LCheckBox.h>
#	include <LMultiPanelView.h>
#	include <LPopupGroupBox.h>
#	include "LPopupFiller.h"

#	include "MacCvsApp.h"
#endif /* qMacCvsPP */

#include "StatusDlg.h"

#ifdef WIN32
#include "GetPrefs.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CStatus_MAIN property page

IMPLEMENT_DYNCREATE(CStatus_MAIN, CPropertyPage)

CStatus_MAIN::CStatus_MAIN() : CPropertyPage(CStatus_MAIN::IDD)
{
	//{{AFX_DATA_INIT(CStatus_MAIN)
	m_noRecurs = FALSE;
	m_outputType = -1;
	//}}AFX_DATA_INIT
}

CStatus_MAIN::CStatus_MAIN(bool noRecurs, STATUSOUTPUT_TYPE outputType) 
	: CPropertyPage(CStatus_MAIN::IDD)
{
	m_noRecurs = noRecurs;
	m_outputType = (int)outputType;
}

CStatus_MAIN::~CStatus_MAIN()
{
}

void CStatus_MAIN::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CStatus_MAIN)
	DDX_Check(pDX, IDC_NORECURS, m_noRecurs);
	DDX_Radio(pDX, IDC_OUTPUT_STANDARD, m_outputType);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CStatus_MAIN, CPropertyPage)
	//{{AFX_MSG_MAP(CStatus_MAIN)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CStatus_MAIN message handlers

#endif /* WIN32 */

bool CompatGetStatus(bool& noRecurs, STATUSOUTPUT_TYPE& outputType)
{
	bool userHitOK = false;

	noRecurs = false;
	outputType = gCvsPrefs.StatusOutputType();
	
#ifdef WIN32
	COptionalPropertySheet pages(gCvsPrefs.HideCommandDlgStatus(), "Status settings");
	pages.m_psh.dwFlags |= PSH_NOAPPLYNOW;
	CStatus_MAIN page1(noRecurs, outputType);
	CGetPrefs_GLOBALS page2;
	pages.AddPage(&page1);
	pages.AddPage(&page2);

	if( pages.DoModal() == IDOK )
	{
		noRecurs = page1.m_noRecurs ? true : false;
		gCvsPrefs.SetStatusOutputType((STATUSOUTPUT_TYPE)page1.m_outputType);

		page2.StoreValues();
		gCvsPrefs.SetHideCommandDlgStatus(pages.GetHideCommandDlg());
		userHitOK = true;
	}
#endif /* WIN32 */

#ifdef qMacCvsPP
#endif /* qMacCvsPP */

#if qUnix
#endif // qUnix
	
	if( userHitOK )
	{
		outputType = gCvsPrefs.StatusOutputType();
		
		gCvsPrefs.save();
	}
	
	return userHitOK;
}
