/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@hotmail.com> --- December 1997
 */

// wincvsDoc.cpp : implementation of the CWincvsDoc class
//

#include "stdafx.h"
#include "wincvs.h"
#include <afxrich.h>

#include "wincvsDoc.h"
#include "CvsCommands.h"
#include "GetPrefs.h"
#include "Authen.h"
#include "CvsPrefs.h"
#include "AppConsole.h"
#include "PromptFiles.h"
#include "WinCvsBrowser.h"
#include "TclGlue.h"
#include "PythonGlue.h"
#include "MacrosSetup.h"
#include "cvsgui_process.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CWincvsDoc

IMPLEMENT_DYNCREATE(CWincvsDoc, CDocument)

BEGIN_MESSAGE_MAP(CWincvsDoc, CDocument)
	//{{AFX_MSG_MAP(CWincvsDoc)
	ON_COMMAND(ID_APP_PREFERENCES, OnAppPreferences)
	ON_COMMAND(ID_APP_RTAGCREATE, OnAppRtagNew)
	ON_COMMAND(ID_APP_RTAGDELETE, OnAppRtagDelete)
	ON_COMMAND(ID_APP_RTAGBRANCH, OnAppRtagBranch)
	ON_COMMAND(ID_APP_CMDLINE, OnAppCmdline)
	ON_UPDATE_COMMAND_UI(ID_APP_RTAGCREATE, OnUpdateCvsCmd)
	ON_UPDATE_COMMAND_UI(ID_APP_PREFERENCES, OnUpdatePrefs)
	ON_COMMAND(ID_STOPCVS, OnStopcvs)
	ON_UPDATE_COMMAND_UI(ID_STOPCVS, OnUpdateStopcvs)
	ON_COMMAND(ID_BROWSER_OPEN, OnBrowserOpen)
	ON_COMMAND(ID_APP_LOGIN, OnAppLogin)
//	ON_UPDATE_COMMAND_UI(ID_MACRO_ADMIN, OnUpdateMacroAdmin)
	ON_COMMAND(ID_APP_LOGOUT, OnAppLogout)
	ON_COMMAND(ID_VIEW_INIT, OnViewInit)
	ON_COMMAND(ID_SAVESETTINGS, OnSavesettings)
	ON_UPDATE_COMMAND_UI(ID_SAVESETTINGS, OnUpdateSavesettings)
	ON_COMMAND(ID_VIEW_BROWSELOCATION_REMOVEUNWANTED, OnViewBrowselocationRemoveunwanted)
	ON_UPDATE_COMMAND_UI(ID_VIEW_INIT, OnUpdateCvsCmd)
	ON_UPDATE_COMMAND_UI(ID_APP_RTAGDELETE, OnUpdateCvsCmd)
	ON_UPDATE_COMMAND_UI(ID_APP_RTAGBRANCH, OnUpdateCvsCmd)
	ON_UPDATE_COMMAND_UI(ID_APP_CMDLINE, OnUpdateCvsCmd)
	ON_UPDATE_COMMAND_UI(ID_APP_LOGIN, OnUpdateCvsCmd)
	ON_UPDATE_COMMAND_UI(ID_BROWSER_OPEN, OnUpdateCvsCmd)
	ON_UPDATE_COMMAND_UI(ID_APP_LOGOUT, OnUpdateCvsCmd)
	ON_UPDATE_COMMAND_UI(ID_VIEW_BROWSELOCATION_REMOVEUNWANTED, OnUpdateCvsCmd)
	ON_COMMAND(ID_USE_PYSHELL, OnUsePyshell)
	ON_UPDATE_COMMAND_UI(ID_USE_PYSHELL, OnUpdateUsePyshell)
	ON_COMMAND(ID_USE_TCLSHELL, OnUseTclshell)
	ON_UPDATE_COMMAND_UI(ID_USE_TCLSHELL, OnUpdateUseTclshell)
	//}}AFX_MSG_MAP
	// Enable default OLE container implementation
	//ON_UPDATE_COMMAND_UI(ID_EDIT_PASTE, CDocument::OnUpdatePasteMenu)
//	ON_COMMAND_EX_RANGE(ID_MACRO_ADMIN, ID_MACRO_ADMIN + 99, OnMacroAdmin)
	ON_COMMAND(ID_FILE_SEND_MAIL, OnFileSendMail)
	ON_UPDATE_COMMAND_UI(ID_FILE_SEND_MAIL, OnUpdateFileSendMail)
END_MESSAGE_MAP()

BEGIN_DISPATCH_MAP(CWincvsDoc, CDocument)
	//{{AFX_DISPATCH_MAP(CWincvsDoc)
	DISP_PROPERTY_NOTIFY(CWincvsDoc, "ViewPath", m_viewPath, OnViewPathChanged, VT_BSTR)
	//}}AFX_DISPATCH_MAP
END_DISPATCH_MAP()

// Note: we add support for IID_IWincvs to support typesafe binding
//  from VBA.  This IID must match the GUID that is attached to the 
//  dispinterface in the .ODL file.

// {D2D77DC4-8299-11D1-8949-444553540000}
static const IID IID_IWincvs =
{ 0xd2d77dc4, 0x8299, 0x11d1, { 0x89, 0x49, 0x44, 0x45, 0x53, 0x54, 0x0, 0x0 } };

BEGIN_INTERFACE_MAP(CWincvsDoc, CDocument)
	INTERFACE_PART(CWincvsDoc, IID_IWincvs, Dispatch)
END_INTERFACE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWincvsDoc construction/destruction

CWincvsDoc::CWincvsDoc()
{
	// Use OLE compound files
	//EnableCompoundFile();

	// TODO: add one-time construction code here

	//EnableAutomation();

	//AfxOleLockApp();
}

CWincvsDoc::~CWincvsDoc()
{
	//AfxOleUnlockApp();
}

//CRichEditCntrItem* CWincvsDoc::CreateClientItem(REOBJECT* preo) const
//{
//	return new CRichEditCntrItem(preo, (CRichEditDoc *)this);
//}

BOOL CWincvsDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	return TRUE;
}



/////////////////////////////////////////////////////////////////////////////
// CWincvsDoc serialization

class _afxRichEditCookie
{
public:
	CArchive& m_ar;
	DWORD m_dwError;
	_afxRichEditCookie(CArchive& ar) : m_ar(ar) {m_dwError=0;}
};

// return 0 for no error, otherwise return error code
extern "C" DWORD CALLBACK EditStreamCallBack(DWORD dwCookie, LPBYTE pbBuff, LONG cb, LONG *pcb)
{
	_afxRichEditCookie* pCookie = (_afxRichEditCookie*)dwCookie;
	CArchive& ar = pCookie->m_ar;
	ar.Flush();
	DWORD dw = 0;
	*pcb = cb;
	TRY
	{
		if (ar.IsStoring())
			ar.GetFile()->WriteHuge(pbBuff, cb);
		else
			*pcb = ar.GetFile()->ReadHuge(pbBuff, cb);
	}
	CATCH(CFileException, e)
	{
		*pcb = 0;
		pCookie->m_dwError = (DWORD)e->m_cause;
		dw = 1;
	}
	AND_CATCH_ALL(e)
	{
		*pcb = 0;
		pCookie->m_dwError = (DWORD)CFileException::generic;
		dw = 1;
	}
	END_CATCH_ALL
	return dw;
}

void CWincvsDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		POSITION pos = GetFirstViewPosition();
		CView* view;
		while((view = GetNextView(pos)) != NULL)
		{
			if(view->IsKindOf(RUNTIME_CLASS(CRichEditView)))
			{
				int nFormat = SF_TEXT;
				EDITSTREAM es = {0, 0, (EDITSTREAMCALLBACK)EditStreamCallBack};
				_afxRichEditCookie cookie(ar);
				es.dwCookie = (DWORD)&cookie;
				((CRichEditView *)view)->GetRichEditCtrl().StreamOut(nFormat, es);
				break;
			}
		}
	}
	else
	{
		// We don't load right now
	}

	// Calling the base class CDocument enables serialization
	//  of the container document's COleClientItem objects.
	// (but we don't have COleClientItem)
	CDocument::Serialize(ar);
}

/////////////////////////////////////////////////////////////////////////////
// CWincvsDoc diagnostics

#ifdef _DEBUG
void CWincvsDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CWincvsDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CWincvsDoc commands


void CWincvsDoc::OnAppPreferences()
{
	CompatGetPrefs();
}

void CWincvsDoc::OnAppCmdline() 
{
	CvsCmdLine();
}

void CWincvsDoc::OnAppLogin() 
{
	CvsCmdLogin();
}

void CWincvsDoc::OnUpdateCvsCmd(CCmdUI* pCmdUI) 
{
	CWincvsApp* app = (CWincvsApp *)AfxGetApp();
	pCmdUI->Enable(app->gCvsRunning || gCvsPrefs.empty() ? FALSE : TRUE);
}

void CWincvsDoc::OnUpdatePrefs(CCmdUI* pCmdUI) 
{
	CWincvsApp* app = (CWincvsApp *)AfxGetApp();
	pCmdUI->Enable(app->gCvsRunning ? FALSE : TRUE);
}

void CWincvsDoc::OnStopcvs() 
{
	CWincvsApp* app = (CWincvsApp *)AfxGetApp();
	app->gCvsStopping = true;	
	cvs_process_kill(app->gCvsProcess);
	cvs_out("*****CVS stopped on user request !!! *****\n\n");
}

void CWincvsDoc::OnUpdateStopcvs(CCmdUI* pCmdUI) 
{
	CWincvsApp* app = (CWincvsApp *)AfxGetApp();
	pCmdUI->Enable(app->gCvsRunning && !app->gCvsStopping ? TRUE : FALSE);
}

void CWincvsDoc::OnBrowserOpen() 
{
	const char *newPath =
		BrowserGetDirectory("Select a folder to open with the browser");
	if(newPath == 0L)
		return;

	CWincvsApp* app = (CWincvsApp *)AfxGetApp();
	app->GetBrowserView()->ResetBrowser(newPath, true);	
}

void CWincvsDoc::OnViewPathChanged() 
{
	// TODO: Add notification handler code

}

void CWincvsDoc::OnAppRtagNew() 
{
	CvsCmdRtagCreate();
}

void CWincvsDoc::OnAppRtagDelete()
{
	CvsCmdRtagDelete();
}

void CWincvsDoc::OnAppRtagBranch() 
{
	CvsCmdRtagBranch();
}

BOOL CWincvsDoc::OnMacroAdmin(UINT nID)
{
	CMacroEntry & entry = gMacrosAdmin.entries[nID - ID_MACRO_ADMIN];
	CvsCmdMacrosAdmin(entry.path);

	return 1;
}

void CWincvsDoc::OnUpdateMacroAdmin(CCmdUI* pCmdUI) 
{
	CWincvsApp* app = (CWincvsApp *)AfxGetApp();
	if(app->gCvsRunning || gCvsPrefs.empty() || !CTcl_Interp::IsAvail())
	{
		pCmdUI->Enable(FALSE);
		return;
	}

	if(pCmdUI->m_pSubMenu != 0L || pCmdUI->m_pMenu == 0L)
		return;

	int iMRUMax = pCmdUI->m_pMenu->GetMenuItemCount();
	for (int iMRU = 0; iMRU < iMRUMax; iMRU++)
		pCmdUI->m_pMenu->DeleteMenu(pCmdUI->m_nID + iMRU, MF_BYCOMMAND);

	vector<CMacroEntry>::const_iterator i;
	for(i = gMacrosAdmin.entries.begin(); i != gMacrosAdmin.entries.end(); ++i)
	{
		pCmdUI->m_pMenu->InsertMenu(pCmdUI->m_nIndex++,
			MF_STRING | MF_BYPOSITION, pCmdUI->m_nID++,
			(*i).name);
	}

	pCmdUI->m_nIndexMax = pCmdUI->m_pMenu->GetMenuItemCount();
	pCmdUI->m_nIndex--; // point to last menu added
	pCmdUI->m_bEnableChanged = TRUE;    // all the added items are enabled
}

void CWincvsDoc::OnAppLogout() 
{
	CvsCmdLogout();
}

void CWincvsDoc::OnViewInit() 
{
	CvsCmdInit();
}

void CWincvsDoc::OnSavesettings() 
{
	CWincvsApp* app = (CWincvsApp *)AfxGetApp();
	AskCreatePersistentSettings(app->GetBrowserView()->GetRoot());
}

void CWincvsDoc::OnUpdateSavesettings(CCmdUI* pCmdUI) 
{
	CWincvsApp* app = (CWincvsApp *)AfxGetApp();
	pCmdUI->Enable(!app->gCvsRunning && !gCvsPrefs.empty());
}

void CWincvsDoc::OnViewBrowselocationRemoveunwanted() 
{
	AfxMessageBox("To remove the unwanted location history items click DEL key when selecting from the combo box list.", MB_OK | MB_ICONINFORMATION);
}

void CWincvsDoc::OnUsePyshell() 
{
	gCvsPrefs.SetUseShell(SHELL_PYTHON);
	cvs_out("Switching the shell to Python...\n");
}

void CWincvsDoc::OnUpdateUsePyshell(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(CPython_Interp::IsAvail());
	pCmdUI->SetRadio(gCvsPrefs.GetUseShell() == SHELL_PYTHON);
}

void CWincvsDoc::OnUseTclshell() 
{
	gCvsPrefs.SetUseShell(SHELL_TCL);
	cvs_out("Switching the shell to TCL...\n");
}

void CWincvsDoc::OnUpdateUseTclshell(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(CTcl_Interp::IsAvail());
	pCmdUI->SetRadio(gCvsPrefs.GetUseShell() == SHELL_TCL);
}
