/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@hotmail.com> --- December 1997
 */

/*
 * MacMisc.cpp --- misc. utilities for mac
 */

#ifndef MACMISC_H
#define MACMISC_H

#include "TextBinary.h"
#include "ustr.h"
#include <Dialogs.h>

Handle GetDItemHdl(DialogPtr dlg, SInt16 Id);
ControlHandle GetDItemCtrlHdl(DialogPtr dlg, SInt16 Id);
SInt16 GetDItemMenuSel(DialogPtr dlg, SInt16 Id);
void SetDItemMenuSel(DialogPtr dlg, SInt16 Id, SInt16 sel);

#if TARGET_RT_MAC_CFM
	pascal	OSErr	FSMakeFSSpecCompat(short vRefNum,
									   long dirID,
									   ConstStr255Param fileName,
									   FSSpec & spec);

	extern "C" int stricmp(const char *str1, const char *str2);
	extern "C" int strnicmp(const char *str1, const char *str2, unsigned long size);
#else
#	include <string.h>
#	define stricmp strcasecmp
#	define strnicmp strncasecmp
#endif

OSErr MacGetSpecialFolder(UFSSpec & theFolder, UStr & thePath, OSType inType, const char* inDesc);
OSErr MacGetTempFolder(UFSSpec & theFolder, UStr & thePath);
OSErr MacGetPrefsFolder(UFSSpec & theFolder, UStr & thePath);

#endif /* MACMISC_H */
