/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@hotmail.com> --- March 1998
 */

/*
 * DiffDlg.h : the cvs diff dialog
 */

#if !defined(AFX_DIFFDLG_H__98CCBD22_845B_11D1_8949_444553540000__INCLUDED_)
#define AFX_DIFFDLG_H__98CCBD22_845B_11D1_8949_444553540000__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "CPStr.h"
#include "SmartComboBox.h"

bool CompatGetDiff(bool & noRecurs, bool & isDate1, bool & isDate2,
				   CPStr & rev1, CPStr & rev2, bool & useExtDiff, 
				   bool & noWhiteSpace, bool & ignoreCase,
				   bool allowExtDiff = false);
	// get the diff options...

#ifdef WIN32

class CDiff_MAIN : public CPropertyPage
{
	DECLARE_DYNCREATE(CDiff_MAIN)

// Construction
public:
	CDiff_MAIN(const char *rev1, const char *rev2, bool allowExtDiff, bool noWhiteSpace, bool ignoreCare);
	CDiff_MAIN();
	~CDiff_MAIN();

// Dialog Data
	//{{AFX_DATA(CDiff_MAIN)
	enum { IDD = IDD_DIFF_MAIN };
	CButton	m_extdiffctl;
	CSmartComboBox	m_rev2Combo;
	CSmartComboBox	m_rev1Combo;
	BOOL	m_isDate1;
	BOOL	m_isDate2;
	CString	m_rev1;
	CString	m_rev2;
	int		m_diff;
	BOOL	m_norecurs;
	BOOL	m_extdiff;
	BOOL	m_noWhiteSpace;
	BOOL	m_ignoreCase;
	//}}AFX_DATA

	bool m_allowExtDiff;

// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CDiff_MAIN)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(CDiff_MAIN)
	afx_msg void OnDiff1();
	afx_msg void OnDiff2();
	afx_msg void OnDiff3();
	afx_msg void OnExtdiff();
	afx_msg void OnCheck1();
	afx_msg void OnCheck2();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.
#endif /* WIN32 */

#endif // !defined(AFX_DIFFDLG_H__98CCBD22_845B_11D1_8949_444553540000__INCLUDED_)
