/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@hotmail.com> --- February 1998
 */

/*
 * CommitDlg.h : the cvs commit dialog
 */

#if !defined(AFX_COMMITDLG_H__98CCBD22_845B_11D1_8949_444553540000__INCLUDED_)
#define AFX_COMMITDLG_H__98CCBD22_845B_11D1_8949_444553540000__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "CPStr.h"
#include "MultiString.h"
#include "MultiFiles.h"


bool CompatGetCommit(CStr & commit, bool & norecurs, 
					 bool & forceCommit, bool & forceRecurse, CPStr & rev, bool & noModuleProgram,
					 const char *pathTmpl = 0L,
					 MultiFiles *mf = 0L);
	// get the commit log and misc options...
	// the path is used to read the /path/CVS/Template optionally

void combozify(CStr & str);
	// strip the string with the few first words.

extern CMString gRevNames;

#ifdef WIN32
class CCommit_MAIN : public CPropertyPage
{
	DECLARE_DYNCREATE(CCommit_MAIN)

// Construction
public:
	CCommit_MAIN();
	CCommit_MAIN(const char *logmsg, const char *pathTmpl = 0L, MultiFiles *mf = 0L);
	~CCommit_MAIN();

// Dialog Data
	//{{AFX_DATA(CCommit_MAIN)
	enum { IDD = IDD_COMMIT_MAIN };
	CComboBox	m_fileToDiffCombo;
	CButton	m_wordwrapctrl;
	CEdit	m_logmsgctrlwrap;
	CEdit	m_logmsgctrl;
	CComboBox	m_combodef;
	CString	m_logmsg;
	BOOL	m_norecurs;
	BOOL	m_wordwrap;
	//}}AFX_DATA

	CStr m_tmplPath;
	MultiFiles *m_pmfarg;

// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CCommit_MAIN)
	public:
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(CCommit_MAIN)
	afx_msg void OnSelchangeCombo();
	afx_msg void OnLauncheditor();
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnWordwrap();
	virtual BOOL OnInitDialog();
	afx_msg void OnDiff();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

private:
	void UpdateInfo();
	void SwitchWrapEdit(BOOL bWordWrap);

	BOOL m_bSwitchingWrap;
};

/////////////////////////////////////////////////////////////////////////////
// CCommit_OPTIONS dialog

class CCommit_OPTIONS : public CPropertyPage
{
	DECLARE_DYNCREATE(CCommit_OPTIONS)

// Construction
public:
	CCommit_OPTIONS();
	~CCommit_OPTIONS();

// Dialog Data
	//{{AFX_DATA(CCommit_OPTIONS)
	enum { IDD = IDD_COMMIT_OPTIONS };
	CComboBox	m_refDef;
	BOOL	m_forceCommit;
	CString	m_rev;
	BOOL	m_forceRecurse;
	BOOL	m_forceRevision;
	BOOL	m_noModuleProgram;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CCommit_OPTIONS)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(CCommit_OPTIONS)
	afx_msg void OnForcerevision();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};
//{{AFX_INSERT_LOCATION}}
#endif /* WIN32 */

#endif // !defined(AFX_COMMITDLG_H__98CCBD22_845B_11D1_8949_444553540000__INCLUDED_)
