// MainFrm.h : interface of the CMainFrame class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_MAINFRM_H__D2D77DCC_8299_11D1_8949_444553540000__INCLUDED_)
#define AFX_MAINFRM_H__D2D77DCC_8299_11D1_8949_444553540000__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "ConsoleBar.h"
#include "CvsStatusBar.h"
#include "BrowseViewModel.h"
#include "ToolbarCombo.h"

class CMainFrame : public CCJMDIFrameWnd
{
	DECLARE_DYNAMIC(CMainFrame)
public:
	CMainFrame();
#if 0
protected: // create from serialization only
	CMainFrame();
	DECLARE_DYNCREATE(CMainFrame)
#endif

// Attributes
protected:
	 KoFilterModel m_filter;
	 KoRecursionModel m_recursion;
	 KoIgnoreModel m_ignore;

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CMainFrame)
	public:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	//}}AFX_VIRTUAL

// Implementation
public:
	void DropFiles(HDROP hDropInfo);
	void InitialShowWindow(int nCmdShow);
	virtual ~CMainFrame();

	CWinCvsBrowser *GetBrowserView();
	CCJShellTree *GetExplorerView();
	inline CCJTabCtrlBar *GetWorkspace() { return &m_wndWorkspace; }
	inline CMDIMenuList & GetMenuList(void) { return m_menuList; }

	inline CWincvsView *GetConsoleView() { return m_consolebar.m_view; }
	inline CComboBox & GetBrowseHistory(void) { return m_browseHist; }
	inline CStatusBar *GetStatusBar() { return &m_wndStatusBar; }

	BOOL OnBroadcastCmdMsg(UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo);
		// take care about the cmd msg routing on the dock bars

	char *GetEnvMainThread(const char *name);

	// KiFilterModel implementation
	KiFilterModel* GetFilterModel()
	{
		return &m_filter;
	}

	// KiRecursionModel implementation
	KiRecursionModel* GetRecursionModel()
	{
		return &m_recursion;
	}

	// KiRecursionModel implementation
	KiIgnoreModel* GetIgnoreModel()
	{
		return &m_ignore;
	}

	void OnFilterMaskEntered();

#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:  // control bar embedded members
	CCvsStatusBar  m_wndStatusBar;
	CToolBar    m_wndToolBar;
	CToolBar    m_wndBrowser;
	CToolBar    m_wndMultiUser;
	CToolBar    m_wndTags;
	CToolBar    m_wndList;
	CToolBar    m_wndFilter;
	CComboBox	m_browseHist;
	CToolbarCombo m_comboFilterMask;
	CFont		m_fontNormal;
	CBarConsole	m_consolebar;
	CCJTabCtrlBar	m_wndWorkspace;
	CImageList	m_TabImages;
	CCJWindowPlacement	m_state;

	BOOL InitializeDockingWindows();

// Generated message map functions
protected:
	afx_msg void OnInitMenu(CMenu* pMenu);
	void DockControlBarLeftOf(CToolBar* Bar,CToolBar* LeftOf);
	bool FreshenFileMask();

	//{{AFX_MSG(CMainFrame)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnClose();
	afx_msg void OnDropFiles(HDROP hDropInfo);
	afx_msg void OnHistorySelect();
	afx_msg void OnActivate(UINT nState, CWnd* pWndOther, BOOL bMinimized);
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnViewRecursive();
	afx_msg void OnViewModified();
	afx_msg void OnUpdateViewModified(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewRecursive(CCmdUI* pCmdUI);
	afx_msg void OnViewConflict();
	afx_msg void OnUpdateViewConflict(CCmdUI* pCmdUI);
	afx_msg void OnViewUnknown();
	afx_msg void OnUpdateViewUnknown(CCmdUI* pCmdUI);
	afx_msg void OnViewMissing();
	afx_msg void OnUpdateViewMissing(CCmdUI* pCmdUI);
	afx_msg void OnViewIgnore();
	afx_msg void OnUpdateViewIgnore(CCmdUI* pCmdUI);
	afx_msg void OnUpdateFilterMask(CCmdUI* pCmdUI);
	afx_msg void OnUpdateHistory(CCmdUI* pCmdUI);
	afx_msg void OnViewAdded();
	afx_msg void OnUpdateViewAdded(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewRemoved(CCmdUI* pCmdUI);
	afx_msg void OnViewRemoved();
	afx_msg void OnViewChanged();
	afx_msg void OnUpdateViewChanged(CCmdUI* pCmdUI);
	afx_msg void OnViewHideunknown();
	afx_msg void OnUpdateViewHideunknown(CCmdUI* pCmdUI);
	afx_msg void OnTimer(UINT nIDEvent);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
private:
	BOOL m_bRestoreFocus;
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_MAINFRM_H__D2D77DCC_8299_11D1_8949_444553540000__INCLUDED_)
