/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@hotmail.com> --- April 1998
 */

/*
 * BrowseFileView.h -- Implements the view with all the files
 * 
 * FILTER-VIEW-DEV branch, last merged up to 1.22
 */

#if !defined(AFX_BROWSEFILEVIEW_H__98CCBD22_845B_11D1_8949_444553540000__INCLUDED_)
#define AFX_BROWSEFILEVIEW_H__98CCBD22_845B_11D1_8949_444553540000__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "CvsEntries.h"
#include "CPStr.h"
#include "SortHeaderCtrl.h"

class MultiFiles;
class KoWatcher; // implementation helper
class KiSelectionHandler;
class KiColumnModel;

enum
{
	kFileIconText = 0,
	kFileIconBinary,
	kFileIconUnknown,
	kFileIconAdded,
	kFileIconConflict,
	kFileIconMiss,
	kFolderIcon,
	kFolderIconUnknown,
	kFolderIconMiss,
	kFileIconTextMod,
	kFileIconBinaryMod,
	kFileIconIgnored,
	kFolderIconIgnored,
	kFileIconRemoved,
	kFileIconBinaryAdded
};

class CBrowseFileView : public CListView
{
protected: // create from serialization only
	CBrowseFileView();
	DECLARE_DYNCREATE(CBrowseFileView)

	bool DisableCommon(bool bCheckSelection = true);
		// for CCmdUI

// Operations
public:

    void OnFilteringChanged();
        // called to notify the view that app's filtering has changed

	void ResetView(const char *path, bool notifyBrowser = false, const char *selectFile = 0L);
		// reset to this path and notify optionally the directories tree
		// optionally place the selection on specified file

	void ResetView(bool notifyBrowser = false, const char *selectFile = 0L);
		// - reload and try to guess if something changed
		// according to the mod. time of CVS
		// - notify optionally the directories tree
		// - this should *not* be called from another thread. Use
		// the next one if you call from a thread.
		// optionally place the selection on specified file

	inline void CheckChanges(void) { m_checkChanges = true; }
		// this will call ResetView(forceReload = false)
		// the next time the timer is called. To be used for foreign
		// threads in order to reload the view after cvs ends.

	void Resort(void);
		// resort according to the current key

	void InvalidateView(void);
		// will cause to rebuild the view after cvs returned

	static int GetImageForEntry(EntnodeData *data);
		// return the ID of the image which symbolizes the
		// state of the file/directory

	inline CFrameWnd *GetMainFrame() { return GetRoutingFrame(); }
		// used for changing the routing of CmdMsg

	void ProcessSelectionCommand(KiSelectionHandler* handler);
		// processes a handler for selection command 

	void SaveColumns();
		// saves column state

	bool LoadColumns();
		// loads column state

	// retrieves columnar model of the data
	KiColumnModel* GetColumnModel() const
	{
		return m_modelColumns;
	}

	void AddColumns();
		// adds columns to view

	void DeleteColumns();
		// deletes all columns

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CBrowseFileView)
	public:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	protected:
	virtual void OnInitialUpdate(); // called first time after construct
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnPrint(CDC* pDC, CPrintInfo* pInfo);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CBrowseFileView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:
	void GetEntriesModTime(time_t & newEntriesMod, time_t & newEntriesLogMod);
	void EditSel(EntnodeData *data, bool useDefault = false);
	void DoDrag();
	void SetRecursive(bool isRecursive);

	CSortHeaderCtrl m_ctrlHeader;
		// Sort header control

	CStr m_path;
		// current path
	time_t m_entriesMod;
	time_t m_entriesLogMod;
		// time stamp of CVS/*
	int m_sort;
		// sort key
	bool m_ascendant;
		// sort flag

	KiColumnModel* m_modelColumns;
	// columnar model in use
	
	bool m_checkChanges;
		// used by the timer and CheckChanges
	int m_numberOfLines;
	int m_numberByPages;
	int m_numberOfPages;
	int m_heightOfLines;
		// for printing

	bool m_isRecursive;
		// true if displaying recursively

	KoWatcher* m_watch;
	// a thread to monitor file change notifications

	bool m_isResetViewLocked;
	// flag to lock out recursion into ResetView()

	bool m_isFilesChange;
	// tells if file change notification is pending

	UINT m_uiFilechangeTimer;
	//stores the timer event for file's change notification, default to FILECHANGE_TIMER

	bool m_isResetViewPending;
	// tells if there is an outstanding request to refresh the view contents

// Generated message map functions
protected:
	//{{AFX_MSG(CBrowseFileView)
	afx_msg void OnViewSmallIcons();
	afx_msg void OnViewList();
	afx_msg void OnViewFullRowDetails();
	afx_msg void OnUpdateViewSmallIcons(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewAdd(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewAddB(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewUpdate(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewRelease(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewRmv(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewGraph(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewList(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewEditseldef(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewFullRowDetails(CCmdUI* pCmdUI);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnColumnclick(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnViewAdd();
	afx_msg void OnViewAddb();
	afx_msg void OnViewCommit();
	afx_msg void OnViewRmv();
	afx_msg void OnViewUpdate();
	afx_msg void OnViewQueryUpdate();
	afx_msg void OnUpdateViewReload(CCmdUI* pCmdUI);
	afx_msg void OnViewReload();
	afx_msg void OnKeydown(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnViewUpone();
	afx_msg void OnUpdateViewUpone(CCmdUI* pCmdUI);
	afx_msg void OnViewTrash();
	afx_msg void OnUpdateViewTrash(CCmdUI* pCmdUI);
	afx_msg void OnViewDiff();
	afx_msg void OnViewLog();
	afx_msg void OnViewGraph();
	afx_msg void OnViewStatus();
	afx_msg void OnViewLock();
	afx_msg void OnViewUnlock();
	afx_msg void OnViewWatchOn();
	afx_msg void OnViewWatchOff();
	afx_msg void OnViewEdit();
	afx_msg void OnViewUnedit();
	afx_msg void OnViewWatchers();
	afx_msg void OnViewEditors();
	afx_msg void OnViewRelease();
	afx_msg void OnViewTagNew();
	afx_msg void OnViewTagDelete();
	afx_msg void OnViewTagBranch();
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnUpdateMacroSel(CCmdUI* pCmdUI);
	afx_msg void OnViewExplore();
	afx_msg void OnUpdateViewExplore(CCmdUI* pCmdUI);
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnViewEditsel();
	afx_msg void OnViewEditseldef();
	afx_msg void OnViewCheckout();
	afx_msg void OnUpdateViewCheckout(CCmdUI* pCmdUI);
	afx_msg void OnViewImport();
	afx_msg void OnUpdateViewImport(CCmdUI* pCmdUI);
	afx_msg void OnBegindrag(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnBeginrdrag(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg BOOL OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message);
	afx_msg void OnDeleteitem(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnDestroy();
	afx_msg void OnUpdateQueryAnnotate(CCmdUI* pCmdUI);
	afx_msg void OnQueryAnnotate();
	//}}AFX_MSG
	afx_msg BOOL OnMacroSel(UINT nID);
	afx_msg void OnUpdateCustomize(CCmdUI* pCmdUI);
	afx_msg BOOL OnCustomize(UINT nID);
	afx_msg LRESULT OnFileChange(WPARAM, LPARAM);
	afx_msg LRESULT OnResetView(WPARAM, LPARAM);

	DECLARE_MESSAGE_MAP()

// list view image lists
protected:
	void SetFullRowSel(BOOL bFullRowSel);
	static CImageList m_SmallImageList;
	static CImageList m_StateImageList;

// view type helpers
public:
	BOOL SetViewType(DWORD dwViewType);
	DWORD GetViewType();
// member access
	const CStr& GetPath() const { return m_path; };
};

#endif // !defined(AFX_BROWSEFILEVIEW_H__98CCBD22_845B_11D1_8949_444553540000__INCLUDED_)
