/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Jerzy Kaczorowski <kaczoroj@hotmail.com> --- June 2004
 */

// MMenuString.cpp: implementation of the CMMenuString class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "wincvs.h"
#include "MMenuString.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

/*!
	Constructor
	\param maxstr Maximum string
	\param uniqueName Unique name
	\param defaultStr NULL terminated set of strings
*/
CMMenuString::CMMenuString(unsigned int maxstr, const char* uniqueName, char* const* defaultStr)
	: CPersistent(uniqueName, kNoClass), fMaxStr(maxstr)
{
	if( defaultStr != NULL )
	{
		int i = 0;
		while( defaultStr[i] != NULL )
		{
			Insert(defaultStr[i++]);
		}
	}
}

CMMenuString::~CMMenuString()
{
}

unsigned int CMMenuString::SizeOf(void) const
{
	NAMESPACE(std) vector<UStr>::const_iterator i;
	unsigned int thesize = sizeof(int);
	
	for(i = fAllStrs.begin(); i != fAllStrs.end(); ++i)
	{
		thesize += (*i).length() + 1;
	}

	return thesize;
}

const void *CMMenuString::GetData(void) const
{
	unsigned int thesize = SizeOf(), tmpsize;
	((CMMenuString *)this)->fBuf.AdjustSize(thesize);
	char *tmp = ((CMMenuString *)this)->fBuf;
	*(int *)tmp = fAllStrs.size();
	tmp += sizeof(int) / sizeof(char);
	
	NAMESPACE(std) vector<UStr>::const_iterator i;
	for(i = fAllStrs.begin(); i != fAllStrs.end(); ++i)
	{
		tmpsize = (*i).length() + 1;
		memcpy(tmp, (const char*)(*i), tmpsize * sizeof(char));
		tmp += tmpsize;
	}
	
	return (char*)fBuf;
}

void CMMenuString::SetData(const void *ptr, unsigned int size)
{
	const char* tmp = (char *)ptr;
	unsigned int thesize;
	fAllStrs.erase(fAllStrs.begin(), fAllStrs.end());
	thesize = *(int *)tmp;
	tmp += sizeof(int) / sizeof(char);
	for(unsigned int i = 0; i < thesize && i < fMaxStr; i++)
	{
		fAllStrs.push_back(UStr(tmp));
		tmp += strlen(tmp) + 1;
	}
}

void CMMenuString::Insert(const char* newstr)
{
	TouchTimeStamp();
	fAllStrs.push_back(UStr(newstr));
}
