/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@hotmail.com> --- November 1999
 */

/*
 * cvsgui.h --- glue code for communicating with cvs over pipes
 */

#ifndef CVSGUI_H
#define CVSGUI_H

#include <stdlib.h>

#ifdef HAVE_UNISTD_H
#	include <unistd.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*
 * glue code to intercept some low level calls and tunnel them
 * inside the communication pipes.
 */
#define getenv cvsguiglue_getenv
#define getpass cvsguiglue_getpass

// RCH - extra #define for Solaris
#define getpassphrase cvsguiglue_getpass

#define main cvsguiglue_main
#define exit cvsguiglue_exit

extern char * cvsguiglue_getenv(const char *env);
extern char * cvsguiglue_getpass(const char *prompt);
extern int cvsguiglue_main(int argc, char *argv[]);
extern void cvsguiglue_exit(int code);
extern void cvsguiglue_flushconsole(int closeit);

#ifdef __cplusplus
}
#endif

#endif /* CVSGUI_H */
