/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@hotmail.com> --- March 1998
 */

/*
 * ImportDlg.cpp : the cvs import dialog
 */

#include "stdafx.h"

#ifdef WIN32
#	include "wincvs.h"
#endif /* WIN32 */

#if qUnix
#	include "UCvsDialogs.h"
#	include "CheckoutDlg.h"
#endif

#ifdef qMacCvsPP
#	include <UModalDialogs.h>
#	include <LMultiPanelView.h>
#	include <LPopupGroupBox.h>
#	include <LCheckBox.h>
#	include <LTextEditView.h>
#	include <LEditText.h>
#	include <LPushButton.h>

#	include "MacCvsApp.h"
#endif /* qMacCvsPP */

#include "ImportDlg.h"
#include "CvsPrefs.h"
#include "MultiString.h"
#include "PromptFiles.h"
#include "TextBinary.h"
#include "MakeSurePathExists.h"

static char *sDefReleases[] = 
{
	"V10",
	"V101",
	0L
};

static char *sDefVendors[] = 
{
	"GNU",
	0L
};

static char *sDefModuleNames[] = 
{
	"Module",
	"Project",
	0L
};

static CMString gVendorNames(10, "P_VendorNames", sDefVendors);
static CMString gReleasesNames(10, "P_ReleaseNames", sDefReleases);
static CMString gImportModuleNames(10, "P_ImportModuleNames", sDefModuleNames);

#ifdef WIN32
#	include "GetPrefs.h"
#	ifdef _DEBUG
#	define new DEBUG_NEW
#	undef THIS_FILE
	static char THIS_FILE[] = __FILE__;
#	endif

IMPLEMENT_DYNCREATE(CImport_MAIN, CPropertyPage)

CImport_MAIN::CImport_MAIN(const char *logmsg, const char *modname,
						   const char *rtag, const char *vtag) :
	CPropertyPage(CImport_MAIN::IDD)
{
	//{{AFX_DATA_INIT(CImport_MAIN)
	m_logmsg = logmsg;
	m_vtag = vtag;
	m_rtag = rtag;
	m_modname = modname;
	//}}AFX_DATA_INIT
}

CImport_MAIN::CImport_MAIN() : CPropertyPage(CImport_MAIN::IDD)
{
}

CImport_MAIN::~CImport_MAIN()
{
}

void CImport_MAIN::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);

	//{{AFX_DATA_MAP(CImport_MAIN)
	DDX_Control(pDX, IDC_COMBOMODNAME, m_modnameCombo);
	DDX_Control(pDX, IDC_COMBORTAG, m_rtagCombo);
	DDX_Control(pDX, IDC_COMBOVTAG, m_vtagCombo);
	DDX_Text(pDX, IDC_LOGMSG, m_logmsg);
	DDX_CBString(pDX, IDC_COMBOVTAG, m_vtag);
	DDX_CBString(pDX, IDC_COMBORTAG, m_rtag);
	DDX_CBString(pDX, IDC_COMBOMODNAME, m_modname);
	//}}AFX_DATA_MAP
	DDV_MinChars(pDX, m_modname, 1);
	DDV_MinChars(pDX, m_rtag, 1);
	DDV_MinChars(pDX, m_vtag, 1);
	DDX_ComboMString(pDX, IDC_COMBOMODNAME, gImportModuleNames, m_modnameCombo);
	DDX_ComboMString(pDX, IDC_COMBOVTAG, gVendorNames, m_vtagCombo);
	DDX_ComboMString(pDX, IDC_COMBORTAG, gReleasesNames, m_rtagCombo);
}


BEGIN_MESSAGE_MAP(CImport_MAIN, CPropertyPage)
	//{{AFX_MSG_MAP(CImport_MAIN)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

IMPLEMENT_DYNCREATE(CImport_OPTIONS, CPropertyPage)

CImport_OPTIONS::CImport_OPTIONS(const char *path, const bool useDefIgnore) :
	CPropertyPage(CImport_OPTIONS::IDD)
{
	//{{AFX_DATA_INIT(CImport_OPTIONS)
	m_path = path;
	m_chkUseDefIgnore = useDefIgnore;
	//}}AFX_DATA_INIT
}

CImport_OPTIONS::CImport_OPTIONS() : CPropertyPage(CImport_OPTIONS::IDD)
{
}

CImport_OPTIONS::~CImport_OPTIONS()
{
}

void CImport_OPTIONS::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);

	//{{AFX_DATA_MAP(CImport_OPTIONS)
	DDX_Text(pDX, IDC_PATH, m_path);
	DDX_Check(pDX, IDC_USEDEFIGNORE, m_chkUseDefIgnore);
	//}}AFX_DATA_MAP
	
	if( pDX->m_bSaveAndValidate )
	{
		//check the import directory
		if( !CompatMakeSurePathExists(m_path, false) )
		{
			AfxMessageBox("Cannot find folder " + m_path);
			pDX->PrepareEditCtrl(IDC_PATH);
			pDX->Fail();
		}
	}
}


BEGIN_MESSAGE_MAP(CImport_OPTIONS, CPropertyPage)
	//{{AFX_MSG_MAP(CImport_OPTIONS)
	ON_BN_CLICKED(IDC_BTNPATH2, OnBtnpath)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CImport_OPTIONS message handlers

void CImport_OPTIONS::OnBtnpath() 
{
	const char *dir = BrowserGetDirectory("Select a directory to import :", IsWindow(this->m_hWnd) ? this : NULL);
	if(dir != NULL)
		SetDlgItemText(IDC_PATH, dir);
}
#endif /* WIN32 */

#ifdef qMacCvsPP
static void DoDataExchange_ImportMain(LWindow *theDialog, CPStr & modname, CStr & logmsg, bool putValue)
{
	LEditText *mname = dynamic_cast<LEditText*>
		(theDialog->FindPaneByID(item_ModuleName));
	LTextEditView *editLog = dynamic_cast<LTextEditView*>
		(theDialog->FindPaneByID(item_LogMsg));
	
	if(putValue)
	{
		mname->SetText((Ptr)(const char *)modname, modname.length());	
		editLog->SetTextPtr((Ptr)(const char *)logmsg, logmsg.length());	
		theDialog->SetLatentSub(mname);
		
		// this will take care about an empty module name
		mname->AddListener(CMacCvsApp::app);
		if(modname.length() == 0)
		{
			LPushButton *theOK = dynamic_cast<LPushButton*>
										(theDialog->FindPaneByID(item_OK));
			Assert_(theOK != 0L);
			theOK->Disable();
		}
	}
	else
	{
		Handle hdl = editLog->GetTextHandle();
		Assert_(hdl != 0L);
		logmsg.set(*hdl, GetHandleSize(hdl));
		
		char buf[512];
		Size len;
		mname->GetText(buf, 511, &len);
		modname.set(buf, len);
		
	}
}

static void DoDataExchange_ImportTags(LWindow *theDialog, CPStr & vendortag, CPStr & reltag, bool putValue)
{
	LEditText *vtag = dynamic_cast<LEditText*>
		(theDialog->FindPaneByID(item_Vendortag));
	LEditText *rtag = dynamic_cast<LEditText*>
		(theDialog->FindPaneByID(item_Reltag));
	
	if(putValue)
	{
		vtag->SetText((Ptr)(const char *)vendortag, vendortag.length());	
		rtag->SetText((Ptr)(const char *)reltag, reltag.length());	
		theDialog->SetLatentSub(vtag);
	}
	else
	{
		char buf[512];
		Size len;
		vtag->GetText(buf, 511, &len);
		vendortag.set(buf, len);
		rtag->GetText(buf, 511, &len);
		reltag.set(buf, len);
		
	}
}
#endif /* qMacCvsPP */
#if qUnix
class UCvsImport : public UWidget
{
	UDECLARE_DYNAMIC(UCvsImport)
public:
	UCvsImport() : UWidget(::UEventGetWidID()) {}
	virtual ~UCvsImport() {}

	enum
	{
		kOK = EV_COMMAND_START,	// 0
		kCancel,				// 1
		kTabGeneral				// 2
	};

	virtual void DoDataExchange(bool fill);

protected:
	ev_msg int OnOK(void);
	ev_msg int OnCancel(void);

	UDECLARE_MESSAGE_MAP()
};

UIMPLEMENT_DYNAMIC(UCvsImport, UWidget)

UBEGIN_MESSAGE_MAP(UCvsImport, UWidget)
	ON_UCOMMAND(UCvsImport::kOK, UCvsImport::OnOK)
	ON_UCOMMAND(UCvsImport::kCancel, UCvsImport::OnCancel)
UEND_MESSAGE_MAP()

int UCvsImport::OnOK(void)
{
	EndModal(true);
	return 0;
}

int UCvsImport::OnCancel(void)
{
	EndModal(false);
	return 0;
}

void UCvsImport::DoDataExchange(bool fill)
{
	if(fill)
	{
	}
	else
	{
	}
}

class UCvsImport_MAIN : public UWidget
{
	UDECLARE_DYNAMIC(UCvsImport_MAIN)
public:
	UCvsImport_MAIN(const char *logmsg, const char *modname,
					const char *rtag, const char *vtag);
	virtual ~UCvsImport_MAIN() {}

	enum
	{
		kEditModule = EV_COMMAND_START,	// 0
		kEditLog,						// 1
		kEditVendor,					// 2
		kEditRelease					// 3
	};

	virtual void DoDataExchange(bool fill);

	UStr m_logmsg;
	UStr m_modname;
	UStr m_rtag;
	UStr m_vtag;
protected:

	UDECLARE_MESSAGE_MAP()
};

UIMPLEMENT_DYNAMIC(UCvsImport_MAIN, UWidget)

UBEGIN_MESSAGE_MAP(UCvsImport_MAIN, UWidget)
UEND_MESSAGE_MAP()

UCvsImport_MAIN::UCvsImport_MAIN(const char *logmsg, const char *modname,
								 const char *rtag, const char *vtag) : UWidget(::UEventGetWidID())
{
	m_logmsg = logmsg;
	m_modname = modname;
	m_rtag = rtag;
	m_vtag = vtag;
}

void UCvsImport_MAIN::DoDataExchange(bool fill)
{
	::DoDataExchange(fill, GetWidID(), kEditModule, gOldModules);
	::DoDataExchange(fill, GetWidID(), kEditRelease, gReleasesNames);
	::DoDataExchange(fill, GetWidID(), kEditVendor, gVendorNames);

	if(fill)
	{
		UEventSendMessage(GetWidID(), EV_SETTEXT, kEditLog, (void *)(const char *)m_logmsg);
		UEventSendMessage(GetWidID(), EV_SETTEXT, kEditModule, (void *)(const char *)m_modname);
		UEventSendMessage(GetWidID(), EV_SETTEXT, kEditRelease, (void *)(const char *)m_rtag);
		UEventSendMessage(GetWidID(), EV_SETTEXT, kEditVendor, (void *)(const char *)m_vtag);
	}
	else
	{
		UEventSendMessage(GetWidID(), EV_GETTEXT, kEditLog, &m_logmsg);
		UEventSendMessage(GetWidID(), EV_GETTEXT, kEditModule, &m_modname);
		UEventSendMessage(GetWidID(), EV_GETTEXT, kEditRelease, &m_rtag);
		UEventSendMessage(GetWidID(), EV_GETTEXT, kEditVendor, &m_vtag);
	}
}

class UCvsImport_OPTIONS : public UWidget
{
	UDECLARE_DYNAMIC(UCvsImport_OPTIONS)
public:
	UCvsImport_OPTIONS(const char *path);
	virtual ~UCvsImport_OPTIONS() {}

	enum
	{
		kStatPath = EV_COMMAND_START,	// 0
		kBtnChange						// 1
	};

	virtual void DoDataExchange(bool fill);

	UStr m_path;
protected:

	ev_msg int OnChange(void);

	UDECLARE_MESSAGE_MAP()
};

UIMPLEMENT_DYNAMIC(UCvsImport_OPTIONS, UWidget)

UBEGIN_MESSAGE_MAP(UCvsImport_OPTIONS, UWidget)
	ON_UCOMMAND(UCvsImport_OPTIONS::kBtnChange, UCvsImport_OPTIONS::OnChange)
UEND_MESSAGE_MAP()

UCvsImport_OPTIONS::UCvsImport_OPTIONS(const char *path) : UWidget(::UEventGetWidID())
{
	m_path = path;
}

int UCvsImport_OPTIONS::OnChange()
{
	const char *dir = BrowserGetDirectory("Select a directory to import :");
	if(dir != 0L)
		UEventSendMessage(GetWidID(), EV_SETTEXT, kStatPath, (void *)dir);
	return 0;
}

void UCvsImport_OPTIONS::DoDataExchange(bool fill)
{
	if(fill)
	{
		UEventSendMessage(GetWidID(), EV_SETTEXT, kStatPath, (void *)(const char *)m_path);
	}
	else
	{
		UEventSendMessage(GetWidID(), EV_GETTEXT, kStatPath, &m_path);
	}
}
#endif // qUnix

bool CompatGetImport(CPStr & modname, CStr & logmsg, CPStr & vendortag,
					CPStr & reltag, CPStr & path,
					bool& useDefIgnore)
{
	bool userHitOK = false;
	modname = "";
	logmsg = "";
	vendortag = "";
	reltag = "";
	useDefIgnore = false;

	static CPStr sLastModName;	/*Obsolete - remove it and always use sFolder! Get rid after all platforms have combo boxes for recent modules!*/
	
	static CPStr sFolder;
	static CStr sLastMsg;
	static CPStr sLastVTag("avendor");
	static CPStr sLastRTag("arelease");
	
	//dig out the folder so we can suggest the module name
	CStr uppath, folder;
	if( SplitPath(path, uppath, folder) )
		sFolder = folder;
	
	if( sLastModName.length() == 0L )	/*Obsolete - see above*/
	{
		sLastModName = folder;
	}
#ifdef WIN32
	CPropertySheet pages("Import settings");
	pages.m_psh.dwFlags |= PSH_NOAPPLYNOW;
	CImport_MAIN page1(sLastMsg, sFolder, sLastRTag, sLastVTag);
	CImport_OPTIONS page2(path, useDefIgnore);
	CGetPrefs_CVSROOT page3;
	CGetPrefs_GLOBALS page4;
	pages.AddPage(&page1);
	pages.AddPage(&page2);
	pages.AddPage(&page3);
	pages.AddPage(&page4);
	if(pages.DoModal() == IDOK)
	{
		sLastModName = (const char *)page1.m_modname;
		sLastMsg = (const char *)page1.m_logmsg;
		sLastVTag = (const char *)page1.m_vtag;
		sLastRTag = (const char *)page1.m_rtag;
		path = (const char *)page2.m_path;
		useDefIgnore = page2.m_chkUseDefIgnore == TRUE;

		page3.StoreValues();
		page4.StoreValues();
		userHitOK = true;
	}
#endif /* WIN32 */
#ifdef qMacCvsPP
	StDialogHandler	theHandler(dlg_Import, CMacCvsApp::app);
	LWindow *theDialog = theHandler.GetDialog();
	ThrowIfNil_(theDialog);
	static UInt16 sRuntimePanel = 1;
	
	LMultiPanelView *multiView = dynamic_cast<LMultiPanelView*>
		(theDialog->FindPaneByID(item_MultiViewPrefs));
	LPane *groupView = theDialog->FindPaneByID(item_GroupViewPrefs);
	
	multiView->SwitchToPanel(3);
	DoDataExchange_Globals(theDialog, true);
	multiView->SwitchToPanel(2);
	DoDataExchange (theDialog, item_ImportCvsIgnore, useDefIgnore, true);
	DoDataExchange (theDialog, item_EditPath, path, true);
	dynamic_cast<LControl*> (theDialog->FindPaneByID (item_EditPath))->AddListener (&theHandler);
	
	multiView->SwitchToPanel(1);
	DoDataExchange_ImportMain(theDialog, sLastModName, sLastMsg, true);
	DoDataExchange_ImportTags(theDialog, sLastVTag, sLastRTag, true);
	
	
	groupView->SetValue(sRuntimePanel);
	theDialog->Show();
	MessageT hitMessage;
	while (true)
	{		// Let DialogHandler process events
		hitMessage = theHandler.DoDialog();
		
		if (hitMessage == msg_OK || hitMessage == msg_Cancel)
			break;

		if(hitMessage == item_EditPath)
		{
			const char * dir = BrowserGetDirectory("Choose folder to import :");
			if(dir != 0L)
			{
				CPStr tmp(dir);
				theDialog->SetDescriptorForPaneID(item_EditPath, tmp);
			}
		}
	}
	theDialog->Hide();
	sRuntimePanel = groupView->GetValue();
	
	if(hitMessage == msg_OK)
	{
		multiView->SwitchToPanel(1);
		DoDataExchange_ImportMain(theDialog, sLastModName, sLastMsg, false);
		DoDataExchange_ImportTags(theDialog, sLastVTag, sLastRTag, false);
		multiView->SwitchToPanel(2);
		DoDataExchange (theDialog, item_ImportCvsIgnore, useDefIgnore, false);
		DoDataExchange (theDialog, item_EditPath, path, false);
		multiView->SwitchToPanel(3);
		DoDataExchange_Globals(theDialog, false);
		
		Assert_(sLastModName.length() != 0);
		
		userHitOK = true;
	}
#endif /* qMacCvsPP */
#if qUnix
	void *wid = UCreate_ImportDlg();

	UCvsImport *dlg = new UCvsImport();
	UCvsImport_MAIN *tab1 = new UCvsImport_MAIN(sLastMsg, sLastModName, sLastRTag, sLastVTag);
	UCvsImport_OPTIONS *tab2 = new UCvsImport_OPTIONS(path);
	UEventSendMessage(dlg->GetWidID(), EV_INIT_WIDGET, kUMainWidget, wid);	
	dlg->AddPage(tab1, UCvsImport::kTabGeneral, 0);
	dlg->AddPage(tab2, UCvsImport::kTabGeneral, 1);

	if(dlg->DoModal())
	{
		sLastModName = tab1->m_modname;
		sLastMsg = tab1->m_logmsg;
		sLastVTag = tab1->m_vtag;
		sLastRTag = tab1->m_rtag;
		path = tab2->m_path;

		userHitOK = true;
	}

	delete dlg;
#endif // qUnix

	if(userHitOK)
	{
		gCvsPrefs.save();
		if(sLastMsg.length() == 0)
			sLastMsg = "no message";
		if(sLastVTag.length() == 0)
			sLastVTag = "initial";
		if(sLastRTag.length() == 0)
			sLastRTag = "start";

		modname = sLastModName;
		logmsg = sLastMsg;
		vendortag = sLastVTag;
		reltag = sLastRTag;
#ifdef macintosh
		logmsg.replace('\015', '\012');
#endif /* macintosh */
	}
	return userHitOK;
}
