/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@hotmail.com> --- March 1998
 */

/*
 * CheckoutDlg.cpp : the cvs checkout dialog
 */

#if !defined(AFX_CHECKOUTDLG_H__98CCBD22_845B_11D1_8949_444553540000__INCLUDED_)
#define AFX_CHECKOUTDLG_H__98CCBD22_845B_11D1_8949_444553540000__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "CPStr.h"
#include "SmartComboBox.h"
#include "KeywordComboBox.h"

class MultiFiles;

bool CompatGetCheckout(const MultiFiles* mf,
					   CStr& modname, CStr& path, bool& norecurs,
					   bool& toStdout, CStr& date, CStr& rev,
					   bool& useMostRecent, 
					   CStr& rev1, CStr& rev2,
					   bool& doexport, 
					   bool& forceCvsroot, CStr& cvsroot, 
					   bool& overrideCheckoutDir, CStr& checkoutDir,
					   CStr& keyword,
					   bool& resetSticky,
					   bool& dontShortenPaths);

extern CMString gOldModules;

#ifdef WIN32

class CCheckout_MAIN : public CPropertyPage
{
	DECLARE_DYNAMIC(CCheckout_MAIN)

// Construction
public:
	CCheckout_MAIN(const MultiFiles* mf, 
		const char* modname, const char* path, const bool dontShortenPaths,
		bool forceRoot, const char* cvsroot);
	~CCheckout_MAIN();

// Dialog Data
	//{{AFX_DATA(CCheckout_MAIN)
	enum { IDD = IDD_CHECKOUT_MAIN };
	CButton	m_selCvsrootButton;
	CButton	m_forceRootCheck;
	CSmartComboBox	m_cvsrootCombo;
	CButton	m_dontShortenPathsCheck;
	CEdit	m_checkoutDirEdit;
	CButton	m_overrideCoDirCheck;
	CEdit	m_pathEdit;
	CSmartComboBox	m_moduleCombo;
	CString	m_moduleName;
	CString	m_path;
	BOOL	m_noRecurse;
	BOOL	m_overrideCoDir;
	CString	m_checkoutDir;
	BOOL	m_dontShortenPaths;
	CString	m_cvsroot;
	BOOL	m_forceRoot;
	BOOL	m_export;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CCheckout_MAIN)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(CCheckout_MAIN)
	afx_msg void OnBtnPath();
	afx_msg void OnCheckOverridecheckoutdir();
	afx_msg void OnBrowseModules();
	virtual BOOL OnInitDialog();
	afx_msg void OnForceroot();
	afx_msg void OnSelcvsroot();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
private:
	const MultiFiles* m_mf;
};

class CCheckout_OPTIONS : public CPropertyPage
{
	DECLARE_DYNAMIC(CCheckout_OPTIONS)

// Construction
public:
	CCheckout_OPTIONS(const MultiFiles* mf, 
		const char* rev, const char* date, const char* keyword, const bool resetSticky);
	~CCheckout_OPTIONS();

// Dialog Data
	//{{AFX_DATA(CCheckout_OPTIONS)
	enum { IDD = IDD_CHECKOUT_OPTIONS };
	CButton	m_matchCheck;
	CButton	m_resetStickyCheck;
	CButton	m_browseTagButton;
	CButton	m_hasRevCheck;
	CButton	m_hasDateCheck;
	CKeywordComboBox	m_keywordCombo;
	CStatic	m_keywordDescStatic;
	CSmartComboBox	m_revCombo;
	CSmartComboBox	m_dateCombo;
	CString	m_date;
	CString	m_rev;
	BOOL	m_hasDate;
	BOOL	m_match;
	BOOL	m_hasRev;
	CString	m_keyword;
	BOOL	m_resetSticky;
	BOOL	m_stdout;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CCheckout_OPTIONS)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(CCheckout_OPTIONS)
	afx_msg void OnDate();
	afx_msg void OnRev();
	afx_msg void OnBrowseTag();
	virtual BOOL OnInitDialog();
	afx_msg void OnDelsticky();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
private:
	const MultiFiles* m_mf;
};

//{{AFX_INSERT_LOCATION}}
#endif /* WIN32 */

#endif // !defined(AFX_CHECKOUTDLG_H__98CCBD22_845B_11D1_8949_444553540000__INCLUDED_)
