/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Jerzy Kaczorowski <kaczoroj@hotmail.com> --- June 2001
 */

/*
 * AnnotateDlg.cpp : the cvs annotate dialog
 */

#include "stdafx.h"

#ifdef WIN32
#	include "wincvs.h"
#	include "OptionalPropertySheet.h"
#endif /* WIN32 */

#if qUnix
#	include "UCvsDialogs.h"
#endif

#ifdef qMacCvsPP
#	include <UModalDialogs.h>
#	include <LRadioButton.h>
#	include <LEditText.h>
#	include <LCheckBox.h>
#	include <LMultiPanelView.h>
#	include <LPopupGroupBox.h>
#	include "LPopupFiller.h"

#	include "MacCvsApp.h"
#endif /* qMacCvsPP */

#include "AnnotateDlg.h"
#include "CvsPrefs.h"
#include "MultiString.h"
#include "MultiFiles.h"
#include "ItemListDlg.h"

#ifdef WIN32
#include "GetPrefs.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAnnotate_MAIN property page

IMPLEMENT_DYNAMIC(CAnnotate_MAIN, CPropertyPage)

CAnnotate_MAIN::CAnnotate_MAIN(const MultiFiles* mf, kAnnotateCmdType annotateType, 
							   const char* rev, bool isDate) 
							   : m_mf(mf), m_annotateType(annotateType), CPropertyPage(CAnnotate_MAIN::IDD)
{
	m_hasRev = FALSE;
	m_isDate = isDate;
	m_rev = rev;
	m_force = FALSE;
	m_noRecurse = FALSE;

	if( kAnnotateGraph != m_annotateType )
	{
		m_revCombo.SetItems(m_isDate ? &gDateNames : &gRevNames);
	}
	else
	{
		m_revCombo.SetFeature(USmartCombo::AutoDropWidth | USmartCombo::ReadOnly);
		
		if( m_mf && m_mf->TotalNumFiles() )
		{
			MultiFiles::const_iterator mfi = m_mf->begin();
			if( mfi != m_mf->end() && mfi->NumFiles() )
			{
				UStr path;
				UStr fileName;
				UStr currRev;
				
				mfi->get(0, path, fileName, currRev);
				m_rev = currRev.c_str();
			}
		}
	}
}

CAnnotate_MAIN::~CAnnotate_MAIN()
{
}

void CAnnotate_MAIN::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAnnotate_MAIN)
	DDX_Control(pDX, IDC_FORCE, m_forceCheck);
	DDX_Control(pDX, IDC_NORECURS, m_noRecurseCheck);
	DDX_Control(pDX, IDC_SPECIFY_REV, m_hasRevCheck);
	DDX_Control(pDX, IDC_BROWSE_TAG, m_browseTagButton);
	DDX_Control(pDX, IDC_ISDATE, m_isDateCheck);
	DDX_Control(pDX, IDC_COMBO_REV, m_revCombo);
	DDX_Check(pDX, IDC_SPECIFY_REV, m_hasRev);
	DDX_Check(pDX, IDC_ISDATE, m_isDate);
	DDX_Check(pDX, IDC_FORCE, m_force);
	DDX_Check(pDX, IDC_NORECURS, m_noRecurse);
	DDX_CBString(pDX, IDC_COMBO_REV, m_rev);
	//}}AFX_DATA_MAP

	if( kAnnotateGraph != m_annotateType )
	{
		if( m_hasRev )
		{
			DDV_MinChars(pDX, m_rev, 1);
		}
		
		DDX_ComboMString(pDX, IDC_COMBO_REV, m_revCombo);
		
		if( !pDX->m_bSaveAndValidate )
		{
			OnSpecifyRev();
		}
	}
}


BEGIN_MESSAGE_MAP(CAnnotate_MAIN, CPropertyPage)
	//{{AFX_MSG_MAP(CAnnotate_MAIN)
	ON_BN_CLICKED(IDC_SPECIFY_REV, OnSpecifyRev)
	ON_BN_CLICKED(IDC_ISDATE, OnIsdate)
	ON_BN_CLICKED(IDC_BROWSE_TAG, OnBrowseTag)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAnnotate_MAIN message handlers

/// OnInitDialog virtual override, initialize the controls
BOOL CAnnotate_MAIN::OnInitDialog() 
{
	CPropertyPage::OnInitDialog();
	
	// Extra initialization

	// Special setup for the diff invoked using the graph view
	if( kAnnotateGraph == m_annotateType )
	{
		m_hasRevCheck.EnableWindow(FALSE);
		m_hasRevCheck.SetCheck(1);

		m_browseTagButton.EnableWindow(FALSE);
		
		m_isDateCheck.EnableWindow(FALSE);
		
		m_revCombo.SetReadOnly(TRUE);
		m_revCombo.ResetContent();
		
		if( !m_rev.IsEmpty() )
		{
			m_revCombo.AddString(m_rev);
			m_revCombo.SetWindowText(m_rev);
		}

		m_noRecurseCheck.EnableWindow(FALSE);
		m_forceCheck.EnableWindow(FALSE);
	}
	
	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

/// BN_CLICKED message handler, enable controls
void CAnnotate_MAIN::OnSpecifyRev() 
{
	const BOOL bEnable = m_hasRevCheck.GetCheck();
	
	m_isDateCheck.EnableWindow(bEnable);
	m_revCombo.EnableWindow(bEnable);
	m_forceCheck.EnableWindow(bEnable);
	m_browseTagButton.EnableWindow(bEnable && !m_isDateCheck.GetCheck());
}

/// BN_CLICKED message handler, enable controls
void CAnnotate_MAIN::OnIsdate() 
{
	const BOOL isDate = m_isDateCheck.GetCheck();

	m_revCombo.SetItems(isDate ? &gDateNames : &gRevNames);
	DDX_ComboMString(NULL, IDC_COMBO_REV, m_revCombo);

	m_browseTagButton.EnableWindow(!isDate);
}

/// BN_CLICKED message handler, display browse tag/branch dialog
void CAnnotate_MAIN::OnBrowseTag() 
{
	CStr tagName;
	if( CompatGetTagListItem(m_mf, tagName) )
	{
		m_rev = (const char*)tagName;
		m_revCombo.SetWindowText(m_rev);
	}
}

#endif /* WIN32 */

/// Get the annotate options
bool CompatGetAnnotate(const MultiFiles* mf, kAnnotateCmdType annotateType, 
					   bool& noRecurs, bool& isDate, CPStr& rev, bool& force)
{
	bool userHitOK = false;

	static CPStr sLastRev;
	static bool bIsDate = false;
	
	bool hasRev = false;
	CPStr initialRev;
	
	// Graph view diff supplies initial revisions, so don't override them
	if( annotateType == kAnnotateGraph )
	{
		initialRev = rev;
		hasRev = !rev.empty();
	}
	else
	{
		rev = "";
		hasRev = false;
		initialRev = sLastRev;
	}

	noRecurs = false;
	force = false;
	isDate = bIsDate;
	
#ifdef WIN32
	COptionalPropertySheet pages(gCvsPrefs.HideCommandDlgAnnotate(), "Annotate settings");
	pages.m_psh.dwFlags |= PSH_NOAPPLYNOW;
	
	CAnnotate_MAIN page1(mf, annotateType, initialRev, isDate);
	CGetPrefs_GLOBALS page2;
	
	pages.AddPage(&page1);
	pages.AddPage(&page2);
	
	if( pages.DoModal() == IDOK )
	{
		noRecurs = page1.m_noRecurse == TRUE;

		sLastRev = page1.m_rev;
		isDate = page1.m_isDate == TRUE;
		hasRev = page1.m_hasRev == TRUE;
		force = page1.m_force == TRUE;

		page2.StoreValues();
		gCvsPrefs.SetHideCommandDlgAnnotate(pages.GetHideCommandDlg());
		userHitOK = true;
	}
#endif /* WIN32 */

#ifdef qMacCvsPP
  userHitOK = true;
#endif /* qMacCvsPP */

#if qUnix
#endif // qUnix
	
	if( userHitOK )
	{
		if( hasRev )
			rev = sLastRev;

		bIsDate = isDate;
		
		gCvsPrefs.save();
	}
	
	return userHitOK;
}
