/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Jerzy Kaczorowski <kaczoroj@hotmail.com> --- March 2004
 */

#if !defined(AFX_CVSROOTDLG_H__E7B87F15_691C_407E_AFAE_910BE8E98A0A__INCLUDED_)
#define AFX_CVSROOTDLG_H__E7B87F15_691C_407E_AFAE_910BE8E98A0A__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// CvsRootDlg.h : header file
//

#include "AppGlue.h"
#include "SmartComboBox.h"

#include <string>
#include <sstream>
#include <set>
#include <list>
#include <map>
#include <algorithm>

using namespace std;

bool CompatGetCvsRoot(CStr& cvsRoot);

/// Enum types of info commands
typedef enum
{
	kInfoCmd,		/*!< Info command */
	kProtocolCmd	/*!< Protocol info command */
} kInfoCmdType;

/// CVS protocol list container
typedef std::map<string, string> CvsProtocolList;

/// Structure to hold protocol row information
typedef struct
{
	string m_keyword;		/*!< Keyword */
	string m_description;	/*!< Description */
} KeywordInfo;

/// Keyword list
typedef std::vector<KeywordInfo> KeywordList;

/// Base class for cvsRoot list console
class CCvsRootConsole : public CCvsConsole
{
public:
	// Construction
	CCvsRootConsole();
	virtual ~CCvsRootConsole();

	// Interface
	virtual long cvs_out(char* txt, long len);
	virtual long cvs_err(char* txt, long len);
	virtual void Parse(int launchRes) = 0L;

protected:
	// Data members
	stringstream m_cvsOut;		/*!< Cvs command result (stdout) used for parsing */
	stringstream m_cvsErr;		/*!< Cvs command result (stderr) used for parsing */
	int m_launchRes;			/*!< The result of the command launch */

public:
	int GetLaunchRes() const;
	stringstream& GetCvsErr();
};

///	Class to parse protocols available (obtained using <b>cvs info</b>)
class CInfoParserConsole : public CCvsRootConsole
{
public:
	// Construction
	CInfoParserConsole();
	virtual ~CInfoParserConsole();

private:
	// Data members
	CvsProtocolList m_cvsProtocolList;	/*!< Parsed CVS protocol list */

public:
	// Interface
	virtual void Parse(int launchRes);

	const CvsProtocolList& GetCvsProtocolList() const;
};

/// Class to protocol info (obtained using <b>cvs info <i>protocol</i></b>)
class CProtocolParserConsole : public CCvsRootConsole
{
public:
	// Construction
	CProtocolParserConsole();
	virtual ~CProtocolParserConsole();

private:
	// Data members
	KeywordList m_keywordList;	/*!< Parsed protocol keywords list */

public:
	// Interface
	virtual void Parse(int launchRes);
	
	const KeywordList& GetKeywordList() const;
};


/// Display type enum
typedef enum
{
	kCvsRootDisplayWait,	/*!< Display the wait prompt while retrieving the data */
	kCvsRootDisplayData,	/*!< Display the data */
	kCvsRootDisplayInfo		/*!< Display the information */
} kCvsRootDisplayType;

/// Class to hold and support data display
class KeywordDisplayInfo
{
private:
	// Data members
	string m_name;			/*!< Display keyword's name */
	string m_value;			/*!< Keyword's value */

	KeywordInfo m_rowInfo;	/*!< Original row data after parsing */

public:
	// Interface
	void Create(const KeywordInfo& rowInfo);

	const string& GetName() const;
	
	const string& GetValue() const;
	void SetValue(const char* value);

	const KeywordInfo& GetRowInfo() const;
};

/// Display info list
typedef std::vector<const KeywordDisplayInfo*> KeywordDisplayInfoList;

#ifdef WIN32

/////////////////////////////////////////////////////////////////////////////
// CCvsRootDlg dialog

class CCvsRootDlg : public CDialog
{
// Construction
public:
	CCvsRootDlg(CWnd* pParent = NULL);   // standard constructor

// Dialog Data
	//{{AFX_DATA(CCvsRootDlg)
	enum { IDD = IDD_CVSROOT };
	CEdit	m_cvsrootStatic;
	CStatic	m_keywordDescStatic;
	CEdit	m_repositoryPathEdit;
	CButton	m_okButton;
	CButton	m_cancelButton;
	CStatic	m_protocolDescStatic;
	CButton	m_clearButton;
	CButton	m_editButton;
	CListCtrl	m_keywordList;
	CSmartComboBox	m_protocolCombo;
	CString	m_protocol;
	CString	m_repositoryPath;
	CString	m_cvsroot;
	//}}AFX_DATA


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CCvsRootDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:

	// Generated message map functions
	//{{AFX_MSG(CCvsRootDlg)
	virtual BOOL OnInitDialog();
	virtual void OnCancel();
	afx_msg void OnDblclkKeywordlist(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnItemchangedKeywordlist(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnDestroy();
	afx_msg void OnSelchangeProtocol();
	afx_msg void OnEdit();
	afx_msg void OnClear();
	afx_msg void OnChangePath();
	//}}AFX_MSG
	afx_msg void OnReadProtocols();
	DECLARE_MESSAGE_MAP()
private:
	// Data members
	bool m_cvsStopped;		/*!< Flag indicating that user stopped the command */
	
	// Methods
	void InitListCtrl(const kCvsRootDisplayType displayType);
	void EnableControls(BOOL enable);
	
	void EnableEditControls(const KeywordDisplayInfo* displayInfo);
	
	BOOL PostReadProtocolsMsg();
	
	void ReadAvailableProtocols();
	void ReadProtocolDetails();
	void ShowProtocolDescription();

	void FillProtocolsComboBox(CInfoParserConsole& infoParserConsole);
	void DisplayKeywords(CProtocolParserConsole& protocolParserConsole);

	void DeleteAllItems();

	void UpdateCvsRoot();
};

/////////////////////////////////////////////////////////////////////////////
// CEditKeywordDlg dialog

class CEditKeywordDlg : public CDialog
{
// Construction
public:
	CEditKeywordDlg(const char* description, const char* keyword, const char* value, 
		CWnd* pParent = NULL);   // standard constructor

// Dialog Data
	//{{AFX_DATA(CEditKeywordDlg)
	enum { IDD = IDD_EDITKEYWORD };
	CString	m_description;
	CString	m_keyword;
	CString	m_value;
	//}}AFX_DATA


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CEditKeywordDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:

	// Generated message map functions
	//{{AFX_MSG(CEditKeywordDlg)
		// NOTE: the ClassWizard will add member functions here
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.
#endif // WIN32

#endif // !defined(AFX_CVSROOTDLG_H__E7B87F15_691C_407E_AFAE_910BE8E98A0A__INCLUDED_)
