/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@hotmail.com> --- January 1997
 */

/*
 * CPStr.cpp --- simple Pascal-C string
 * Moved in ustr.cpp
 */

#include "stdafx.h"

#include "CPStr.h"

//////////////////////////////////////////////////////////////////////////
// PCPStr

PCPStr::~PCPStr()
{
}

/*!
	Get the size of string
	\return The size of string
*/
unsigned int PCPStr::SizeOf(void) const
{
	return m_str != 0L ? length() + 1 : 1;
}

/*!
	Get the string data
	\return The string data
*/
const void* PCPStr::GetData(void) const
{
	const void* res = (const char*)(*(CPStr*)this);
	
	return res == 0L ? "" : res;
}

/*!
	Set the string data
	\param ptr String data
	\param size String data size
*/
void PCPStr::SetData(const void* ptr, unsigned int size)
{
	if(strlen((const char*)ptr) == (size - 1))
		*(CPStr*)this = (const char*)ptr;
}

//////////////////////////////////////////////////////////////////////////
// PCStr

PCStr::~PCStr()
{
}

/*!
	Get the size of string
	\return The size of string
*/
unsigned int PCStr::SizeOf(void) const
{
	return m_str != 0L ? length() + 1 : 0;
}

/*!
	Get the string data
	\return The string data
*/
const void* PCStr::GetData(void) const
{
	const void* res = (const char*)(*(CStr*)this);
	return res == 0L ? "" : res;
}

/*!
	Set the string data
	\param ptr String data
	\param size String data size
*/
void PCStr::SetData(const void* ptr, unsigned int size)
{
	if( strlen((const char*)ptr) == (size - 1) )
		*(CStr*)this = (const char*)ptr;
}
