/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Jerzy Kaczorowski <kaczoroj@hotmail.com> --- October 2000
 */

/*
 * ReleaseDlg.cpp : the cvs release dialog
 */

#include "stdafx.h"

#ifdef WIN32
#	include "wincvs.h"
#endif /* WIN32 */

#include "ReleaseDlg.h"
#include "MultiFiles.h"
#include "GetPrefs.h"

#ifdef WIN32
#	ifdef _DEBUG
#	define new DEBUG_NEW
#	undef THIS_FILE
	static char THIS_FILE[] = __FILE__;
#	endif
#endif /* WIN32 */

#ifdef WIN32
/////////////////////////////////////////////////////////////////////////////
// CRelease_MAIN property page

IMPLEMENT_DYNAMIC(CRelease_MAIN, CPropertyPage)

CRelease_MAIN::CRelease_MAIN(const char* dir) 
	: CPropertyPage(CRelease_MAIN::IDD)
{
	//{{AFX_DATA_INIT(CRelease_MAIN)
	m_dir = dir;
	//}}AFX_DATA_INIT

	m_removeDirectoryOption = kReleaseNoDel;
}

CRelease_MAIN::~CRelease_MAIN()
{
}

void CRelease_MAIN::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CRelease_MAIN)
	DDX_Control(pDX, IDC_DELDIR, m_delDirCheck);
	DDX_Control(pDX, IDC_DELCVSINFO, m_delCvsInfoCheck);
	DDX_Control(pDX, IDC_DELALL, m_delAllCheck);
	DDX_Text(pDX, IDC_DIRECTORY, m_dir);
	//}}AFX_DATA_MAP

	if( pDX->m_bSaveAndValidate )
	{
		if( m_delCvsInfoCheck.GetCheck() )
		{
			m_removeDirectoryOption = kReleaseDelCvsInfo;
		}
		else if( m_delDirCheck.GetCheck() )
		{
			m_removeDirectoryOption = m_delAllCheck.GetCheck() ? kReleaseDelAll : kReleaseDelDir;
		}
	}
}


BEGIN_MESSAGE_MAP(CRelease_MAIN, CPropertyPage)
	//{{AFX_MSG_MAP(CRelease_MAIN)
	ON_BN_CLICKED(IDC_DELCVSINFO, OnDelcvsinfo)
	ON_BN_CLICKED(IDC_DELDIR, OnDeldir)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CRelease_MAIN message handlers

/*!
	Get the remove directory option
	\return The remove directory option
*/
kReleaseDelType CRelease_MAIN::GetRemoveDirectoryOption() const
{
	return m_removeDirectoryOption;
}
	 
/// BN_CLICKED message handler, uncheck other remove directory options if this one is selected
void CRelease_MAIN::OnDelcvsinfo() 
{
	if( m_delCvsInfoCheck.GetCheck() )
	{
		m_delAllCheck.EnableWindow(FALSE);

		m_delAllCheck.SetCheck(0);
		m_delDirCheck.SetCheck(0);
	}
}

/// BN_CLICKED message handler, uncheck other remove directory options if this one is selected and enable or disable deleting non-cvs files checkbox
void CRelease_MAIN::OnDeldir() 
{
	m_delAllCheck.EnableWindow(m_delDirCheck.GetCheck());
	m_delCvsInfoCheck.SetCheck(0);
	m_delAllCheck.SetCheck(0);
}
#endif /* WIN32 */

/// Get the release options
bool CompatGetRelease(const MultiFiles* mf, const char* dir, kReleaseDelType& removeDirectoryOption)
{
	bool userHitOK = false;

#ifdef WIN32
	CPropertySheet pages("Release settings");
	pages.m_psh.dwFlags |= PSH_NOAPPLYNOW;
	
	CRelease_MAIN page1(dir);
	CGetPrefs_GLOBALS page2;
	pages.AddPage(&page1);
	pages.AddPage(&page2);

	if( pages.DoModal() == IDOK )
	{
		removeDirectoryOption = page1.GetRemoveDirectoryOption();
		
		page2.StoreValues();
		userHitOK = true;
	}

#endif /* WIN32 */

#ifdef qMacCvsPP
	userHitOK = true;
#endif /* qMacCvsPP */

#if qUnix
	userHitOK = true;
#endif // qUnix

	return userHitOK;
}
