/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Jerzy Kaczorowski <kaczoroj@hotmail.com> --- November 2002
 */

// KeywordComboBox.cpp : implementation file
//

#include "stdafx.h"
#include "KeywordComboBox.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/// Structure to hold the keyword modes and their descriptions
struct keywordMode
{
  const char* mode;	/*!< Keyword substitution mode */
  const char* desc;	/*!< Keyword substitution description */
};

#define KEYWORD_MODE_COUNT 8

/// Global array to hold all substitution modes and descriptions
static struct keywordMode gKeywordModes[KEYWORD_MODE_COUNT] = {
	{"",		"Current"},
	{"-kkv",	"Default"},
	{"-kkvl",	"Default with locker's name"},
	{"-kk",		"Only keyword names"},
	{"-ko",		"Disable"},
	{"-kb",		"Binary"},
	{"-ku",		"Unicode"},
	{"-kv",		"Only keyword values"}
};

#ifdef WIN32

/////////////////////////////////////////////////////////////////////////////
// CKeywordComboBox

CKeywordComboBox::CKeywordComboBox() 
	: CSmartComboBox(USmartCombo::AutoDropWidth)
{
	m_hDesc = NULL;
}

CKeywordComboBox::~CKeywordComboBox()
{
}


BEGIN_MESSAGE_MAP(CKeywordComboBox, CSmartComboBox)
	//{{AFX_MSG_MAP(CKeywordComboBox)
	ON_CONTROL_REFLECT(CBN_SELCHANGE, OnSelchange)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CKeywordComboBox message handlers

/// CBN_SELCHANGE message handler, set the description for the option
void CKeywordComboBox::OnSelchange() 
{
	SetDescription();
}

/*!
	Set the keyword substitution mode description according to the keywords combo box selection
	\note The "Current" description is set if no selection is present
*/
void CKeywordComboBox::SetDescription()
{
	if( m_hDesc && ::IsWindow(m_hDesc) )
	{
		const char* desc = gKeywordModes[0].desc;
		const int selItem = GetCurSel();
		if( selItem > -1 )
		{
			desc = (const char*)GetItemData(selItem);
		}
			
		::SetWindowText(m_hDesc, desc);
	}
}

/*!
	Set the description window handle
	\param hDesc Description window handle
	\note It updates the description window text immediately
*/
void CKeywordComboBox::SetDescriptionWnd(HWND hDesc)
{
	m_hDesc = hDesc;
	SetDescription();
}

/// PreSubclassWindow virtual override, add items to the drop down list
void CKeywordComboBox::PreSubclassWindow() 
{
	CSmartComboBox::PreSubclassWindow();

	for(int nIndex = 0; nIndex < KEYWORD_MODE_COUNT; nIndex++)
	{
		const int itemIndex = AddString(gKeywordModes[nIndex].mode);
		if( itemIndex > -1 )
		{
			SetItemData(itemIndex, (DWORD)gKeywordModes[nIndex].desc);
		}
	}
}

#endif /* WIN32 */
