// CvsProject.cpp: implementation of the CvsProject class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "CVS_Coworker_i.h"
#include "CvsTrace.h"
#include "CvsProject.h"

// Unique project number counter.
static int g_hNextProject = 1000;

// Global list of projects.
static CvsProject* g_pProjects;

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CvsProject::CvsProject()
:   m_hProject(g_hNextProject++),
    m_pNextProject(g_pProjects),
    m_iLastError(0)
{
    g_pProjects = this;
}

CvsProject::~CvsProject()
{
    ASSERT(!m_pNextProject);
    // Not freed immediately for error catching.
}

//
//  Access to global list of projects.
//

CvsProject* CvsProject::FindProject(int h)
{
    CvsProject* pProject = g_pProjects;
    while (pProject) {
        if (h == pProject->getProjectHandle()) {
            return pProject;
        }
        pProject = pProject->m_pNextProject;
    }
    return 0;
}

//
//  Error reporting
//

bool CvsProject::getErrorMessage(int iError,CvsString& sError)
{
    // TODO: Add your implementation code here
    sError = "No error";
    return true;
}

//
//  Implementation of CVS coworker operations.
//

bool CvsProject::getProject(
    const char* sUsername,
    const char* sProjectName,
    const char* sProjectHome,
    BOOL bAllowPathChange,
    BOOL bAllowNewProject,
    BOOL& bNewProject
    )
{
    m_sUsername     = sUsername;
    m_sProjectName  = sProjectName;
    m_sProjectHome  = sProjectHome;
    // TODO: Add your implementation code here
    return false;
}

bool CvsProject::openProject(
    const char* sUsername,
    const char* sProjectName,
    const char* sProjectHome
    )
{
    m_sUsername     = sUsername;
    m_sProjectName  = sProjectName;
    m_sProjectHome  = sProjectHome;
    // TODO: Add your implementation code here
    return true;
}

bool CvsProject::closeProject()
{
    // TODO: Add your implementation code here
    return true;
}

bool CvsProject::updateFiles(
    CvsFilenames& filenames,
    BOOL bDirectories,
    BOOL bRecurse
    )
{
    // TODO: Add your implementation code here
    return true;
}

bool CvsProject::checkoutFiles(
    CvsFilenames& filenames
    )
{
    // TODO: Add your implementation code here
    return true;
}

bool CvsProject::checkinFiles(
    CvsFilenames& filenames,
    BOOL bKeepCheckedOut
    )
{
    // TODO: Add your implementation code here
    return true;
}

bool CvsProject::uncheckoutFiles(
    CvsFilenames& filenames
    )
{
    // TODO: Add your implementation code here
    return true;
}

bool CvsProject::addFiles(
    CvsFilenames& sOptionsAndFilenames,
    const char* sComment
    )
{
    // TODO: Add your implementation code here
    return true;
}

bool CvsProject::removeFiles(
    CvsFilenames& filenames
    )
{
    // TODO: Add your implementation code here
    return true;
}

bool CvsProject::renameFile(
    const char* sOldFilename,
    const char* sNewFilename
    )
{
    // TODO: Add your implementation code here
    return true;
}

bool CvsProject::diffFile(
    const char* sFilename,
    BOOL bIgnoreCase,
    BOOL bIgnoreWhitespace
    )
{
    // TODO: Add your implementation code here
    return true;
}

bool CvsProject::isFileDifferent(
    const char* sFilename,
    CvsOption option,
    BOOL& bFileIsDifferent
    )
{
    bFileIsDifferent = false;
    // TODO: Add your implementation code here
    return true;
}

bool CvsProject::showFileHistory(
    CvsFilenames& filenames
    )
{
    // TODO: Add your implementation code here
    return true;
}

bool CvsProject::showFileProperties(
    const char* sFilename
    )
{
    // TODO: Add your implementation code here
    return true;
}

bool CvsProject::showUserInterface(
    CvsFilenames& filenames
    )
{
    CWnd* pMainWnd = AfxGetMainWnd();
    if (pMainWnd) {
        pMainWnd->ShowWindow(SW_SHOWDEFAULT);
    }
    CWinApp* pApp = AfxGetApp();
    if (pApp) {
         // TBD
    }
    // TODO: Add your implementation code here
    return true;
}

bool CvsProject::hasAdvancedOptionsForCommand(
    CvsCommand command,
    BOOL& bAdvancedOptions
    )
{
    // TODO: Add your implementation code here
    return true;
}

bool CvsProject::showAdvancedOptionsForCommand(
    CvsCommand command
    )
{
    // TODO: Add your implementation code here
    return true;
}

bool CvsProject::getFileChanges(
    CvsString& sFilenames
    )
{
    // TODO: Add your implementation code here
    return true;
}

bool CvsProject::getFilesToAdd(
    CvsString& sFilenames
    )
{
    // TODO: Add your implementation code here
    return true;
}
