/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@hotmail.com> --- December 1997
 */

/*
 * MacMisc.cpp --- misc. utilities for mac
 */

/* here should be a define, to recorgnize if this file is needed in dev-tools */
#ifdef TARGET_OS_MAC

#include "GUSIInternal.h"
#include "GUSIFileSpec.h"
#include "Persistent.h"
#include "AppConsole.h"

#include "MacMisc.h"
#include "VolsPaths.h"

Handle
GetDItemHdl(DialogPtr dlg, SInt16 Id)
{
	SInt16	type;
	Handle	item;
	Rect	box;
	
	GetDialogItem(dlg, Id, &type, &item, &box);
	return item;
}

ControlHandle
GetDItemCtrlHdl(DialogPtr dlg, SInt16 Id)
{
	SInt16	type;
	Handle	item;
	Rect	box;
	
	GetDialogItem(dlg, Id, &type, &item, &box);
	return (ControlHandle)item;
}

SInt16 GetDItemMenuSel(DialogPtr dlg, SInt16 Id)
{
	ControlHandle ctrl = GetDItemCtrlHdl(dlg, Id);
	return ctrl != 0L ? GetControlValue(ctrl) : 0;
}

void SetDItemMenuSel(DialogPtr dlg, SInt16 Id, SInt16 sel)
{
	ControlHandle ctrl = GetDItemCtrlHdl(dlg, Id);
	if(ctrl != 0L)
		SetControlValue(ctrl, sel);
}


OSErr
MacGetSpecialFolder(UFSSpec & theFolder, UStr & thePath, OSType inType,
	const char* inDesc, bool createFolder)
{
	OSErr err;
	err = ::FSFindFolder(kOnAppropriateDisk, inType,
					createFolder, &theFolder);
	if (err != noErr)
	{
		cvs_err("MacCvs: Unable to find the %s folder (error %d)\n", inDesc, err);
		return err;
	}

	GUSIFileSpec spec(theFolder);
	thePath = spec.FullPath();

	return err;
}

OSErr
MacGetTempFolder(UFSSpec & theFolder, UStr & thePath)
{
	static UFSSpec cacheFile = {0, 0, '\0'};
	static UStr cachePath;
	if(!cachePath.empty())
	{
		theFolder = cacheFile;
		thePath = cachePath;
		return noErr;
	}
	
	OSErr err = MacGetSpecialFolder (theFolder, thePath, kTemporaryFolderType, "temporary", true);
	if(err == noErr)
	{
		cacheFile = theFolder;
		cachePath = thePath;
	}
	
	return err;
}

OSErr
MacGetPrefsFolder(UFSSpec & theFolder, UStr & thePath)
{
	static UFSSpec cacheFile = {0, 0, '\0'};
	static UStr cachePath;
	if(!cachePath.empty())
	{
		theFolder = cacheFile;
		thePath = cachePath;
		return noErr;
	}
	
	OSErr err = MacGetSpecialFolder (theFolder, thePath, kPreferencesFolderType, "preferences");
	if(err == noErr)
	{
		cacheFile = theFolder;
		cachePath = thePath;
	}
	
	return err;
}

#endif /* TARGET_OS_MAC */
