from cvsgui.CvsEntry import *
import os, os.path
import string

"""
  CvsGui Macro Library Module "MacroUtils"
  $Revision: 1.3 $

  written by Oliver Giesen, May-Aug 2003
  contact:
    email:  ogware@gmx.net
    jabber: ogiesen@jabber.org
    icq:    18777742

  Feel free to modify or distribute in whichever way you like, 
   as long as it doesn't limit my personal rights to modify and
   redistribute this code.
   Apart from that the code is supplied "as-is", i.e. without warranty of any
   kind, either expressed or implied, regarding its quality or security.
   Have fun!

  ======

  Please report any problems you may encounter or suggestions you might have
  to ogware@gmx.net .
    
"""

def prepareTargets(entries, args, doChDir = 1):
  """ Given a CvsEntries list, calculates a common basedir
    and a corresponding list of targets. This is necessary
    in order to ensure correct behaviour when working on
    flat view selections.
    See macros cvs2cl.py or TagAndUpdate.py for examples of usage.
  """
  targets = []
  if len(entries) > 1:
    for entry in entries:
      targets.append(entry.GetFullName())

    basedir = os.path.commonprefix(targets)
    #make sure the common prefix is a directory:
    if not targets[0][len(basedir)-1] in '/\\':
      basedir = os.path.dirname(basedir)
      #re-attach the path-separator that os.path.dirname has stripped:
      basedir += targets[0][len(basedir)]
      
    if not os.path.exists(basedir):
      raise Exception, 'Error determining common base dir for selected entries!\n[%s]'%basedir
    baselen = len(basedir)
    for i in range(len(targets)):
      targets[i] = targets[i][baselen:]
  else:
    entry = entries[0]
    if entry.IsFile():
      basedir = entry.GetPath()
      targets.append(entry.GetName())
    else:
      basedir = entry.GetFullName()
      
  args += targets
  
  if doChDir:
    os.chdir(basedir)
  else:
    return basedir

def purgeTree(path):
  """
    shutil.rmtree() cannot delete read-only files, so we need to do it
    manually by changing the attributes on each file to r/w before deleting.
  """
  try:
    names = os.listdir(path)
    for name in names:
      name = os.path.join(path, name)
      if os.path.isdir(name):
        purgeTree(name)
      else:
        os.chmod(name, 664)
        os.remove(name)
    os.rmdir(path)
  except:
    print 'Could not remove dir:', path
  return not os.path.exists(path)
