/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@hotmail.com>
 */

#ifndef WINCVS_WINUTIL_H
#define WINCVS_WINUTIL_H

enum
{
	kCustomBrowserMenu,
	kCustomFilesMenu
};

CWnd* FindNextWindow(CWnd* pWnd, BOOL CheckTabStop = TRUE);
CWnd* FindPrevWindow(CWnd* pWnd, BOOL CheckTabStop = TRUE);

CMenu* GetSubCMenu(int nStartId, CView* pThis);
CMenu* GetMenuEntry(int nStartId, int& pos);
CMenu* GetCustomMenu(int whichmenu, CView* pThis);
void CustomizeMenus(int whichmenu);
bool FormatMenuString(int cmd, CString& str);
CMenu* GetTopPopupMenu(const char* menuString);

bool IsLargeFonts();
bool IsHideCommandKeyPressed();

DWORD SetListCtrlExtendedStyle(CListCtrl* pListCtrl, const DWORD dwExtendedStyle);

/// Class to support efficient drawing of CWnd based windows by managing window's redraw
class CWndRedrawMngr
{
private:
	CWnd* m_pWnd;	/*!< Window to manage */

public:
	CWndRedrawMngr(CWnd* pWnd, BOOL bRedraw = FALSE);
	virtual ~CWndRedrawMngr();
	
	void SetRedraw(BOOL bRedraw);
};

/// Critical section to protect while accessing MFC from cvs
class CCvsThreadLock
{
public:
	// Construction
	CCvsThreadLock();
	virtual ~CCvsThreadLock();

private:
	// Data members
	static CRITICAL_SECTION m_lock;	/*!< Critical section lock structure */
	static bool m_initialized;		/*!< Flag to prevent multiple initialization */

public:
	// Interface
	static void Initialize();
	static void Delete();
};

#endif	/*WINCVS_WINUTIL_H*/
