from cvsgui.App import *
from cvsgui.ColorConsole import *
from cvsgui.Cvs import *
from cvsgui.Macro import *
from cvsgui.Persistent import *
import os, os.path
import shutil

"""
  WinCvs Macro "Add Root Module"
  $Revision: 1.1 $

  written by Oliver Giesen, Dec 2002
  contact:
    email:  ogware@gmx.net
    jabber: ogiesen@jabber.org
    icq:    18777742

  Feel free to modify or distribute in whichever way you like,
   as long as it doesn't limit my personal rights to
   modify and redistribute this code.
   Apart from that the code is supplied "as-is", i.e. without warranty of any
   kind, either expressed or implied, regarding its quality or security.
   Have fun!

  ATTENTION:
   You will need at least WinCvs 1.3.4 to execute any Python macros
   from within WinCvs! This macro has been tested against WinCvs 1.3.10 .

  ======
  Usage:

  - Select a non-CVS folder from the tree-/file-view
  
  - Run the macro from the Macros|CVS menu

   ~You will be asked for the CVSROOT of the repository to add the module to

  - Enter or accept the CVSROOT and press OK

   ~The directory will be added as a new root-level module to the
    specified repository

  =============

  Please report any problems you may encounter or suggestions you might have
  to ogware@gmx.net .
  
"""

class AddRootModuleConfig:
  def getCVSROOT(self, useStored = 1):
    if os.environ.has_key('CVSROOT'):
      return os.environ['CVSROOT']
    elif useStored:
      return str(self.root)
    else:
      return ''
      
  def __init__(self):
    self.root = Persistent('P_AddRootCVSROOT', self.getCVSROOT(0), 1)
  
class AddRootModule(Macro):
  def __init__(self, config):
    Macro.__init__(self, 'Add Root Module...', MACRO_SELECTION, 0, 'CVS')
    self.config = config

  def OnCmdUI(self, cmdui):
    sel = App.GetSelection()
    enabled =    (len(sel) == 1) \
              and(not sel[0].IsFile()) \
              and(sel[0].IsUnknown())
    if enabled:
      self.dir = sel[0].GetFullName()
    cmdui.Enable(enabled)

  def Run(self):
    basedir, module = os.path.split(self.dir)
    console = ColorConsole()
    if os.path.exists(os.path.join(basedir, 'CVS')):
      console << kRed << 'Parent directory may not be CVS-controlled!\n' << kNormal
      return
    msg = 'Please enter the CVSROOT you wish to add the new root module to!'
    title = 'Add Root Module'
    ok, root = App.PromptEditMessage( msg, self.config.getCVSROOT(), title)
    if not( ok and len(root)>0):
      print 'Operation cancelled by user.'
      return
    
    os.chdir(basedir)
    cvs = Cvs(1,0)
    print 'Preparing sandbox...'
    code, err, out = cvs.Run('-d'+root, 'co', '-l', '.')
    if code <> 0:
      console << kRed << err << '\n' << kNormal
      return

    print 'Creating new module %s/%s...' % (root, module)
    code, err, out = cvs.Run('add', module)
    if code <> 0:
      console << kRed << err << '\n' << kNormal
      return

    print 'Cleaning up...'
    shutil.rmtree(os.path.join(basedir, 'CVS'))

    print 'Done.'
    self.config.root << root

config = AddRootModuleConfig()
AddRootModule(config)