#ifndef _GUSILSH_
#define _GUSILSH_

#include <sys/signal.h>
#include "lsh_dll.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef struct
{
	lshctx				*lsh_ctx;
	struct sigaction	oldHandler;
	int					doAbort;
} gusilsh_ctx;

void GUSIwithLSHSockets(void);
void GUSIwithoutLSHSockets(void);
void GUSILSH_set_context(gusilsh_ctx *ctx);
void GUSILSH_cleanup (int sig);
void GUSILSH_hdlevt(long userData, long sleepTime);

#ifdef __cplusplus
}
#endif

#endif /* _GUSILSH_ */
