/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@hotmail.com> --- March 1998
 */

/*
 * UpdateDlg.h : the cvs update dialog
 */

#if !defined(AFX_UPDATEDLG_H__98CCBD22_845B_11D1_8949_444553540000__INCLUDED_)
#define AFX_UPDATEDLG_H__98CCBD22_845B_11D1_8949_444553540000__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "CPStr.h"
#include "MultiString.h"
#include "SmartComboBox.h"

class MultiFiles;

bool CompatGetUpdate(const MultiFiles* mf,
					 bool& toStdout, bool& noRecurs, bool& resetSticky,
					 CPStr& date, CPStr& rev,
					 bool& useMostRecent,
					 CPStr& rev1, CPStr& rev2,
					 bool& createMissDir,
					 bool& getCleanCopy);

// persistent default values for the dates, tags...
extern CMString gRevNames;
extern CMString gReleasesNames;
extern CMString gDateNames;
extern CMString gDateOrRevNames;

#ifdef WIN32
class CUpdateMain : public CPropertyPage
{
	DECLARE_DYNAMIC(CUpdateMain)

// Construction
public:
	CUpdateMain();
	~CUpdateMain();

// Dialog Data
	//{{AFX_DATA(CUpdateMain)
	enum { IDD = IDD_UPDATE_MAIN };
	BOOL	m_delsticky;
	BOOL	m_norecurs;
	BOOL	m_stdout;
	BOOL	m_createmissdir;
	BOOL	m_getcleancopy;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CUpdateMain)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(CUpdateMain)
		// NOTE: the ClassWizard will add member functions here
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};

class CUpdateMerge : public CPropertyPage
{
	DECLARE_DYNAMIC(CUpdateMerge)

// Construction
public:
	CUpdateMerge(const MultiFiles* mf,
		bool isCheckout, 
		const char* rev1, const char* rev2, const char* date1, const char* date2);
	~CUpdateMerge();

// Dialog Data
	//{{AFX_DATA(CUpdateMerge)
	enum { IDD = IDD_UPDATE_MERGE };
	CSmartComboBox	m_date2Combo;
	CSmartComboBox	m_date1Combo;
	CSmartComboBox	m_rev2Combo;
	CSmartComboBox	m_rev1Combo;
	CString	m_rev1;
	CString	m_rev2;
	int m_merge;
	BOOL	m_hasDate1;
	BOOL	m_hasDate2;
	CString	m_date1;
	CString	m_date2;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CUpdateMerge)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(CUpdateMerge)
	afx_msg void OnMerge();
	afx_msg void OnMerge1();
	afx_msg void OnMerge2();
	afx_msg void OnCheckdate1();
	afx_msg void OnCheckdate2();
	afx_msg void OnBrowseTag1();
	afx_msg void OnBrowseTag2();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
private:
	const MultiFiles* m_mf;
	bool m_isCheckout;
};

class CUpdateSticky : public CPropertyPage
{
	DECLARE_DYNAMIC(CUpdateSticky)

// Construction
public:
	CUpdateSticky(const MultiFiles* mf,
		const char* rev, const char* date);
	~CUpdateSticky();

// Dialog Data
	//{{AFX_DATA(CUpdateSticky)
	enum { IDD = IDD_UPDATE_STICKY };
	CSmartComboBox	m_dateCombo;
	CSmartComboBox	m_revCombo;
	CString	m_date;
	CString	m_rev;
	BOOL	m_hasdate;
	BOOL	m_hasrev;
	BOOL	m_match;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CUpdateSticky)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(CUpdateSticky)
	afx_msg void OnDate();
	afx_msg void OnRev();
	afx_msg void OnBrowseTag();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
private:
	const MultiFiles* m_mf;
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.
#endif /* WIN32 */

#endif // !defined(AFX_UPDATEDLG_H__98CCBD22_845B_11D1_8949_444553540000__INCLUDED_)
