/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@hotmail.com> --- February 2000
 */

/*
 * 
 */

#include "stdafx.h"

#if qGTK
#	include <gtk/gtk.h>
#endif

#include "UCvsFrame.h"
#include "UCvsApp.h"
#include "UCvsCommands.h"
#include "UCvsFolders.h"
#include "CvsAlert.h"
#include "PromptFiles.h"
#include "CvsPrefs.h"
#include "AppConsole.h"
#include "CvsCommands.h"
#include "TclGlue.h"
#include "MacrosSetup.h"
#include "GetPrefs.h"
#include "UCvsDialogs.h"
#include "BrowseViewHandlers.h"
#include "AboutDlg.h"

UIMPLEMENT_DYNAMIC(UCvsFrame, UWidget)

UBEGIN_MESSAGE_MAP(UCvsFrame, UWidget)
	ON_UUPDATECMD_RANGE(cmdABOUT, cmdABOUT, UCvsFrame::OnCmdUIAnytime)
	ON_UUPDATECMD_RANGE(cmdCREDITS, cmdCOPYRIGHTS, UCvsFrame::OnCmdUIAnytime)
	ON_UUPDATECMD_RANGE(UCvsFrame::kDirCombo, UCvsFrame::kBrowserPopup, UCvsFrame::OnCmdUIAnytime)
	ON_UUPDATECMD(cmdEXIT, UCvsFrame::OnCmdUIQuit)
	ON_UUPDATECMD_RANGE(cmdPREFERENCES, cmdPREFERENCES, UCvsFrame::OnCmdUIAnytime)
	ON_UUPDATECMD(cmdSTOPCVS, UCvsFrame::OnCmdUIStopcvs)
	ON_UUPDATECMD(cmdRTAGCREATE, UCvsFrame::OnCmdUICvsCmd)
	ON_UUPDATECMD(cmdSAVESETTINGS, UCvsFrame::OnCmdUICvsCmd)
	ON_UUPDATECMD(cmdINIT, UCvsFrame::OnCmdUICvsCmd)
	ON_UUPDATECMD(cmdRTAGDELETE, UCvsFrame::OnCmdUICvsCmd)
	ON_UUPDATECMD(cmdRTAGBRANCH, UCvsFrame::OnCmdUICvsCmd)
	ON_UUPDATECMD(cmdCMDLINE, UCvsFrame::OnCmdUICvsCmd)
	ON_UUPDATECMD(cmdLOGIN, UCvsFrame::OnCmdUICvsCmd)
	ON_UUPDATECMD(cmdLOGOUT, UCvsFrame::OnCmdUICvsCmd)
	ON_UUPDATECMD_RANGE(cmdMACROADMIN, cmdMACROADMINEND, UCvsFrame::OnCmdUIMacroAdmin)
	ON_COMBO_SEL(UCvsFrame::kDirCombo, UCvsFrame::OnComboSelDir)
	ON_UCOMMAND(UCvsFrame::kBrowserPopup, UCvsFrame::OnBrowserPopup)
	ON_UCOMMAND(cmdCOPYRIGHTS, UCvsFrame::OnCopyrights)
	ON_UCOMMAND(cmdCREDITS, UCvsFrame::OnCredits)
	ON_UCOMMAND(cmdABOUT, UCvsFrame::OnAbout)
	ON_UCOMMAND(cmdEXIT, UCvsFrame::OnQuit)
	ON_UCOMMAND(cmdPREFERENCES, UCvsFrame::OnCmdPreferences)
	ON_UCOMMAND(cmdSAVESETTINGS, UCvsFrame::OnCmdSaveSettings)
	ON_UCOMMAND(cmdRTAGCREATE, UCvsFrame::OnCmdRtagNew)
	ON_UCOMMAND(cmdRTAGDELETE, UCvsFrame::OnCmdRtagDelete)
	ON_UCOMMAND(cmdRTAGBRANCH, UCvsFrame::OnCmdRtagBranch)
	ON_UCOMMAND(cmdCMDLINE, UCvsFrame::OnCmdCmdline)
	ON_UCOMMAND(cmdLOGIN, UCvsFrame::OnCmdLogin)
	ON_UCOMMAND(cmdLOGOUT, UCvsFrame::OnCmdLogout)
	ON_UCOMMAND(cmdSTOPCVS, UCvsFrame::OnCmdStopcvs)
	ON_UCOMMAND(cmdINIT, UCvsFrame::OnCmdInit)
	ON_UCOMMAND_RANGE(cmdMACROADMIN, cmdMACROADMINEND, UCvsFrame::OnCmdMacroAdmin)
	ON_UDESTROY(UCvsFrame)
UEND_MESSAGE_MAP()

#if 0
	//}}AFX_MSG_MAP
	// Enable default OLE container implementation
	//ON_UPDATE_COMMAND_UI(ID_EDIT_PASTE, CDocument::OnUpdatePasteMenu)
	ON_COMMAND_EX_RANGE(ID_MACRO_ADMIN, ID_MACRO_ADMIN + 99, OnMacroAdmin)
	ON_COMMAND(ID_FILE_SEND_MAIL, OnFileSendMail)
	ON_UPDATE_COMMAND_UI(ID_FILE_SEND_MAIL, OnUpdateFileSendMail)
#endif

UCvsFrame::UCvsFrame() : UWidget(kUCvsFrameID)
{
}

UCvsFrame::~UCvsFrame()
{
}

void UCvsFrame::OnDestroy(void)
{
#if qGTK
	gtk_main_quit();
#endif /* qGTK */
	delete this;
}

bool UCvsFrame::AskForQuitting(void)
{
	bool res = true;

	if(UCvsApp::gApp->IsCvsRunning())
		res = !CvsAlert("Cvs is currently running. Are-you sure you want to quit ?", "Cancel", "Quit");

	gCvsPrefs.save();

	return res;
}

void UCvsFrame::OnComboSelDir(int pos, const char *txt)
{
	UCvsApp::gApp->GetBrowserView()->ResetBrowser(txt, true);
}

int UCvsFrame::OnBrowserPopup(void)
{
	const char *newPath =
		BrowserGetDirectory("Select a folder to open with the browser");
	if(newPath == 0L)
		return 0;

	UCvsApp::gApp->GetBrowserView()->ResetBrowser(newPath, true);

	return 0;
}

int UCvsFrame::OnQuit(void)
{
	if(!AskForQuitting())
		return 0;

#if qGTK
	gtk_main_quit();
#endif /* qGTK */

	return 0;
}

void UCvsFrame::OnCmdUIQuit(UCmdUI *pCmdUI)
{
	pCmdUI->Enable(true);
}

void UCvsFrame::OnCmdUIAnytime(int cmd, UCmdUI *pCmdUI)
{
	pCmdUI->Enable(!UCvsApp::gApp->IsCvsRunning());
}

int UCvsFrame::OnAbout()
{
	AboutDialog();
	return 0;
}

int UCvsFrame::OnCopyrights()
{
	const char *appName = UCvsApp::gApp->GetAppName();

	cvs_out("\nBoth %s and CVS are distributed under the terms of\n", appName);
	cvs_out("the GNU General Public Licence (GPL).\n\n");
	cvs_out("* %s : maintained by Alexandre Parenteau (aubonbeurre@hotmail.com)\n", appName);
	cvs_out("* CVS : Copyright  1989-1998 Brian Berliner, david d `zoo' zuhn,\n");
	cvs_out("        Jeff Polk, and other authors\n");
#ifdef macintosh
	printf("* MacCVS : Mike Ladwig, Matthias Neeracher, Alexandre Parenteau\n");
	printf("* GUSI : Copyright  1992-1997 Matthias Neeracher\n");
	printf("* Waste : Copyright  1993-1998 Marco Piovanelli\n");
	printf("* CWASTEEdit : Copyright  1995-1997 Timothy Paustian\n");
	printf("* ABalloon : Freeware of James W. Walker (jwwalker@kagi.com)\n");
	printf("* Metrowerks Standard Library, PowerPlant & CodeWarrior :\n");
	printf("    Copyright  1996-1997 Metrowerks Inc.\n");
	printf("* MPW, MoreFiles : Copyright  Apple Computer Inc.\n");
#endif
#ifdef WIN32
	cvs_out("* WinCvs documentation : Copyright  1999 Don Harper <don@lamrc.com>.\n");
	cvs_out("* CJLIB : Copyright  1998-99 Kirk Stowell <kstowell@codejockeys.com>\n");
	cvs_out("* MFC : Copyright  1992-1997 Microsoft Corporation\n");
#endif
	cvs_out("* Kerberos : Copyright  1997 the Massachusetts Institute of Technology\n");
	cvs_out("* TCL : Copyright  Sun Microsystems Inc.\n");
	cvs_out("\nSome others copyrights may apply, check the source code for details.\n");
	return 0;
}

int UCvsFrame::OnCredits()
{
	const char *appName = UCvsApp::gApp->GetAppName();
	const char *appVers = UCvsApp::gApp->GetAppVersion();

#ifndef macintosh
	cvs_out("\n%s %s - Client/Local\n", appName, appVers);
#else
	cvs_out("\n%s %s - Client\n", appName, appVers);
#endif
	cvs_out("%s is maintained by Alexandre Parenteau\n", appName);
	cvs_out("- WinCvs/MacCvs/gcvs page : http://www.wincvs.org or http://cvsgui.sourceforge.net/\n");
	cvs_out("- cvs page : http://www.cvshome.org\n");
#ifdef WIN32
	cvs_out("- WinCvs documentation : Don Harper <don@lamrc.com>.\n");
	cvs_out("- WinHelp cvs documentation : Norbert Klamann.\n");
#endif
#ifdef macintosh
	printf("- Mac port :\n");
	printf("\t* Mike Ladwig <mike@twinpeaks.prc.com>\n");
	printf("\t* Matthias Neeracher <neeri@iis.ee.ethz.ch>\n");
	printf("\t* Alexandre Parenteau <aubonbeurre@hotmail.com>\n");
	printf("- With contributions of :\n");
	printf("\t* Miro Jurisic <meeroh@mit.edu> (Kerberos)\n");
	printf("\t* Aleks Totic <atotic@netscape.com> (AppleSingle)\n");
	printf("\t* Jocelyn Houle <houlejo@IRO.UMontreal.CA> (Help balloons)\n");
#endif
	cvs_out("- Special thanks to :\n");
	cvs_out("\t* Gary Bringhurst from C3D Digital who gives me time, resources,\n");
	cvs_out("\t  help and ideas for doing this project (http://www.3d.com)\n");
	cvs_out("\t* The Freeware community for providing cvs, Linux, Perl, GTK, gcc\n");
	cvs_out("\t  and so many others valuables tools\n");
	cvs_out("\t* The users of the CvsGui project (WinCvs, MacCvs, gcvs) who have\n");
	cvs_out("\t  defined all the functionnalities and help every day to enhance it\n");
	cvs_out("- Cvs contributors :\n");
	cvs_out("\t* Too many to be listed here, see the 'ChangeLog' instead !\n");
	return 0;
}

int UCvsFrame::OnCmdPreferences(void)
{
	CompatGetPrefs();
	return 0;
}

int UCvsFrame::OnCmdSaveSettings(void)
{
	UCvsFolders *browser = UCvsApp::gApp->GetBrowserView();
	if(browser != 0L && browser->GetRoot() != 0L)
		AskCreatePersistentSettings(browser->GetRoot());
	return 0;
}

int UCvsFrame::OnCmdRtagNew(void)
{
  KoRtagCreateHandler handler;
	CvsCmdRtagCreate(handler);
  
	return 0;
}

int UCvsFrame::OnCmdRtagDelete(void)
{
  KoRtagDeleteHandler handler;
	CvsCmdRtagDelete(handler);
	return 0;
}

int UCvsFrame::OnCmdRtagBranch(void)
{
  KoRtagBranchHandler handler;
	CvsCmdRtagBranch(handler);
	return 0;
}

int UCvsFrame::OnCmdCmdline(void)
{
  KoCommandLineHandler handler;
	CvsCmdCommandLine(handler);
	return 0;
}

int UCvsFrame::OnCmdLogin(void)
{
	CvsCmdLogin();
	return 0;
}

int UCvsFrame::OnCmdLogout(void)
{
	CvsCmdLogout();
	return 0;
}

int UCvsFrame::OnCmdStopcvs(void)
{
	UCvsApp::gApp->SetCvsStopping(true);
	if(UCvsApp::gApp->GetCvsProcess() != 0L && cvs_process_is_active(UCvsApp::gApp->GetCvsProcess()))
	{
		cvs_process_stop(UCvsApp::gApp->GetCvsProcess());
		cvs_out("*****CVS stopped on user request !!! *****\n\n");
	}
	
	return 0;
}

int UCvsFrame::OnCmdInit(void)
{
	CvsCmdInit();
	return 0;
}

int UCvsFrame::OnCmdMacroAdmin(int cmd)
{
	CMacroEntry & entry = gMacrosAdmin.entries[cmd - cmdMACROADMIN];
	CvsCmdMacrosAdmin(entry.path);
	return 0;
}

void UCvsFrame::OnCmdUIStopcvs(UCmdUI *pCmdUI)
{
	UCvsApp *app = UCvsApp::gApp;
	pCmdUI->Enable(app->IsCvsRunning() && !app->IsCvsStopping());
}

void UCvsFrame::OnCmdUICvsCmd(UCmdUI *pCmdUI)
{
	pCmdUI->Enable(!UCvsApp::gApp->IsCvsRunning() && !gCvsPrefs.empty());
}

void UCvsFrame::OnCmdUIMacroAdmin(int cmd, UCmdUI *pCmdUI)
{
	pCmdUI->Enable(!UCvsApp::gApp->IsCvsRunning() && !gCvsPrefs.empty() && CTcl_Interp::IsAvail());
}
