/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Jerzy Kaczorowski <kaczoroj@hotmail.com> --- October 2002
 */

/*
 * LoginDlg.cpp : the cvs login dialog implementation file
 */

#include "stdafx.h"

#ifdef WIN32
#	include "wincvs.h"
#endif /* WIN32 */

#include "LoginDlg.h"
#include "CvsPrefs.h"
#include "GetPrefs.h"

#ifdef WIN32

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CLogin_MAIN property page

IMPLEMENT_DYNAMIC(CLogin_MAIN, CPropertyPage)

CLogin_MAIN::CLogin_MAIN(bool forceRoot) 
	: CPropertyPage(CLogin_MAIN::IDD)
{
	//{{AFX_DATA_INIT(CLogin_MAIN)
	//}}AFX_DATA_INIT

	m_forceRoot = forceRoot;

	m_helpLogin = _T("Select \"Force using the CVSROOT\" option to login according to your general preferences settings "
		"(otherwise current sandbox settings will be used by CVS client executable).\r\n"
		"\r\n"
		"Login command is interactive and it will ask you for password.\r\n"
		"Entered password will be cached by CVS so you need to login only once for each CVSROOT.\r\n"
		"\r\n"
		"To remove the password from CVS cache use the logout command.");
}

CLogin_MAIN::~CLogin_MAIN()
{
}

void CLogin_MAIN::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CLogin_MAIN)
	DDX_Check(pDX, IDC_FORCEROOT, m_forceRoot);
	DDX_Text(pDX, IDC_HELPLOGIN, m_helpLogin);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CLogin_MAIN, CPropertyPage)
	//{{AFX_MSG_MAP(CLogin_MAIN)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CLogin_MAIN message handlers

#endif

/// Get the login options
bool CompatGetLogin(bool& forceCvsroot)
{
	bool userHitOK = false;

	forceCvsroot = true;
	
#ifdef WIN32
	CPropertySheet pages("Login settings");
	pages.m_psh.dwFlags |= PSH_NOAPPLYNOW;
	
	CLogin_MAIN page1(forceCvsroot);
	CGetPrefs_CVSROOT page2;
	CGetPrefs_GLOBALS page3;
	pages.AddPage(&page1);
	pages.AddPage(&page2);
	pages.AddPage(&page3);

	if( pages.DoModal() == IDOK )
	{
		forceCvsroot = page1.m_forceRoot == TRUE;

		page2.StoreValues();
		page3.StoreValues();
		userHitOK = true;
	}
#endif /* WIN32 */

	if( userHitOK )
	{
		gCvsPrefs.save();
	}

	return userHitOK;
}
