/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Jerzy Kaczorowski <kaczoroj@hotmail.com> --- October 2001
 */

/*
 * EditorMonDlg.cpp --- editor monitor dialog
 */

#include "stdafx.h"
#include "CvsPrefs.h"
#include "CvsCommands.h"

#ifdef WIN32
#include "wincvs.h"
#include "EditorMonDlg.h"
#endif /* WIN32 */

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CEditorMonDlg dialog

#ifdef WIN32

CEditorMonDlg::CEditorMonDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CEditorMonDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CEditorMonDlg)
	m_tempFile = _T("");
	//}}AFX_DATA_INIT
}


void CEditorMonDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CEditorMonDlg)
	DDX_Text(pDX, IDC_TEMPFILE, m_tempFile);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CEditorMonDlg, CDialog)
	//{{AFX_MSG_MAP(CEditorMonDlg)
	ON_WM_DESTROY()
	ON_WM_TIMER()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CEditorMonDlg message handlers

void CEditorMonDlg::OnDestroy() 
{
	if( m_timer )
	{
		KillTimer(m_timer);
	}

	CDialog::OnDestroy();
}

BOOL CEditorMonDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// Extra initialization here
	m_timer = SetTimer(2048, 200, NULL);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CEditorMonDlg::OnTimer(UINT nIDEvent) 
{
	if( nIDEvent == m_timer && INVALID_HANDLE_VALUE != m_hProcess )
	{
		int status = WaitForSingleObject( m_hProcess, 0 );
		if( status == WAIT_OBJECT_0 )	//have been terminated...
		{
			EndDialog(IDOK);
		}
	}
	
	CDialog::OnTimer(nIDEvent);
}

#endif /* WIN32 */

bool CompatGetEditorMsg(UStr& message)
{
	bool msgOK = false;
	
#ifdef WIN32
	
	if(gCvsPrefs.Viewer() == 0L)
	{
		AfxMessageBox("You need to define a default viewer in the preferences", MB_OK | MB_ICONSTOP);
		return msgOK;
	}
	
	CStr tmpFile;
	if( MakeTmpFile(tmpFile, "LogMsg", "tmp", true) )
	{
		//launch editor
		PROCESS_INFORMATION sProcessInformation;
		if( LaunchEditor( tmpFile, (void*)&sProcessInformation ) )
		{
			//we don't need the thread's handle so close it now
			CloseHandle( sProcessInformation.hThread );
			
			//track the editor until it closes
			CStr uppath, folder;
			SplitPath(tmpFile, uppath, folder);

			CEditorMonDlg editorMonDlg;
			editorMonDlg.m_hProcess = sProcessInformation.hProcess;
			editorMonDlg.m_tempFile = folder;
			
			if( editorMonDlg.DoModal() == IDOK )
			{
				msgOK = true;
			}
			else
			{
				if( PostThreadMessage(sProcessInformation.dwThreadId, WM_QUIT, (WPARAM)EXIT_SUCCESS, 0) )
				{
					WaitForSingleObject( sProcessInformation.hProcess, 500 );
				}
				
				int nStatus = WaitForSingleObject( sProcessInformation.hProcess, 0 );
				if( nStatus != WAIT_OBJECT_0 )
				{
					TerminateProcess(sProcessInformation.hProcess, EXIT_SUCCESS);
				}
			}
			
			CloseHandle(sProcessInformation.hProcess);
		}
		
		//copy the file into message string
		FILE* stream = fopen(tmpFile, "r");
		if( stream )
		{
			char line[100];
			while( fgets(line, 100, stream) )
			{
				message << line;
			}
			fclose(stream);
		}
		
		//cleanup
		::DeleteFile(tmpFile);
	}
	
#if 0
	adminOptionDlg.m_optionString = (const char*)optionString;
	if( adminOptionDlg.DoModal() == IDOK )
	{
		optionString = (const char*)adminOptionDlg.m_optionString;
		userHitOK = true;
	}
#endif 

#endif /* WIN32 */

// the code below might help to do stuff on Unix or Mac later on
#if 0	
	const char * argv[2] = { 0L, 0L };
	CStr program;
	if(strchr(gCvsPrefs.Viewer(), ' ') != 0L)
	{
		program << '\"';
		program << gCvsPrefs.Viewer();
		program << '\"';
	}
	else
		program = gCvsPrefs.Viewer();
	
	argv[0] = program;
	int process = _spawnvp(_P_NOWAIT, gCvsPrefs.Viewer(), argv);
#endif 
	

#ifdef qMacCvsPP
#endif /* qMacCvsPP */
#if qUnix
#endif // qUnix
	
	return msgOK;
}
