/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@hotmail.com> --- March 1998
 */

/*
 * DiffDlg.h : the cvs diff dialog
 */

#if !defined(AFX_DIFFDLG_H__98CCBD22_845B_11D1_8949_444553540000__INCLUDED_)
#define AFX_DIFFDLG_H__98CCBD22_845B_11D1_8949_444553540000__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "CPStr.h"
#include "SmartComboBox.h"
#include "uwidget.h"

class MultiFiles;

bool CompatGetDiff(const MultiFiles* mf, 
				   bool& noRecurs, bool& isDate1, bool& isDate2,
				   CPStr& rev1, CPStr& rev2, bool& useExtDiff, bool & useUnifiedDiff,
				   bool& noWhiteSpace, bool & noBlankLines, bool& ignoreCase,
				   bool allowExtDiff = false);

#ifdef WIN32

class CDiff_MAIN : public CPropertyPage
{
	DECLARE_DYNAMIC(CDiff_MAIN)

// Construction
public:
	CDiff_MAIN(const MultiFiles* mf,
		const char* rev1, const char* rev2, 
		bool allowExtDiff, bool useExtDiff, bool noWhiteSpace, bool ignoreCase);
	~CDiff_MAIN();

// Dialog Data
	//{{AFX_DATA(CDiff_MAIN)
	enum { IDD = IDD_DIFF_MAIN };
	CButton	m_extdiffctl;
	CSmartComboBox	m_rev2Combo;
	CSmartComboBox	m_rev1Combo;
	BOOL	m_isDate1;
	BOOL	m_isDate2;
	CString	m_rev1;
	CString	m_rev2;
	int		m_diff;
	BOOL	m_norecurs;
	BOOL	m_extdiff;
	BOOL	m_noWhiteSpace;
	BOOL	m_ignoreCase;
	//}}AFX_DATA

	bool m_allowExtDiff;

// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CDiff_MAIN)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(CDiff_MAIN)
	afx_msg void OnDiff1();
	afx_msg void OnDiff2();
	afx_msg void OnDiff3();
	afx_msg void OnExtdiff();
	afx_msg void OnCheck1();
	afx_msg void OnCheck2();
	afx_msg void OnBrowseTag1();
	afx_msg void OnBrowseTag2();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
private:
	const MultiFiles* m_mf;
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.
#endif /* WIN32 */

#ifdef qUnix
#ifdef _DIFF_CPP_
class UCvsDiff : public UWidget
{
	UDECLARE_DYNAMIC(UCvsDiff)
public:
	UCvsDiff() : UWidget(::UEventGetWidID()) {}
	virtual ~UCvsDiff() {}

	enum
	{
		kOK = EV_COMMAND_START,	// 0
		kCancel,				// 1
		kTabGeneral				// 2
	};

	virtual void DoDataExchange(bool fill);

protected:
	ev_msg int OnOK(void);
	ev_msg int OnCancel(void);

	UDECLARE_MESSAGE_MAP()
};

UIMPLEMENT_DYNAMIC(UCvsDiff, UWidget)

UBEGIN_MESSAGE_MAP(UCvsDiff, UWidget)
	ON_UCOMMAND(UCvsDiff::kOK, UCvsDiff::OnOK)
	ON_UCOMMAND(UCvsDiff::kCancel, UCvsDiff::OnCancel)
UEND_MESSAGE_MAP()

class UCvsDiff_MAIN : public UWidget
{
	UDECLARE_DYNAMIC(UCvsDiff_MAIN)
public:
	UCvsDiff_MAIN(const char *rev1, const char *rev2, bool allowExtDiff, bool useUnifiedDiff, 
  		 		  bool noWhiteSpace, bool noBlankLines, bool ignoreCase);
	virtual ~UCvsDiff_MAIN() {}

	enum
	{
		kCheckDiff1 = EV_COMMAND_START,	// 0
		kCheckDiff2,			// 1
		kCheckDiff3,			// 2
		kCheckDate1,			// 3
		kCheckDate2,			// 4
		kComboRev1,				// 5
		kComboRev2,				// 6
		kCheckRecurs,			// 7
		kCheckExtDiff,			// 8
		kCheckNoWhiteSpace,     // 9
		kCheckIgnoreCase,       // 10
		kCheckNoBlankLines,		// 11
		kCheckUnifiedDiff		// 12
	};

	virtual void DoDataExchange(bool fill);

	bool m_check1;
	bool m_check2;
	UStr m_str1;
	UStr m_str2;
	int m_diff;
	bool m_norecurs;
	bool m_extdiff;
	bool m_unifiedDiff;
	bool m_allowExtDiff;
	bool m_noWhiteSpace;
	bool m_noBlankLines;
	bool m_ignoreCase;

protected:
	ev_msg int OnDiff(int cmd);

	UDECLARE_MESSAGE_MAP()
};

UIMPLEMENT_DYNAMIC(UCvsDiff_MAIN, UWidget)

UBEGIN_MESSAGE_MAP(UCvsDiff_MAIN, UWidget)
	ON_UCOMMAND_RANGE(UCvsDiff_MAIN::kCheckDiff1, UCvsDiff_MAIN::kCheckDiff2, UCvsDiff_MAIN::OnDiff)
UEND_MESSAGE_MAP()
#endif // _DIFF_CPP_

#endif // qUnix

#endif // !defined(AFX_DIFFDLG_H__98CCBD22_845B_11D1_8949_444553540000__INCLUDED_)
