// CvsCoworker.h : Declaration of the CvsCoworker

#ifndef __CVSCOWORKER_H_
#define __CVSCOWORKER_H_

#include "resource.h"       // main symbols

/////////////////////////////////////////////////////////////////////////////
// CvsCoworker
class ATL_NO_VTABLE CvsCoworker :
    public CComObjectRootEx<CComSingleThreadModel>,
    public CComCoClass<CvsCoworker, &CLSID_CvsCoworker>,
    public ISupportErrorInfo,
    public ICvsCoworker
{
public:
    CvsCoworker()
    {
        qTRACE_FN(CvsCoworker);
    }

DECLARE_REGISTRY_RESOURCEID(IDR_CVSCOWORKER)
DECLARE_NOT_AGGREGATABLE(CvsCoworker)

DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CvsCoworker)
    COM_INTERFACE_ENTRY(ICvsCoworker)
    COM_INTERFACE_ENTRY(ISupportErrorInfo)
END_COM_MAP()

// ISupportsErrorInfo
    STDMETHOD(InterfaceSupportsErrorInfo)(REFIID riid);

// ICvsCoworker
public:
    STDMETHOD(GetErrorMessage)(
            int handle,
            int iError,
            int cbErrorBuffer,
            unsigned char* sError
            );
    STDMETHOD(GetLastError)(
            int handle,
            int* piError
            );
    STDMETHOD(OpenProject)(
            int* pHandle,
            const unsigned char* sUsername,
            const unsigned char* sProjectName,
            const unsigned char* sProjectHome
            );
    STDMETHOD(GetProject)(
            int* pHandle,
            const unsigned char* sUsername,
            int cbProjectNameBuffer,
            unsigned char* sProjectName,
            int cbProjectHomeBuffer,
            unsigned char* sProjectHome,
            BOOL bAllowPathChange,
            BOOL bAllowNewProject,
            BOOL* pbNewProject
            );
    STDMETHOD(CloseProject)(
            int handle
            );
    STDMETHOD(UpdateFiles)(
            int handle,
            const unsigned char* sFilenames,
            BOOL bDirectories,
            BOOL bRecurse
            );
    STDMETHOD(CheckoutFiles)(
            int handle,
            const unsigned char* sFilenames
            );
    STDMETHOD(CheckinFiles)(
            int handle,
            const unsigned char* sFilenames,
            BOOL bKeepCheckedOut
            );
    STDMETHOD(UncheckoutFiles)(
            int handle,
            const unsigned char* sFilenames
            );
    STDMETHOD(AddFiles)(
            int handle,
            const unsigned char* sOptionsAndFilenames,
            const unsigned char* sComment
            );
    STDMETHOD(RemoveFiles)(
            int handle,
            const unsigned char* sFilenames
            );
    STDMETHOD(RenameFile)(
            int handle,
            const unsigned char* sOldFilename,
            const unsigned char* sNewFilename
            );
    STDMETHOD(DiffFile)(
            int handle,
            const unsigned char* sFilename,
            BOOL bIgnoreCase,
            BOOL bIgnoreWhitespace
            );
    STDMETHOD(ShowFileHistory)(
            int handle,
            const unsigned char* sFilenames
            );
    STDMETHOD(ShowFileProperties)(
            int handle,
            const unsigned char* sFilename
            );
    STDMETHOD(ShowUserInterface)(
            int handle,
            const unsigned char* sFilenames
            );
    STDMETHOD(HasAdvancedOptionsForCommand)(
            int handle,
            CvsCommand command,
            BOOL* pbAdvancedOptions
            );
    STDMETHOD(ShowAdvancedOptionsForCommand)(
            int handle,
            CvsCommand command
            );
    STDMETHOD(GetFileChanges)(
            int handle,
            int cbFilenameBuffer,
            unsigned char* sFilenameBuffer
            );
    STDMETHOD(GetFilesToAdd)(
            int handle,
            int cbFilenamesBuffer,
            unsigned char* sFilenamesBuffer
            );
};

#endif //__CVSCOWORKER_H_
