@REM --- COMMAND LINE PARAMETERS ---
@if not "%1%"=="" goto HELP


@REM --- SET THE ENVIRONMENT ---

@REM *Platform-specific variables*
@set DOX_PROJECT_NAME=WinCvs Source
@set DOX_PROJECT_VERSION=1.3 Beta 10 (Build 1)
@set DOX_OUTPUT_DIRECTORY=WinCvsSrcDoc
@set DOX_PREDEFINED=WIN32 __AFX_H__
@set DOX_INCLUDE_PATH=..\common ..\rf ..\WinCvs\CJLib\Include

@REM *Input*
@set DOX_INPUT=../rf ../common ../WinCvs
@set DOX_FILE_PATTERNS=
@set DOX_EXCLUDE_PATTERNS=*/CVS/*

@REM *Variable to strip from files path (STRIP_FROM_PATH)*
@set PWD_ORG=%CD%
cd %DOX_INPUT%
@set DOX_STRIP_FROM_PATH=%CD:\=/%
cd %PWD_ORG%

@REM *Output types*
@set DOX_CASE_SENSE_NAMES=NO
@set DOX_SHORT_NAMES=YES
@set DOX_OUTPUT_LANG=English

@REM *Output types*
@set DOX_GENERATE_HTML=YES
@set DOX_DOT_IMAGE_FORMAT=png
@set DOX_GENERATE_HTMLHELP=YES
@set DOX_GENERATE_TREEVIEW=NO
@set DOX_GENERATE_LATEX=NO
@set DOX_GENERATE_RTF=NO
@set DOX_GENERATE_MAN=NO
@set DOX_GENERATE_XML=NO
@set DOX_GENERATE_AUTOGEN_DEF=NO
@set DOX_SEARCHENGINE=NO


@REM --- SET THE FILES ---

@rem Execution log file
@set DOX_LOG=DoDoxygen.log

@rem HHC project file
@set DOX_HHP=%DOX_OUTPUT_DIRECTORY%\html\index.hhp


@REM --- EXECUTE ---

@echo Generating the documentation
@echo Start: %DATE% %TIME% > %DOX_LOG%
@doxygen.exe >> %DOX_LOG% 2>&1 

@echo Creating the compressed html file
@if EXIST %DOX_HHP% hhc.exe %DOX_HHP% >> %DOX_LOG%
@echo Finished: %DATE% %TIME% >> %DOX_LOG%

goto EXIT

@REM --- DISPLAY HELP ---

:HELP
@REM DISPLAY THE HELP INFO
@type Readme.txt | more
@PAUSE


@REM --- EXIT ---
:EXIT
