/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Jerzy Kaczorowski <kaczoroj@hotmail.com> --- June 2001
 */

// OptionalPropertySheet.cpp : implementation file
//

#include "stdafx.h"
#include "wincvs.h"
#include "OptionalPropertySheet.h"

#include "CvsPrefs.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// COptionalPropertySheet

IMPLEMENT_DYNAMIC(COptionalPropertySheet, CPropertySheet)

COptionalPropertySheet::COptionalPropertySheet(bool bOptionChecked, UINT nIDCaption, CWnd* pParentWnd, UINT iSelectPage)
	:CPropertySheet(nIDCaption, pParentWnd, iSelectPage)
{
	m_bOptionChecked = bOptionChecked;
}

COptionalPropertySheet::COptionalPropertySheet(bool bOptionChecked, LPCTSTR pszCaption, CWnd* pParentWnd, UINT iSelectPage)
	:CPropertySheet(pszCaption, pParentWnd, iSelectPage)
{
	m_bOptionChecked = bOptionChecked;
}

COptionalPropertySheet::~COptionalPropertySheet()
{
}


BEGIN_MESSAGE_MAP(COptionalPropertySheet, CPropertySheet)
//{{AFX_MSG_MAP(COptionalPropertySheet)
//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// COptionalPropertySheet message handlers

BOOL COptionalPropertySheet::OnInitDialog() 
{
	CPropertySheet::OnInitDialog();
	
	// Add the option check box
	CRect rectWnd;
	GetClientRect(rectWnd);
	
	rectWnd.bottom -= 13;
	rectWnd.left   += 7;
	rectWnd.top     = rectWnd.bottom - 12;
	rectWnd.right   = rectWnd.left   + 180;

	CString strOptionText;
	strOptionText.Format(_T("Display only if %s key is down"), 
		gCvsPrefs.HideCommandDlgUseShift() ? "Shift" : "Ctrl");
	m_optionCheck.Create(strOptionText, 
		WS_CHILD|WS_VISIBLE|BS_AUTOCHECKBOX|WS_TABSTOP, 
		rectWnd, this, 4);
	
	m_optionCheck.SetFont( GetFont() );
	
	// Set the checkbox
	m_optionCheck.SetCheck(m_bOptionChecked);
	
	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

int COptionalPropertySheet::DoModal() 
{
	bool bDisplayDlg = true;
	
	// See if the option flag is set
	//m_bOptionChecked = !!AfxGetApp()->GetProfileInt(PROFILE_NAME, m_psh.pszCaption, (int)false);
	
	if (m_bOptionChecked)
	{
		// See if the ctrl key is down
		bDisplayDlg = (::GetKeyState(gCvsPrefs.HideCommandDlgUseShift() ? VK_SHIFT : VK_CONTROL) < 0);
	}
	
	if (bDisplayDlg)
		return CPropertySheet::DoModal();
	else
		return IDOK;
}

BOOL COptionalPropertySheet::OnCommand(WPARAM wParam, LPARAM lParam) 
{
	if (wParam == IDOK)
	{
		// Save the check state of the display option
		m_bOptionChecked = (m_optionCheck.GetCheck() == 1);
		//AfxGetApp()->WriteProfileInt(PROFILE_NAME, m_psh.pszCaption, bChecked);
	}
	
	return CPropertySheet::OnCommand(wParam, lParam);
}

bool COptionalPropertySheet::GetHideCommandDlg()
{
	return m_bOptionChecked;
}
